/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.parallelScavenge;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.gc_implementation.shared.MutableSpace;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.runtime.VMObjectFactory;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class PSYoungGen
extends VMObject {
    private static AddressField edenSpaceField;
    private static AddressField fromSpaceField;
    private static AddressField toSpaceField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("PSYoungGen");
        edenSpaceField = type.getAddressField("_eden_space");
        fromSpaceField = type.getAddressField("_from_space");
        toSpaceField = type.getAddressField("_to_space");
    }

    public PSYoungGen(Address addr) {
        super(addr);
    }

    public MutableSpace edenSpace() {
        return (MutableSpace)VMObjectFactory.newObject(MutableSpace.class, edenSpaceField.getValue(this.addr));
    }

    public MutableSpace fromSpace() {
        return (MutableSpace)VMObjectFactory.newObject(MutableSpace.class, fromSpaceField.getValue(this.addr));
    }

    public MutableSpace toSpace() {
        return (MutableSpace)VMObjectFactory.newObject(MutableSpace.class, toSpaceField.getValue(this.addr));
    }

    public long capacity() {
        return this.edenSpace().capacity() + this.fromSpace().capacity();
    }

    public long used() {
        return this.edenSpace().used() + this.fromSpace().used();
    }

    public boolean isIn(Address a) {
        if (this.edenSpace().contains(a)) {
            return true;
        }
        return this.fromSpace().contains(a);
    }

    public void printOn(PrintStream tty) {
        tty.print("PSYoungGen [ ");
        tty.print("eden = ");
        this.edenSpace().printOn(tty);
        tty.print(", from = ");
        this.fromSpace().printOn(tty);
        tty.print(", to = ");
        this.toSpace().printOn(tty);
        tty.print(" ] ");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                PSYoungGen.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

