/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;

class UnixDirectoryStream
implements DirectoryStream<Path> {
    private final UnixPath dir;
    private final long dp;
    private final DirectoryStream.Filter<? super Path> filter;
    private final ReentrantReadWriteLock streamLock = new ReentrantReadWriteLock(true);
    private volatile boolean isClosed;
    private Iterator<Path> iterator;

    UnixDirectoryStream(UnixPath unixPath, long l, DirectoryStream.Filter<? super Path> filter) {
        this.dir = unixPath;
        this.dp = l;
        this.filter = filter;
    }

    protected final UnixPath directory() {
        return this.dir;
    }

    protected final Lock readLock() {
        return this.streamLock.readLock();
    }

    protected final Lock writeLock() {
        return this.streamLock.writeLock();
    }

    protected final boolean isOpen() {
        return !this.isClosed;
    }

    protected final boolean closeImpl() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            try {
                UnixNativeDispatcher.closedir(this.dp);
            }
            catch (UnixException unixException) {
                throw new IOException(unixException.errorString());
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.writeLock().lock();
        try {
            this.closeImpl();
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Iterator<Path> iterator(DirectoryStream<Path> directoryStream) {
        if (this.isClosed) {
            throw new IllegalStateException("Directory stream is closed");
        }
        UnixDirectoryStream unixDirectoryStream = this;
        synchronized (unixDirectoryStream) {
            if (this.iterator != null) {
                throw new IllegalStateException("Iterator already obtained");
            }
            this.iterator = new UnixDirectoryIterator(directoryStream);
            return this.iterator;
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.iterator(this);
    }

    private class UnixDirectoryIterator
    implements Iterator<Path> {
        private final DirectoryStream<Path> stream;
        private boolean atEof = false;
        private Path nextEntry;

        UnixDirectoryIterator(DirectoryStream<Path> directoryStream) {
            this.stream = directoryStream;
        }

        private boolean isSelfOrParent(byte[] byArray) {
            return byArray[0] == 46 && (byArray.length == 1 || byArray.length == 2 && byArray[1] == 46);
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Path readNextEntry() {
            assert (Thread.holdsLock(this));
            while (true) {
                byte[] byArray = null;
                UnixDirectoryStream.this.readLock().lock();
                try {
                    if (UnixDirectoryStream.this.isOpen()) {
                        byArray = UnixNativeDispatcher.readdir(UnixDirectoryStream.this.dp);
                    }
                }
                catch (UnixException unixException) {
                    IOException iOException = unixException.asIOException(UnixDirectoryStream.this.dir);
                    throw new DirectoryIteratorException(iOException);
                }
                finally {
                    UnixDirectoryStream.this.readLock().unlock();
                }
                if (byArray == null) {
                    this.atEof = true;
                    return null;
                }
                if (this.isSelfOrParent(byArray)) continue;
                UnixPath unixPath = UnixDirectoryStream.this.dir.resolve(byArray);
                if (UnixDirectoryStream.this.filter == null || UnixDirectoryStream.this.filter.accept(unixPath)) return unixPath;
                continue;
                break;
            }
            catch (IOException iOException) {
                throw new DirectoryIteratorException(iOException);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.nextEntry == null && !this.atEof) {
                this.nextEntry = this.readNextEntry();
            }
            return this.nextEntry != null;
        }

        @Override
        public synchronized Path next() {
            Path path;
            if (this.nextEntry == null && !this.atEof) {
                path = this.readNextEntry();
            } else {
                path = this.nextEntry;
                this.nextEntry = null;
            }
            if (path == null) {
                throw new NoSuchElementException();
            }
            return path;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

