/*
 * Decompiled with CFR 0.152.
 */
package java.time.chrono;

import java.time.Clock;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.chrono.AbstractChronology;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoLocalDateTimeImpl;
import java.time.chrono.ChronoPeriod;
import java.time.chrono.ChronoPeriodImpl;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.ChronoZonedDateTimeImpl;
import java.time.chrono.Era;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.time.temporal.ValueRange;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface Chronology
extends Comparable<Chronology> {
    public static Chronology from(TemporalAccessor temporalAccessor) {
        Objects.requireNonNull(temporalAccessor, "temporal");
        Chronology chronology = temporalAccessor.query(TemporalQueries.chronology());
        return chronology != null ? chronology : IsoChronology.INSTANCE;
    }

    public static Chronology ofLocale(Locale locale) {
        return AbstractChronology.ofLocale(locale);
    }

    public static Chronology of(String string) {
        return AbstractChronology.of(string);
    }

    public static Set<Chronology> getAvailableChronologies() {
        return AbstractChronology.getAvailableChronologies();
    }

    public String getId();

    public String getCalendarType();

    default public ChronoLocalDate date(Era era, int n, int n2, int n3) {
        return this.date(this.prolepticYear(era, n), n2, n3);
    }

    public ChronoLocalDate date(int var1, int var2, int var3);

    default public ChronoLocalDate dateYearDay(Era era, int n, int n2) {
        return this.dateYearDay(this.prolepticYear(era, n), n2);
    }

    public ChronoLocalDate dateYearDay(int var1, int var2);

    public ChronoLocalDate dateEpochDay(long var1);

    default public ChronoLocalDate dateNow() {
        return this.dateNow(Clock.systemDefaultZone());
    }

    default public ChronoLocalDate dateNow(ZoneId zoneId) {
        return this.dateNow(Clock.system(zoneId));
    }

    default public ChronoLocalDate dateNow(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        return this.date(LocalDate.now(clock));
    }

    public ChronoLocalDate date(TemporalAccessor var1);

    default public ChronoLocalDateTime<? extends ChronoLocalDate> localDateTime(TemporalAccessor temporalAccessor) {
        try {
            return this.date(temporalAccessor).atTime(LocalTime.from(temporalAccessor));
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ChronoLocalDateTime from TemporalAccessor: " + temporalAccessor.getClass(), dateTimeException);
        }
    }

    default public ChronoZonedDateTime<? extends ChronoLocalDate> zonedDateTime(TemporalAccessor temporalAccessor) {
        try {
            ZoneId zoneId = ZoneId.from(temporalAccessor);
            try {
                Instant instant = Instant.from(temporalAccessor);
                return this.zonedDateTime(instant, zoneId);
            }
            catch (DateTimeException dateTimeException) {
                ChronoLocalDateTimeImpl chronoLocalDateTimeImpl = ChronoLocalDateTimeImpl.ensureValid(this, this.localDateTime(temporalAccessor));
                return ChronoZonedDateTimeImpl.ofBest(chronoLocalDateTimeImpl, zoneId, null);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new DateTimeException("Unable to obtain ChronoZonedDateTime from TemporalAccessor: " + temporalAccessor.getClass(), dateTimeException);
        }
    }

    default public ChronoZonedDateTime<? extends ChronoLocalDate> zonedDateTime(Instant instant, ZoneId zoneId) {
        return ChronoZonedDateTimeImpl.ofInstant(this, instant, zoneId);
    }

    public boolean isLeapYear(long var1);

    public int prolepticYear(Era var1, int var2);

    public Era eraOf(int var1);

    public List<Era> eras();

    public ValueRange range(ChronoField var1);

    default public String getDisplayName(TextStyle textStyle, Locale locale) {
        TemporalAccessor temporalAccessor = new TemporalAccessor(){

            @Override
            public boolean isSupported(TemporalField temporalField) {
                return false;
            }

            @Override
            public long getLong(TemporalField temporalField) {
                throw new UnsupportedTemporalTypeException("Unsupported field: " + temporalField);
            }

            @Override
            public <R> R query(TemporalQuery<R> temporalQuery) {
                if (temporalQuery == TemporalQueries.chronology()) {
                    return (R)Chronology.this;
                }
                return TemporalAccessor.super.query(temporalQuery);
            }
        };
        return new DateTimeFormatterBuilder().appendChronologyText(textStyle).toFormatter(locale).format(temporalAccessor);
    }

    public ChronoLocalDate resolveDate(Map<TemporalField, Long> var1, ResolverStyle var2);

    default public ChronoPeriod period(int n, int n2, int n3) {
        return new ChronoPeriodImpl(this, n, n2, n3);
    }

    @Override
    public int compareTo(Chronology var1);

    public boolean equals(Object var1);

    public int hashCode();

    public String toString();
}

