/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();
    private static final int GZIP_MAGIC = 35615;
    private static final int TRAILER_SIZE = 8;

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        this(outputStream, n, false);
    }

    public GZIPOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        super(outputStream, new Deflater(-1, true), n, bl);
        this.usesDefaultDeflater = true;
        this.writeHeader();
        this.crc.reset();
    }

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 512, false);
    }

    public GZIPOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        this(outputStream, 512, bl);
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    @Override
    public void finish() throws IOException {
        if (!this.def.finished()) {
            try {
                this.def.finish();
                while (!this.def.finished()) {
                    int n = this.def.deflate(this.buf, 0, this.buf.length);
                    if (this.def.finished() && n <= this.buf.length - 8) {
                        this.writeTrailer(this.buf, n);
                        this.out.write(this.buf, 0, n += 8);
                        return;
                    }
                    if (n <= 0) continue;
                    this.out.write(this.buf, 0, n);
                }
                byte[] byArray = new byte[8];
                this.writeTrailer(byArray, 0);
                this.out.write(byArray);
            }
            catch (IOException iOException) {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
                throw iOException;
            }
        }
    }

    private void writeHeader() throws IOException {
        this.out.write(new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0});
    }

    private void writeTrailer(byte[] byArray, int n) throws IOException {
        this.writeInt((int)this.crc.getValue(), byArray, n);
        this.writeInt(this.def.getTotalIn(), byArray, n + 4);
    }

    private void writeInt(int n, byte[] byArray, int n2) throws IOException {
        this.writeShort(n & 0xFFFF, byArray, n2);
        this.writeShort(n >> 16 & 0xFFFF, byArray, n2 + 2);
    }

    private void writeShort(int n, byte[] byArray, int n2) throws IOException {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
    }
}

