/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AlgorithmParameters;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.ssl.JsseJce;

public final class RSASignature
extends SignatureSpi {
    private final Signature rawRsa = JsseJce.getSignature("NONEwithRSA");
    private final MessageDigest mdMD5 = JsseJce.getMessageDigest("MD5");
    private final MessageDigest mdSHA = JsseJce.getMessageDigest("SHA");

    static Signature getInstance() throws NoSuchAlgorithmException {
        return JsseJce.getSignature("MD5andSHA1withRSA");
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Public key must not be null");
        }
        this.mdMD5.reset();
        this.mdSHA.reset();
        this.rawRsa.initVerify(publicKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Private key must not be null");
        }
        this.mdMD5.reset();
        this.mdSHA.reset();
        this.rawRsa.initSign(privateKey, secureRandom);
    }

    @Override
    protected void engineUpdate(byte by) {
        this.mdMD5.update(by);
        this.mdSHA.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.mdMD5.update(byArray, n, n2);
        this.mdSHA.update(byArray, n, n2);
    }

    private byte[] getDigest() throws SignatureException {
        try {
            byte[] byArray = new byte[36];
            this.mdMD5.digest(byArray, 0, 16);
            this.mdSHA.digest(byArray, 16, 20);
            return byArray;
        }
        catch (DigestException digestException) {
            throw new SignatureException(digestException);
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.sign();
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.engineVerify(byArray, 0, byArray.length);
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        this.rawRsa.update(this.getDigest());
        return this.rawRsa.verify(byArray, n, n2);
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameters not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("No parameters accepted");
        }
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameters not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }
}

