/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import java.io.UnsupportedEncodingException;

public final class BerDecoder
extends Ber {
    private int origOffset;

    public BerDecoder(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.bufsize = n2;
        this.origOffset = n;
        this.reset();
    }

    public void reset() {
        this.offset = this.origOffset;
    }

    public int getParsePosition() {
        return this.offset;
    }

    public int parseLength() throws Ber.DecodeException {
        int n = this.parseByte();
        if ((n & 0x80) == 128) {
            if ((n &= 0x7F) == 0) {
                throw new Ber.DecodeException("Indefinite length not supported");
            }
            if (n > 4) {
                throw new Ber.DecodeException("encoding too long");
            }
            if (this.bufsize - this.offset < n) {
                throw new Ber.DecodeException("Insufficient data");
            }
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                n2 = (n2 << 8) + (this.buf[this.offset++] & 0xFF);
            }
            if (n2 < 0) {
                throw new Ber.DecodeException("Invalid length bytes");
            }
            return n2;
        }
        return n;
    }

    public int parseSeq(int[] nArray) throws Ber.DecodeException {
        int n = this.parseByte();
        int n2 = this.parseLength();
        if (nArray != null) {
            nArray[0] = n2;
        }
        return n;
    }

    void seek(int n) throws Ber.DecodeException {
        if (this.offset + n > this.bufsize || this.offset + n < 0) {
            throw new Ber.DecodeException("array index out of bounds");
        }
        this.offset += n;
    }

    public int parseByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset++] & 0xFF;
    }

    public int peekByte() throws Ber.DecodeException {
        if (this.bufsize - this.offset < 1) {
            throw new Ber.DecodeException("Insufficient data");
        }
        return this.buf[this.offset] & 0xFF;
    }

    public boolean parseBoolean() throws Ber.DecodeException {
        return this.parseIntWithTag(1) != 0;
    }

    public int parseEnumeration() throws Ber.DecodeException {
        return this.parseIntWithTag(10);
    }

    public int parseInt() throws Ber.DecodeException {
        return this.parseIntWithTag(2);
    }

    private int parseIntWithTag(int n) throws Ber.DecodeException {
        if (this.parseByte() != n) {
            String string = this.offset > 0 ? Integer.toString(this.buf[this.offset - 1] & 0xFF) : "Empty tag";
            throw new Ber.DecodeException("Encountered ASN.1 tag " + string + " (expected tag " + Integer.toString(n) + ")");
        }
        int n2 = this.parseLength();
        if (n2 > 4) {
            throw new Ber.DecodeException("INTEGER too long");
        }
        if (n2 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte by = this.buf[this.offset++];
        int n3 = 0;
        n3 = by & 0x7F;
        for (int i = 1; i < n2; ++i) {
            n3 <<= 8;
            n3 |= this.buf[this.offset++] & 0xFF;
        }
        if ((by & 0x80) == 128) {
            n3 = -n3;
        }
        return n3;
    }

    public String parseString(boolean bl) throws Ber.DecodeException {
        return this.parseStringWithTag(4, bl, null);
    }

    public String parseStringWithTag(int n, boolean bl, int[] nArray) throws Ber.DecodeException {
        String string;
        int n2 = this.offset;
        int n3 = this.parseByte();
        if (n3 != n) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString((byte)n3) + " (expected tag " + n + ")");
        }
        int n4 = this.parseLength();
        if (n4 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        if (n4 == 0) {
            string = "";
        } else {
            byte[] byArray = new byte[n4];
            System.arraycopy(this.buf, this.offset, byArray, 0, n4);
            if (bl) {
                try {
                    string = new String(byArray, "UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new Ber.DecodeException("UTF8 not available on platform");
                }
            }
            try {
                string = new String(byArray, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new Ber.DecodeException("8859_1 not available on platform");
            }
            this.offset += n4;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n2;
        }
        return string;
    }

    public byte[] parseOctetString(int n, int[] nArray) throws Ber.DecodeException {
        int n2 = this.offset;
        int n3 = this.parseByte();
        if (n3 != n) {
            throw new Ber.DecodeException("Encountered ASN.1 tag " + Integer.toString(n3) + " (expected tag " + Integer.toString(n) + ")");
        }
        int n4 = this.parseLength();
        if (n4 > this.bufsize - this.offset) {
            throw new Ber.DecodeException("Insufficient data");
        }
        byte[] byArray = new byte[n4];
        if (n4 > 0) {
            System.arraycopy(this.buf, this.offset, byArray, 0, n4);
            this.offset += n4;
        }
        if (nArray != null) {
            nArray[0] = this.offset - n2;
        }
        return byArray;
    }

    public int bytesLeft() {
        return this.bufsize - this.offset;
    }
}

