/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.ByteBuffer;
import sun.misc.Cleaner;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.Util;

class IOVecWrapper {
    private static final int BASE_OFFSET = 0;
    private static final int LEN_OFFSET;
    private static final int SIZE_IOVEC;
    private final AllocatedNativeObject vecArray;
    private final int size;
    private final ByteBuffer[] buf;
    private final int[] position;
    private final int[] remaining;
    private final ByteBuffer[] shadow;
    final long address;
    static int addressSize;
    private static final ThreadLocal<IOVecWrapper> cached;

    private IOVecWrapper(int n) {
        this.size = n;
        this.buf = new ByteBuffer[n];
        this.position = new int[n];
        this.remaining = new int[n];
        this.shadow = new ByteBuffer[n];
        this.vecArray = new AllocatedNativeObject(n * SIZE_IOVEC, false);
        this.address = this.vecArray.address();
    }

    static IOVecWrapper get(int n) {
        IOVecWrapper iOVecWrapper = cached.get();
        if (iOVecWrapper != null && iOVecWrapper.size < n) {
            iOVecWrapper.vecArray.free();
            iOVecWrapper = null;
        }
        if (iOVecWrapper == null) {
            iOVecWrapper = new IOVecWrapper(n);
            Cleaner.create(iOVecWrapper, new Deallocator(iOVecWrapper.vecArray));
            cached.set(iOVecWrapper);
        }
        return iOVecWrapper;
    }

    void setBuffer(int n, ByteBuffer byteBuffer, int n2, int n3) {
        this.buf[n] = byteBuffer;
        this.position[n] = n2;
        this.remaining[n] = n3;
    }

    void setShadow(int n, ByteBuffer byteBuffer) {
        this.shadow[n] = byteBuffer;
    }

    ByteBuffer getBuffer(int n) {
        return this.buf[n];
    }

    int getPosition(int n) {
        return this.position[n];
    }

    int getRemaining(int n) {
        return this.remaining[n];
    }

    ByteBuffer getShadow(int n) {
        return this.shadow[n];
    }

    void clearRefs(int n) {
        this.buf[n] = null;
        this.shadow[n] = null;
    }

    void putBase(int n, long l) {
        int n2 = SIZE_IOVEC * n + 0;
        if (addressSize == 4) {
            this.vecArray.putInt(n2, (int)l);
        } else {
            this.vecArray.putLong(n2, l);
        }
    }

    void putLen(int n, long l) {
        int n2 = SIZE_IOVEC * n + LEN_OFFSET;
        if (addressSize == 4) {
            this.vecArray.putInt(n2, (int)l);
        } else {
            this.vecArray.putLong(n2, l);
        }
    }

    static {
        cached = new ThreadLocal();
        LEN_OFFSET = addressSize = Util.unsafe().addressSize();
        SIZE_IOVEC = (short)(addressSize * 2);
    }

    private static class Deallocator
    implements Runnable {
        private final AllocatedNativeObject obj;

        Deallocator(AllocatedNativeObject allocatedNativeObject) {
            this.obj = allocatedNativeObject;
        }

        @Override
        public void run() {
            this.obj.free();
        }
    }
}

