/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpUtils;

public class SignatureHelpContext {
    private int completionOffset = -1;
    private int secondaryCompletionOffset = -1;
    private List<int[]> argumentRanges = new ArrayList<int[]>();
    private String methodName;
    private List<Expression> arguments;
    private String[] parameterTypes;
    private String[] parameterTypesFromBinding;
    private ASTNode targetNode;

    public void resolve(int triggerOffset, ICompilationUnit unit, IProgressMonitor monitor) throws JavaModelException {
        CompilationUnit root = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
        if (root == null || monitor.isCanceled()) {
            return;
        }
        this.findTargetNode((ASTNode)root, unit, triggerOffset);
        this.resolveMethodName(this.targetNode);
        this.arguments = this.resolveArguments(this.targetNode);
        this.resolveParameterTypes(this.targetNode);
        this.guessCompletionOffset(this.targetNode, unit);
        this.guessArgumentRanges(unit, this.completionOffset);
    }

    private void findTargetNode(ASTNode root, ICompilationUnit unit, int triggerOffset) throws JavaModelException {
        ASTNode node;
        if (root == null) {
            return;
        }
        String source = unit.getSource();
        if (source == null || triggerOffset >= source.length()) {
            return;
        }
        int searchOffset = triggerOffset;
        while (searchOffset > 0) {
            char cur = source.charAt(searchOffset);
            char prev = source.charAt(searchOffset - 1);
            if (Character.isWhitespace(cur) && prev != ';') {
                --searchOffset;
                continue;
            }
            if (cur != ')' || !Character.isWhitespace(prev) && prev != ',') break;
            --searchOffset;
        }
        if ((node = this.findMethodLikeNode(root, searchOffset = searchOffset <= 0 ? triggerOffset : searchOffset)) == null) {
            return;
        }
        this.targetNode = this.findEnclosingMethodNode(node, source, searchOffset);
    }

    private ASTNode findMethodLikeNode(ASTNode root, int offset) {
        ASTNode node = NodeFinder.perform((ASTNode)root, (int)offset, (int)0);
        while (node != null && !(node instanceof Block)) {
            if (this.isMethodLikeNode(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private boolean isMethodLikeNode(ASTNode node) {
        return node instanceof MethodInvocation || node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation || node instanceof ConstructorInvocation || node instanceof SuperMethodInvocation || node instanceof MethodRef;
    }

    private ASTNode findEnclosingMethodNode(ASTNode node, String source, int offset) {
        if (this.isInArgumentList(node, source, offset)) {
            return node;
        }
        ASTNode parent = node.getParent();
        while (parent != null && !(parent instanceof Block)) {
            if (this.isMethodLikeNode(parent) && this.isInArgumentList(parent, source, offset)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return node;
    }

    private boolean isInArgumentList(ASTNode node, String source, int offset) {
        int[] argumentRange = this.findArgumentRange(node, source);
        if (argumentRange == null || argumentRange.length < 2) {
            return false;
        }
        return argumentRange[0] <= offset && argumentRange[1] >= offset;
    }

    private int[] findArgumentRange(ASTNode node, String source) {
        List<Expression> arguments = this.resolveArguments(node);
        if (arguments == null) {
            return null;
        }
        if (arguments.size() > 0) {
            Expression firstArg = arguments.get(0);
            Expression lastArg = arguments.get(arguments.size() - 1);
            return new int[]{firstArg.getStartPosition(), lastArg.getStartPosition() + lastArg.getLength()};
        }
        SimpleName simpleNameNode = null;
        if (node instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)node;
            simpleNameNode = methodInvocation.getName();
        } else if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            simpleNameNode = classInstanceCreation.getType();
        } else if (node instanceof SuperMethodInvocation) {
            SuperMethodInvocation superInvocation = (SuperMethodInvocation)node;
            simpleNameNode = superInvocation.getName();
        } else if (node instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)node;
            simpleNameNode = methodRef.getName();
        } else if (node instanceof ConstructorInvocation) {
            simpleNameNode = node;
        } else if (node instanceof SuperConstructorInvocation) {
            simpleNameNode = node;
        }
        if (simpleNameNode == null) {
            return null;
        }
        int i = simpleNameNode.getStartPosition() + simpleNameNode.getLength();
        while (i < node.getStartPosition() + node.getLength()) {
            if (source.charAt(i) == '(') {
                return new int[]{i + 1, node.getStartPosition() + node.getLength() - 1};
            }
            ++i;
        }
        return null;
    }

    private void resolveMethodName(ASTNode node) {
        SuperConstructorInvocation superConstructorInvocation;
        IMethodBinding binding;
        if (node == null) {
            return;
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)node;
            this.methodName = methodInvocation.getName().getIdentifier();
        } else if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            ITypeBinding binding2 = classInstanceCreation.getType().resolveBinding();
            if (binding2 != null) {
                this.methodName = binding2.getErasure().getName();
            }
        } else if (node instanceof SuperMethodInvocation) {
            SuperMethodInvocation superInvocation = (SuperMethodInvocation)node;
            this.methodName = superInvocation.getName().getIdentifier();
        } else if (node instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)node;
            this.methodName = methodRef.getName().getIdentifier();
        } else if (node instanceof ConstructorInvocation) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)node;
            IMethodBinding binding3 = constructorInvocation.resolveConstructorBinding();
            if (binding3 != null) {
                this.methodName = binding3.getDeclaringClass().getName();
            }
        } else if (node instanceof SuperConstructorInvocation && (binding = (superConstructorInvocation = (SuperConstructorInvocation)node).resolveConstructorBinding()) != null) {
            this.methodName = binding.getDeclaringClass().getName();
        }
    }

    private List<Expression> resolveArguments(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)node;
            return methodInvocation.arguments();
        }
        if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            return classInstanceCreation.arguments();
        }
        if (node instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)node;
            return superMethodInvocation.arguments();
        }
        if (node instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)node;
            return methodRef.parameters();
        }
        if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)node;
            return superConstructorInvocation.arguments();
        }
        if (node instanceof ConstructorInvocation) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)node;
            return constructorInvocation.arguments();
        }
        return null;
    }

    private void resolveParameterTypes(ASTNode node) {
        IMethod method;
        if (node == null) {
            return;
        }
        IMethodBinding binding = null;
        if (node instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)node;
            binding = methodInvocation.resolveMethodBinding();
        } else if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            binding = classInstanceCreation.resolveConstructorBinding();
        } else if (node instanceof SuperMethodInvocation) {
            SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)node;
            binding = superMethodInvocation.resolveMethodBinding();
        } else if (node instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)node;
            binding = methodRef.resolveBinding();
        } else if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)node;
            binding = superConstructorInvocation.resolveConstructorBinding();
        } else if (node instanceof ConstructorInvocation) {
            ConstructorInvocation constructorInvocation = (ConstructorInvocation)node;
            binding = constructorInvocation.resolveConstructorBinding();
        }
        if (binding == null) {
            return;
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding methodBinding = binding;
            if (methodBinding.isDefaultConstructor()) {
                this.parameterTypes = new String[0];
                return;
            }
            this.parameterTypesFromBinding = (String[])Arrays.stream(methodBinding.getParameterTypes()).map(type -> {
                String unqualifiedName = type.getErasure().getName();
                return unqualifiedName.replace(";", "");
            }).toArray(String[]::new);
        }
        if ((method = (IMethod)binding.getJavaElement()) != null) {
            this.parameterTypes = (String[])Arrays.stream(method.getParameterTypes()).map(signature -> SignatureHelpUtils.getSimpleTypeName(signature)).toArray(String[]::new);
        }
    }

    private void guessCompletionOffset(ASTNode node, ICompilationUnit unit) throws JavaModelException {
        IBuffer buffer = unit.getBuffer();
        if (node == null || buffer == null) {
            this.completionOffset = -1;
            return;
        }
        int startPosition = node.getStartPosition();
        int endPosition = startPosition + node.getLength();
        int i = startPosition += this.getOptionalExpressionLength(node);
        while (i < endPosition) {
            if (buffer.getChar(i) == '(') {
                if (node instanceof MethodInvocation || node instanceof SuperMethodInvocation || node instanceof MethodRef) {
                    this.completionOffset = i;
                    this.secondaryCompletionOffset = i + 1;
                    return;
                }
                if (node instanceof ClassInstanceCreation || node instanceof ConstructorInvocation || node instanceof SuperConstructorInvocation) {
                    this.completionOffset = i + 1;
                    return;
                }
            }
            ++i;
        }
    }

    private int getOptionalExpressionLength(ASTNode node) {
        Expression optionalExpression = null;
        if (node instanceof MethodInvocation) {
            MethodInvocation methodInvocation = (MethodInvocation)node;
            optionalExpression = methodInvocation.getExpression();
        } else if (node instanceof ClassInstanceCreation) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)node;
            optionalExpression = classInstanceCreation.getExpression();
        } else if (node instanceof SuperConstructorInvocation) {
            SuperConstructorInvocation superConstructorInvocation = (SuperConstructorInvocation)node;
            optionalExpression = superConstructorInvocation.getExpression();
        }
        if (optionalExpression == null) {
            return 0;
        }
        return optionalExpression.getLength();
    }

    private void guessArgumentRanges(ICompilationUnit unit, int completionOffset) throws JavaModelException {
        IBuffer buffer = unit.getBuffer();
        if (buffer == null || completionOffset == -1) {
            return;
        }
        int argumentStartPosition = completionOffset;
        if (buffer.getChar(argumentStartPosition) == '(') {
            ++argumentStartPosition;
        }
        String argumentLiterals = buffer.getText(argumentStartPosition, buffer.getLength() - argumentStartPosition);
        ArrayList<int[]> list = new ArrayList<int[]>();
        int[] argumentRange = new int[]{argumentStartPosition, argumentStartPosition};
        Stack<Character> stack = new Stack<Character>();
        boolean hasArgument = false;
        int i = 0;
        while (i < argumentLiterals.length()) {
            char c = argumentLiterals.charAt(i);
            if (!hasArgument && this.isArgumentChar(c)) {
                hasArgument = true;
            }
            block0 : switch (c) {
                case ',': {
                    if (!stack.isEmpty()) break;
                    argumentRange[1] = argumentStartPosition + i;
                    list.add(argumentRange);
                    argumentRange = new int[]{argumentStartPosition + i + 1, argumentStartPosition + i + 1};
                    break;
                }
                case '\'': {
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '\'') break block0;
                        if (c == '\\') {
                            i += 2;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                case '\"': {
                    String textBlockStart = argumentLiterals.substring(i, i + 3);
                    if (textBlockStart.equals("\"\"\"")) {
                        int endIndex = argumentLiterals.indexOf("\"\"\"", i + 3);
                        while (endIndex > 0 && argumentLiterals.charAt(endIndex - 1) == '\\') {
                            endIndex = argumentLiterals.indexOf("\"\"\"", endIndex + 3);
                        }
                        if (endIndex > 0) {
                            i = endIndex + 2;
                            break;
                        }
                        i = argumentLiterals.length() - 1;
                        break;
                    }
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '\"') break block0;
                        if (c == '\\') {
                            i += 2;
                            continue;
                        }
                        ++i;
                    }
                    break;
                }
                case '(': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case ')': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '(') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '[': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case ']': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '[') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '{': {
                    stack.add(Character.valueOf(c));
                    break;
                }
                case '}': {
                    if (!stack.isEmpty() && ((Character)stack.peek()).charValue() == '{') {
                        stack.pop();
                        break;
                    }
                    if (hasArgument) {
                        argumentRange[1] = argumentStartPosition + i;
                        list.add(argumentRange);
                    }
                    this.argumentRanges = list;
                    return;
                }
                case '<': {
                    ++i;
                    while (i < argumentLiterals.length()) {
                        c = argumentLiterals.charAt(i);
                        if (c == '>') break block0;
                        ++i;
                    }
                    break;
                }
            }
            ++i;
        }
        if (hasArgument) {
            argumentRange[1] = argumentStartPosition + argumentLiterals.length() - 1;
            list.add(argumentRange);
        }
        this.argumentRanges = list;
    }

    private boolean isArgumentChar(char c) {
        return !Character.isWhitespace(c) && c != ')' && c != ']' && c != '}' & c != ';';
    }

    public int completionOffset() {
        return this.completionOffset;
    }

    public int secondaryCompletionOffset() {
        return this.secondaryCompletionOffset;
    }

    public List<int[]> argumentRanges() {
        return this.argumentRanges;
    }

    public String methodName() {
        return this.methodName;
    }

    public List<Expression> arguments() {
        return this.arguments;
    }

    public String[] parameterTypes() {
        return this.parameterTypes;
    }

    public String[] parameterTypesFromBinding() {
        return this.parameterTypesFromBinding;
    }

    public ASTNode targetNode() {
        return this.targetNode;
    }
}

