/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class InternalWorkspaceJob
extends Job {
    private Workspace workspace;

    public InternalWorkspaceJob(String name, Workspace workspace) {
        super(name);
        this.workspace = workspace;
    }

    @Override
    public final IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        block9: {
            monitor = Policy.monitorFor(monitor);
            int depth = -1;
            WorkManager workManager = this.workspace.getWorkManager();
            try {
                this.workspace.prepareOperation(null, monitor);
                this.workspace.beginOperation(true);
                depth = workManager.beginUnprotected();
                iStatus = this.runInWorkspace(monitor);
                if (depth < 0) break block9;
            }
            catch (OperationCanceledException operationCanceledException) {
                IStatus iStatus2;
                block10: {
                    try {
                        workManager.operationCanceled();
                        iStatus2 = Status.CANCEL_STATUS;
                        if (depth < 0) break block10;
                        workManager.endUnprotected(depth);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (depth >= 0) {
                                workManager.endUnprotected(depth);
                            }
                            this.workspace.endOperation(null, false);
                            throw throwable;
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                    }
                }
                this.workspace.endOperation(null, false);
                return iStatus2;
            }
            workManager.endUnprotected(depth);
        }
        this.workspace.endOperation(null, false);
        return iStatus;
    }

    protected abstract IStatus runInWorkspace(IProgressMonitor var1) throws CoreException;
}

