/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.OrganizeImportsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.StringRangeFinder;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PasteEventHandler {
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});

    public static DocumentPasteEdit handlePasteEvent(PasteEventParams params, IProgressMonitor monitor) {
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(params.getLocation().getUri());
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setSource(cu);
        parser.setResolveBindings(false);
        parser.setStatementsRecovery(true);
        CompilationUnit ast = (CompilationUnit)parser.createAST(monitor);
        DocumentPasteEdit edit = PasteEventHandler.handleStringPasteEvent(params, cu, ast, monitor);
        if (edit == null) {
            try {
                edit = PasteEventHandler.getMissingImportsWorkspaceEdit(params, cu, monitor);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return edit;
    }

    private static DocumentPasteEdit handleStringPasteEvent(PasteEventParams params, ICompilationUnit cu, CompilationUnit ast, IProgressMonitor monitor) {
        String newText;
        IBuffer buffer;
        StringRangeFinder finder = new StringRangeFinder(cu, params.getLocation().getRange());
        ast.accept((ASTVisitor)finder);
        if (!finder.isWithin()) {
            return null;
        }
        int stringStart = finder.getStringLiteral().getStartPosition();
        int lineNumber = ast.getLineNumber(stringStart);
        int lineStartOffset = ast.getPosition(lineNumber, 0);
        boolean isTabs = !params.getFormattingOptions().isInsertSpaces();
        int tabSize = params.getFormattingOptions().getTabSize();
        try {
            buffer = cu.getBuffer();
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error while accessing buffer while handling paste event", e);
            return null;
        }
        String text = buffer.getContents();
        StringBuilder leadingIndentationBuffer = new StringBuilder();
        int i = lineStartOffset;
        while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
            leadingIndentationBuffer.append(text.charAt(i));
            ++i;
        }
        if (isTabs) {
            leadingIndentationBuffer.append("\t\t");
        } else {
            i = 0;
            while (i < 2 * tabSize) {
                leadingIndentationBuffer.append(' ');
                ++i;
            }
        }
        String leadingIndentation = leadingIndentationBuffer.toString();
        String eol = PasteEventHandler.getEol(text);
        String pastedText = params.getText();
        if (pastedText.contains("\n") || pastedText.contains("\r")) {
            String crlfMarker = "\ue000";
            String lfMarker = "\ue001";
            String crMarker = "\ue002";
            String textWithMarkers = pastedText.replace("\r\n", crlfMarker).replace("\n", lfMarker).replace("\r", crMarker);
            String escaped = ESCAPE_JAVA.translate((CharSequence)textWithMarkers);
            String crlfPattern = "\\r\\n\" + //" + eol + leadingIndentation + "\"";
            String lfPattern = "\\n\" + //" + eol + leadingIndentation + "\"";
            String crPattern = "\\r\" + //" + eol + leadingIndentation + "\"";
            newText = escaped.replace(crlfMarker, crlfPattern).replace(lfMarker, lfPattern).replace(crMarker, crPattern);
        } else {
            newText = ESCAPE_JAVA.translate((CharSequence)pastedText);
        }
        return new DocumentPasteEdit(newText);
    }

    public static DocumentPasteEdit getMissingImportsWorkspaceEdit(PasteEventParams params, ICompilationUnit cu, IProgressMonitor monitor) throws CoreException {
        TextEdit edit;
        Range range = params.getLocation().getRange();
        String originalDocumentUri = params.getCopiedDocumentUri();
        String insertText = params.getText();
        if (params.getLocation().getUri().equals(originalDocumentUri)) {
            return null;
        }
        IType primaryType = cu.findPrimaryType();
        if (primaryType == null) {
            return null;
        }
        ISourceRange sourceRange = primaryType.getSourceRange();
        if (sourceRange == null) {
            return null;
        }
        int offset = JsonRpcHelpers.toOffset((IOpenable)cu, range.getStart().getLine(), range.getStart().getCharacter());
        int length = JsonRpcHelpers.toOffset((IOpenable)cu, range.getEnd().getLine(), range.getEnd().getCharacter()) - offset;
        if (offset <= sourceRange.getOffset() || offset + length >= sourceRange.getOffset() + sourceRange.getLength()) {
            return null;
        }
        Function<OrganizeImportsHandler.ImportSelection[], OrganizeImportsHandler.ImportCandidate[]> chooseFunc = null;
        ICompilationUnit tempUnit = RenameAnalyzeUtil.createNewWorkingCopy((ICompilationUnit)cu, (TextChangeManager)new TextChangeManager(true), (WorkingCopyOwner)new WorkingCopyOwner(){}, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)(monitor == null ? new NullProgressMonitor() : monitor), 1));
        tempUnit.applyTextEdit((TextEdit)new ReplaceEdit(offset, length, insertText), monitor);
        if (originalDocumentUri != null) {
            IClassFile classFile;
            ICompilationUnit tempOriginalUnit = JDTUtils.resolveCompilationUnit(originalDocumentUri);
            boolean isClassFile = false;
            if (tempOriginalUnit == null && (classFile = JDTUtils.resolveClassFile(originalDocumentUri)) != null) {
                isClassFile = true;
                tempOriginalUnit = classFile.getWorkingCopy(new WorkingCopyOwner(){}, monitor);
            }
            if (tempOriginalUnit != null) {
                Set names = Arrays.stream(tempOriginalUnit.getImports()).map(importDecl -> importDecl.getElementName()).filter(name -> name != null).collect(Collectors.toSet());
                chooseFunc = selections -> {
                    ArrayList<OrganizeImportsHandler.ImportCandidate> candidates = new ArrayList<OrganizeImportsHandler.ImportCandidate>();
                    OrganizeImportsHandler.ImportSelection[] importSelectionArray = selections;
                    int n = ((OrganizeImportsHandler.ImportSelection[])selections).length;
                    int n2 = 0;
                    while (n2 < n) {
                        OrganizeImportsHandler.ImportSelection selection = importSelectionArray[n2];
                        OrganizeImportsHandler.ImportCandidate[] importCandidateArray = selection.candidates;
                        int n3 = selection.candidates.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            OrganizeImportsHandler.ImportCandidate candidate = importCandidateArray[n4];
                            if (names.contains(candidate.fullyQualifiedName)) {
                                candidates.add(candidate);
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    return candidates.toArray(new OrganizeImportsHandler.ImportCandidate[0]);
                };
            }
            if (isClassFile) {
                tempOriginalUnit.discardWorkingCopy();
            }
        }
        if ((edit = OrganizeImportsHandler.organizeImports(tempUnit, chooseFunc, true, monitor)) == null) {
            return null;
        }
        WorkspaceEdit workspaceEdit = SourceAssistProcessor.convertToWorkspaceEdit(tempUnit, edit);
        tempUnit.discardWorkingCopy();
        return new DocumentPasteEdit(insertText, workspaceEdit);
    }

    private static String getEol(String text) {
        return text.contains("\r\n") ? "\r\n" : "\n";
    }

    public static String handleFilePasteEvent(String path, String content, IProgressMonitor monitor) throws JavaModelException {
        String desiredPath = "";
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setResolveBindings(false);
        parser.setKind(8);
        parser.setBindingsRecovery(false);
        parser.setIgnoreMethodBodies(true);
        Hashtable javaOptions = JavaCore.getOptions();
        parser.setCompilerOptions((Map)javaOptions);
        parser.setSource(content.toCharArray());
        CompilationUnit root = (CompilationUnit)parser.createAST(monitor);
        if (!(root == null || root.getPackage() == null && root.imports().isEmpty() && root.types().isEmpty())) {
            if (root.getPackage() != null) {
                String packageName = root.getPackage().getName().getFullyQualifiedName();
                desiredPath = PasteEventHandler.searchForMatchingPackage(packageName, path);
            } else {
                desiredPath = path;
            }
            String possibleFileName = "Untitled";
            if (!root.types().isEmpty() && root.types().get(0) instanceof TypeDeclaration) {
                possibleFileName = ((TypeDeclaration)root.types().get(0)).getName().getIdentifier();
            }
            if (Files.exists(Paths.get(desiredPath, possibleFileName + ".java"), new LinkOption[0])) {
                int counter = 1;
                while (Files.exists(Paths.get(desiredPath, possibleFileName + Integer.toString(counter) + ".java"), new LinkOption[0])) {
                    ++counter;
                }
                return Paths.get(desiredPath, possibleFileName + Integer.toString(counter) + ".java").toString();
            }
            return Paths.get(desiredPath, possibleFileName + ".java").toString();
        }
        return null;
    }

    private static String searchForMatchingPackage(String packageName, String path) throws JavaModelException {
        String pathRoot = path;
        String desiredPath = "";
        String partialPathAddition = "";
        IJavaProject[] projects = ProjectUtils.getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            if (!"jdt.ls-java-project".equals(projects[i].getElementName())) {
                IPackageFragment[] packages = projects[i].getPackageFragments();
                int j = 0;
                while (j < packages.length) {
                    if (packages[j].getKind() == 1 && !packages[j].isDefaultPackage()) {
                        String tempPath;
                        pathRoot = packages[j].getParent().getResource().getLocation().toOSString();
                        String name = packages[j].getElementName();
                        if (name.equals(packageName)) {
                            return packages[j].getResource().getLocation().toOSString();
                        }
                        if (packageName.startsWith(name) && packageName.substring(0, name.length() + 1).endsWith(".") && (tempPath = packages[j].getResource().getLocation().toOSString()).length() > desiredPath.length()) {
                            desiredPath = tempPath;
                            partialPathAddition = packageName.substring(name.length()).replaceAll("\\.", Matcher.quoteReplacement(File.separator));
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!partialPathAddition.isEmpty()) {
            return Paths.get(desiredPath, partialPathAddition).toString();
        }
        packageName = packageName.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        return Paths.get(pathRoot, packageName).toString();
    }

    public static class DocumentPasteEdit {
        private final String insertText;
        private final WorkspaceEdit additionalEdit;

        public DocumentPasteEdit(String newText, WorkspaceEdit additionalEdit) {
            this.insertText = newText;
            this.additionalEdit = additionalEdit;
        }

        public DocumentPasteEdit(String modifiedText) {
            this(modifiedText, null);
        }

        public DocumentPasteEdit() {
            this(null);
        }

        public String getInsertText() {
            return this.insertText;
        }

        public WorkspaceEdit getAdditionalEdit() {
            return this.additionalEdit;
        }

        public String toString() {
            return "DocumentPasteEdit [insertText=" + this.insertText + ", additionalEdit=" + String.valueOf(this.additionalEdit) + "]";
        }

        public int hashCode() {
            return Objects.hash(this.additionalEdit, this.insertText);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DocumentPasteEdit other = (DocumentPasteEdit)obj;
            return Objects.equals(this.additionalEdit, other.additionalEdit) && Objects.equals(this.insertText, other.insertText);
        }
    }

    public static class PasteEventParams {
        private final Location location;
        private final String text;
        private final String copiedDocumentUri;
        private final FormattingOptions formattingOptions;

        public PasteEventParams(Location location, String text, String copiedDocumentUri, FormattingOptions formattingOptions) {
            this.location = location;
            this.text = text;
            this.copiedDocumentUri = copiedDocumentUri;
            this.formattingOptions = formattingOptions;
        }

        public PasteEventParams() {
            this(null, null, null, null);
        }

        public Location getLocation() {
            return this.location;
        }

        public String getText() {
            return this.text;
        }

        public String getCopiedDocumentUri() {
            return this.copiedDocumentUri;
        }

        public FormattingOptions getFormattingOptions() {
            return this.formattingOptions;
        }
    }
}

