/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.UseIteratorToForLoopFixCore;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpContext;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;

public class UseIteratorToForLoopCleanUpCore
extends AbstractCleanUp {
    public UseIteratorToForLoopCleanUpCore(Map<String, String> options) {
        super(options);
    }

    public UseIteratorToForLoopCleanUpCore() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        return new CleanUpRequirements(this.requireAST(), this.requireAST(), false, null);
    }

    public boolean requireAST() {
        return this.isEnabled("cleanup.convert_to_enhanced_for_loop");
    }

    @Override
    public ICleanUpFix createFix(CleanUpContext context) throws CoreException {
        CompilationUnit compilationUnit = context.getAST();
        if (compilationUnit == null) {
            return null;
        }
        EnumSet<UseIteratorToForLoopFixCore> computeFixSet = this.computeFixSet();
        if (!this.isEnabled("cleanup.convert_to_enhanced_for_loop") || computeFixSet.isEmpty()) {
            return null;
        }
        LinkedHashSet operations = new LinkedHashSet();
        HashSet nodesprocessed = new HashSet();
        computeFixSet.forEach(i -> i.findOperations(compilationUnit, operations, nodesprocessed, this.isEnabled("cleanup.convert_to_enhanced_for_loop_if_loop_var_used")));
        if (operations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description, compilationUnit, operations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            result.add(MultiFixMessages.Java50CleanUp_ConvertToEnhancedForLoop_description);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public String getPreview() {
        StringBuilder sb = new StringBuilder();
        EnumSet<UseIteratorToForLoopFixCore> computeFixSet = this.computeFixSet();
        EnumSet.allOf(UseIteratorToForLoopFixCore.class).forEach(e -> {
            StringBuilder stringBuilder2 = sb.append(e.getPreview(computeFixSet.contains(e)));
        });
        return sb.toString();
    }

    private EnumSet<UseIteratorToForLoopFixCore> computeFixSet() {
        EnumSet<UseIteratorToForLoopFixCore> fixSet = EnumSet.noneOf(UseIteratorToForLoopFixCore.class);
        if (this.isEnabled("cleanup.convert_to_enhanced_for_loop")) {
            fixSet = EnumSet.allOf(UseIteratorToForLoopFixCore.class);
        }
        return fixSet;
    }
}

