/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.dom.IASTSharedValues;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.template.java.SignatureUtil;
import org.eclipse.jdt.internal.ui.text.Chain;
import org.eclipse.jdt.internal.ui.text.ChainElement;
import org.eclipse.jdt.internal.ui.text.ChainElementAnalyzer;
import org.eclipse.jdt.internal.ui.text.ChainFinder;
import org.eclipse.jdt.internal.ui.text.ChainType;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;

public class ChainCompletionProposalComputer {
    private static final char[] KEYWORD_NEW = "new".toCharArray();
    private List<ChainElement> entrypoints;
    private String[] excludedTypes;
    private ICompilationUnit cu;
    private CompletionProposalRequestor coll;
    private boolean snippetStringSupported;

    public ChainCompletionProposalComputer(ICompilationUnit cu, CompletionProposalRequestor coll, boolean snippetStringSupported) {
        this.cu = cu;
        this.coll = coll;
        this.snippetStringSupported = snippetStringSupported;
    }

    public void computeCompletionProposals() {
        if (this.shouldPerformCompletionOnExpectedType()) {
            this.executeCallChainSearch();
        }
    }

    private void executeCallChainSearch() {
        int maxChains = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.max_chains", (IJavaProject)this.cu.getJavaProject()));
        int minDepth = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.min_chain_length", (IJavaProject)this.cu.getJavaProject()));
        int maxDepth = Integer.parseInt(JavaManipulation.getPreference((String)"recommenders.chain.max_chain_length", (IJavaProject)this.cu.getJavaProject()));
        this.excludedTypes = JavaManipulation.getPreference((String)"recommenders.chain.ignore_types", (IJavaProject)this.cu.getJavaProject()).split("\\|");
        int i = 0;
        while (i < this.excludedTypes.length) {
            this.excludedTypes[i] = "L" + this.excludedTypes[i].replace('.', '/');
            ++i;
        }
        IType invocationType = this.cu.findPrimaryType();
        String token = this.coll.getContext().getToken() != null && this.coll.getContext().getToken().length > 0 ? String.valueOf(this.coll.getContext().getToken()) : null;
        List<ChainType> expectedTypes = ChainCompletionProposalComputer.resolveBindingsForExpectedTypes(this.cu.getJavaProject(), this.coll.getContext());
        ChainFinder mainFinder = new ChainFinder(expectedTypes, Arrays.asList(this.excludedTypes), invocationType, token);
        ChainFinder contextFinder = new ChainFinder(expectedTypes, Arrays.asList(this.excludedTypes), invocationType, token);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            CompletableFuture<Void> mainChains = CompletableFuture.runAsync(() -> {
                if (this.findEntrypoints(expectedTypes, this.cu.getJavaProject())) {
                    mainFinder.startChainSearch(this.entrypoints, maxChains, minDepth, maxDepth);
                }
            }, executor);
            CompletableFuture<Void> contextChains = CompletableFuture.runAsync(() -> {
                try {
                    List<ChainElement> contextEntrypoint = this.computeContextEntrypoint(expectedTypes, this.cu.getJavaProject());
                    if (!contextEntrypoint.isEmpty()) {
                        contextFinder.startChainSearch(contextEntrypoint, maxChains, 1, 2);
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }, executor);
            CompletableFuture<Void> future = CompletableFuture.allOf(mainChains, contextChains);
            long timeout = Long.parseLong(JavaManipulation.getPreference((String)"recommenders.chain.timeout", (IJavaProject)this.cu.getJavaProject()));
            future.get(timeout, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            mainFinder.cancel();
            contextFinder.cancel();
            executor.shutdownNow();
        }
        ArrayList<Chain> found = new ArrayList<Chain>();
        found.addAll(mainFinder.getChains());
        found.addAll(contextFinder.getChains());
        this.buildCompletionProposals(found);
    }

    private void buildCompletionProposals(List<Chain> chains) {
        for (Chain chain : chains) {
            try {
                CompletionProposal completionProposal = this.createCompletionProposal(chain);
                if (completionProposal == null) continue;
                this.coll.accept(completionProposal);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    private boolean findEntrypoints(List<ChainType> expectedTypes, IJavaProject project) {
        IJavaElement[] visibleElements;
        this.entrypoints = new LinkedList<ChainElement>();
        HashSet<IJavaElement> processed = new HashSet<IJavaElement>();
        for (CompletionProposal prop : this.coll.getProposals()) {
            ChainElement ce;
            IJavaElement e;
            IJavaElement javaElement = this.resolveJavaElement(prop, this.cu.getJavaProject());
            if (javaElement == null || !this.matchesExpectedPrefix(e = javaElement) || ChainFinder.isFromExcludedType(Arrays.asList(this.excludedTypes), (IJavaElement)e) || (ce = new ChainElement(e, false)).getElementType() == null) continue;
            this.entrypoints.add(ce);
            processed.add(javaElement);
        }
        IJavaElement[] iJavaElementArray = visibleElements = this.coll.getContext().getVisibleElements(null);
        int n = visibleElements.length;
        int n2 = 0;
        while (n2 < n) {
            ChainElement ce;
            IJavaElement ve = iJavaElementArray[n2];
            if (!processed.contains(ve) && this.matchesExpectedPrefix(ve) && !ChainFinder.isFromExcludedType(Arrays.asList(this.excludedTypes), (IJavaElement)ve) && (ce = new ChainElement(ve, false)).getElementType() != null) {
                this.entrypoints.add(ce);
            }
            ++n2;
        }
        return !this.entrypoints.isEmpty();
    }

    private IJavaElement resolveJavaElement(CompletionProposal prop, IJavaProject proj) {
        try {
            if (prop.getKind() == 2) {
                return JDTUtils.resolveField(prop, proj);
            }
            if (prop.getKind() == 6 || prop.getKind() == 13) {
                return JDTUtils.resolveMethod(prop, proj);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    private boolean shouldPerformCompletionOnExpectedType() {
        if (this.coll.getContext().getToken() != null && CharOperation.equals((char[])this.coll.getContext().getToken(), (char[])KEYWORD_NEW)) {
            return false;
        }
        if (this.coll.getContext().getTokenLocation() == 4) {
            return false;
        }
        CompilationUnit cuNode = this.getASTRoot();
        AST ast = cuNode.getAST();
        ITypeBinding binding = ast.resolveWellKnownType(ChainElementAnalyzer.getExpectedFullyQualifiedTypeName((CompletionContext)this.coll.getContext()));
        IType type = ChainElementAnalyzer.getExpectedType((IJavaProject)this.cu.getJavaProject(), (CompletionContext)this.coll.getContext());
        return this.hasValidExpectedTypeResolution(binding, type);
    }

    private boolean hasValidExpectedTypeResolution(ITypeBinding binding, IType type) {
        if (binding != null) {
            return !this.isPrimitiveOrBoxedPrimitive(binding) && !"java.lang.String".equals(binding.getQualifiedName()) && !"java.lang.Object".equals(binding.getQualifiedName());
        }
        if (type != null) {
            return !"java.lang.String".equals(type.getFullyQualifiedName()) && !"java.lang.Object".equals(type.getFullyQualifiedName());
        }
        return false;
    }

    private boolean isPrimitiveOrBoxedPrimitive(ITypeBinding binding) {
        if (binding.isPrimitive()) {
            return true;
        }
        return switch (binding.getQualifiedName()) {
            case "java.lang.Boolean" -> true;
            case "java.lang.Byte" -> true;
            case "java.lang.Character" -> true;
            case "java.lang.Short" -> true;
            case "java.lang.Double" -> true;
            case "java.lang.Float" -> true;
            case "java.lang.Integer" -> true;
            case "java.lang.Long" -> true;
            default -> false;
        };
    }

    private CompilationUnit getASTRoot() {
        CompilationUnit cuNode = SharedASTProviderCore.getAST((ITypeRoot)this.cu, (SharedASTProviderCore.WAIT_FLAG)SharedASTProviderCore.WAIT_NO, null);
        if (cuNode == null) {
            ASTParser p = ASTParser.newParser((int)IASTSharedValues.SHARED_AST_LEVEL);
            p.setSource(this.cu);
            p.setResolveBindings(true);
            p.setCompilerOptions(RefactoringASTParser.getCompilerOptions((IJavaElement)this.cu));
            cuNode = (CompilationUnit)p.createAST(null);
        }
        return cuNode;
    }

    private boolean matchesExpectedPrefix(IJavaElement element) {
        String prefix = String.valueOf(this.coll.getContext().getToken());
        return String.valueOf(element.getElementName()).startsWith(prefix);
    }

    private CompletionProposal createCompletionProposal(Chain chain) throws JavaModelException {
        ChainElement edge = (ChainElement)chain.getElements().get(chain.getElements().size() - 1);
        ChainText chainText = this.createChainText(chain, chain.getExpectedDimensions());
        ChainElement root = (ChainElement)chain.getElements().get(0);
        CompletionProposal cp = null;
        switch (edge.getElementType()) {
            case FIELD: {
                cp = CompletionProposal.create((int)2, (int)this.coll.getContext().getOffset());
                IField field = (IField)edge.getElement();
                cp.setName(chainText.displayText().toCharArray());
                cp.setSignature(field.getTypeSignature().toCharArray());
                cp.setDeclarationSignature(Signature.createTypeSignature((String)field.getDeclaringType().getFullyQualifiedName(), (boolean)true).toCharArray());
                cp.setCompletion(chainText.insertText().toCharArray());
                cp.setReplaceRange(this.coll.getContext().getOffset(), this.coll.getContext().getOffset() + chainText.length());
                if (this.coll.getContext().getToken() == null || this.coll.getContext().getToken().length <= 0) break;
                cp.setTokenRange(this.coll.getContext().getTokenStart(), this.coll.getContext().getTokenEnd());
                break;
            }
            case METHOD: {
                cp = CompletionProposal.create((int)6, (int)this.coll.getContext().getOffset());
                IMethod method = (IMethod)edge.getElement();
                cp.setName(chainText.displayText().toCharArray());
                cp.setSignature(this.toGenericSignature(method));
                cp.setDeclarationSignature(Signature.createTypeSignature((String)method.getDeclaringType().getFullyQualifiedName(), (boolean)true).toCharArray());
                cp.setCompletion(chainText.insertText().toCharArray());
                cp.setReplaceRange(this.coll.getContext().getOffset(), this.coll.getContext().getOffset() + chainText.length());
                cp.setParameterNames(this.toCharArray(method.getParameterNames()));
                if (this.coll.getContext().getToken() == null || this.coll.getContext().getToken().length <= 0) break;
                cp.setTokenRange(this.coll.getContext().getTokenStart(), this.coll.getContext().getTokenEnd());
            }
        }
        if (cp != null) {
            if (this.coll.getContext().getToken() != null && this.coll.getContext().getToken().length > 0) {
                cp.setReplaceRange(this.coll.getContext().getTokenStart(), this.coll.getContext().getTokenEnd());
            }
            if (root.getElementType() == ChainElement.ElementType.TYPE) {
                IType type = (IType)root.getElement();
                CompletionProposal importCompletion = CompletionProposal.create((int)9, (int)this.coll.getContext().getOffset());
                importCompletion.setSignature(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true).toCharArray());
                importCompletion.setCompletion(type.getFullyQualifiedName().toCharArray());
                int sourceStart = this.cu.getTypes()[0].getSourceRange().getOffset();
                importCompletion.setReplaceRange(sourceStart, sourceStart);
                cp.setRequiredProposals(new CompletionProposal[]{importCompletion});
            }
        }
        return cp;
    }

    private char[] toGenericSignature(IMethod method) throws JavaModelException {
        return Signature.createMethodSignature((String[])method.getParameterTypes(), (String)method.getReturnType()).toCharArray();
    }

    private char[][] toCharArray(String[] parameterNames) {
        char[][] result = new char[parameterNames.length][];
        int i = 0;
        while (i < parameterNames.length) {
            result[i] = parameterNames[i].toCharArray();
            ++i;
        }
        return result;
    }

    private ChainText createChainText(Chain chain, int expectedDimension) throws JavaModelException {
        StringBuilder insertText = new StringBuilder(64);
        StringBuilder displayText = new StringBuilder(64);
        for (ChainElement edge : chain.getElements()) {
            switch (edge.getElementType()) {
                case FIELD: 
                case LOCAL_VARIABLE: 
                case TYPE: {
                    ChainCompletionProposalComputer.appendVariableString(edge, insertText);
                    ChainCompletionProposalComputer.appendVariableString(edge, displayText);
                    break;
                }
                case METHOD: {
                    IMethod method = (IMethod)edge.getElement();
                    insertText.append(method.getElementName());
                    this.appendParameters(insertText, method);
                    displayText.append(method.getElementName());
                }
            }
            this.appendArrayDimensions(insertText, edge.getReturnTypeDimension(), expectedDimension, this.snippetStringSupported);
            insertText.append(".");
            this.appendArrayDimensions(displayText, edge.getReturnTypeDimension(), expectedDimension, false);
            displayText.append(".");
        }
        ChainCompletionProposalComputer.deleteLastChar(insertText);
        ChainCompletionProposalComputer.deleteLastChar(displayText);
        return new ChainText(insertText.toString(), displayText.toString());
    }

    private static void appendVariableString(ChainElement edge, StringBuilder sb) {
        if (edge.requiresThisForQualification() && sb.length() == 0) {
            sb.append("this.");
        }
        sb.append(edge.getElement().getElementName());
    }

    private void appendParameters(StringBuilder sb, IMethod method) throws JavaModelException {
        sb.append("(");
        if (this.snippetStringSupported) {
            String[] parameterNames = method.getParameterNames();
            if (parameterNames == null) {
                parameterNames = (String[])Stream.of(method.getParameterTypes()).map(ts -> Signature.getSignatureSimpleName((String)Signature.getElementType((String)ts))).map(n -> n.substring(0, 1).toLowerCase() + n.substring(1)).map(n -> {
                    int index = n.indexOf(60);
                    return index > -1 ? n.substring(0, index) : n;
                }).toArray(String[]::new);
            }
            sb.append(Stream.of(parameterNames).collect(Collectors.joining(", ")));
        }
        sb.append(")");
    }

    private void appendArrayDimensions(StringBuilder sb, int dimension, int expectedDimension, boolean snippetStringSupported) {
        int i = dimension;
        while (i-- > expectedDimension) {
            sb.append("[");
            if (snippetStringSupported) {
                sb.append("${").append(dimension).append(":i}");
            }
            sb.append("]");
        }
    }

    private static StringBuilder deleteLastChar(StringBuilder sb) {
        return sb.deleteCharAt(sb.length() - 1);
    }

    private List<ChainElement> computeContextEntrypoint(List<ChainType> expectedTypes, IJavaProject project) throws JavaModelException {
        ArrayList<ChainElement> results = new ArrayList<ChainElement>();
        for (ChainType chainType : expectedTypes) {
            IType type;
            if (chainType.getType() == null) continue;
            if (("java.util.List".equals(chainType.getType().getFullyQualifiedName()) || "java.util.Set".equals(chainType.getType().getFullyQualifiedName()) || "java.util.Map".equals(chainType.getType().getFullyQualifiedName())) && (type = project.findType("java.util.Collections")) != null) {
                results.add(new ChainElement((IJavaElement)type, false));
            }
            if (!"java.util.stream.Collector".equals(chainType.getType().getFullyQualifiedName()) || (type = project.findType("java.util.stream.Collectors")) == null) continue;
            results.add(new ChainElement((IJavaElement)type, false));
        }
        return results;
    }

    public static List<ChainType> resolveBindingsForExpectedTypes(IJavaProject proj, CompletionContext ctx) {
        LinkedList<ChainType> types = new LinkedList<ChainType>();
        IType[] expectedTypeSigs = ChainCompletionProposalComputer.getExpectedType(proj, ctx);
        if (expectedTypeSigs == null) {
            char[][] expectedTypes = ctx.getExpectedTypesSignatures();
            int i = 0;
            while (i < expectedTypes.length) {
                String typeSig = new String(expectedTypes[i]);
                int dim = ChainCompletionProposalComputer.getArrayDimension(expectedTypes[i]);
                ChainType type = new ChainType(typeSig, dim);
                types.add(type);
                ++i;
            }
        } else {
            int i = 0;
            while (i < expectedTypeSigs.length) {
                ChainType type = new ChainType(expectedTypeSigs[i]);
                types.add(type);
                ++i;
            }
        }
        return types;
    }

    private static int getArrayDimension(char[] expectedTypesSignatures) {
        if (expectedTypesSignatures != null && expectedTypesSignatures.length > 0) {
            return Signature.getArrayCount((String)new String(expectedTypesSignatures));
        }
        return 0;
    }

    public static IType[] getExpectedType(IJavaProject proj, CompletionContext ctx) {
        IType[] expected = null;
        String[] fqExpectedTypes = ChainCompletionProposalComputer.getExpectedFullyQualifiedTypeNames(ctx);
        if (fqExpectedTypes != null && fqExpectedTypes.length > 0) {
            expected = new IType[fqExpectedTypes.length];
            int i = 0;
            while (i < fqExpectedTypes.length) {
                try {
                    expected[i] = proj.findType(fqExpectedTypes[i]);
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
                ++i;
            }
        }
        return expected;
    }

    public static String[] getExpectedFullyQualifiedTypeNames(CompletionContext ctx) {
        String[] fqExpectedTypes = null;
        char[][] expectedTypes = ctx.getExpectedTypesSignatures();
        if (expectedTypes != null && expectedTypes.length > 0) {
            fqExpectedTypes = new String[expectedTypes.length];
            int i = 0;
            while (i < expectedTypes.length) {
                fqExpectedTypes[i] = SignatureUtil.stripSignatureToFQN((String)new String(expectedTypes[i]));
                ++i;
            }
        }
        return fqExpectedTypes;
    }

    private record ChainText(String insertText, String displayText) {
        public int length() {
            return this.insertText().length();
        }
    }
}

