/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.managers.DigestStore;
import org.eclipse.jdt.ls.core.internal.managers.IBuildSupport;
import org.eclipse.jdt.ls.core.internal.managers.JavaApplicationLaunchConfiguration;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.project.ProjectConfigurationManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.MavenUpdateRequest;

public class MavenBuildSupport
implements IBuildSupport {
    public static final String UNSUPPORTED_ON_MAVEN = "Unsupported operation. Please use pom.xml file to manage the source directories of maven project.";
    private static final List<String> WATCH_FILE_PATTERNS = Collections.singletonList("**/pom.xml");
    private IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    private DigestStore digestStore = JavaLanguageServerPlugin.getDigestStore();
    private IMavenProjectRegistry registry = MavenPlugin.getMavenProjectRegistry();
    private boolean shouldCollectProjects = true;

    @Override
    public boolean applies(IProject project) {
        return ProjectUtils.isMavenProject(project);
    }

    @Override
    public void update(IProject project, boolean force, IProgressMonitor monitor) throws CoreException {
        if (!this.applies(project)) {
            return;
        }
        Path pomPath = project.getFile("pom.xml").getLocation().toFile().toPath();
        if (this.digestStore.updateDigest(pomPath) || force) {
            boolean updateSnapshots;
            JavaLanguageServerPlugin.debugTrace("Starting Maven update for " + project.getName());
            boolean bl = updateSnapshots = JavaLanguageServerPlugin.getPreferencesManager() == null ? false : JavaLanguageServerPlugin.getPreferencesManager().getPreferences().isMavenUpdateSnapshots();
            if (this.shouldCollectProjects()) {
                LinkedHashSet<IProject> projectSet = new LinkedHashSet<IProject>();
                this.collectProjects(projectSet, project, monitor);
                MavenUpdateRequest request = new MavenUpdateRequest(projectSet, MavenPlugin.getMavenConfiguration().isOffline(), updateSnapshots);
                ((ProjectConfigurationManager)this.configurationManager).updateProjectConfiguration(request, true, true, monitor);
            } else {
                MavenUpdateRequest request = new MavenUpdateRequest(project, MavenPlugin.getMavenConfiguration().isOffline(), updateSnapshots);
                this.configurationManager.updateProjectConfiguration(request, monitor);
            }
        }
    }

    public void collectProjects(Collection<IProject> projects, IProject project, IProgressMonitor monitor) {
        if (!project.isOpen() || !ProjectUtils.isMavenProject(project)) {
            return;
        }
        projects.add(project);
        IMavenProjectFacade projectFacade = this.registry.create(project, monitor);
        if (projectFacade != null && "pom".equals(projectFacade.getPackaging())) {
            List modules = projectFacade.getMavenProjectModules();
            for (String module : modules) {
                IProject p;
                IPath pomPath = ResourcesPlugin.getWorkspace().getRoot().getFullPath().append(module).append("pom.xml");
                IFile pom = ResourcesPlugin.getWorkspace().getRoot().getFile(pomPath);
                if (!pom.exists() || !(p = pom.getProject()).isOpen()) continue;
                this.collectProjects(projects, p, monitor);
            }
        }
    }

    @Override
    public boolean isBuildFile(IResource resource) {
        return resource != null && resource.getProject() != null && resource.getType() == 1 && resource.getName().equals("pom.xml") && resource.getProject().equals((Object)resource.getParent());
    }

    @Override
    public boolean isBuildLikeFileName(String fileName) {
        return fileName.equals("pom.xml");
    }

    public boolean shouldCollectProjects() {
        return this.shouldCollectProjects;
    }

    public void setShouldCollectProjects(boolean shouldCollectProjects) {
        this.shouldCollectProjects = shouldCollectProjects;
    }

    @Override
    public boolean fileChanged(IResource resource, ProjectsManager.CHANGE_TYPE changeType, IProgressMonitor monitor) throws CoreException {
        if (resource == null || !this.applies(resource.getProject())) {
            return false;
        }
        return IBuildSupport.super.fileChanged(resource, changeType, monitor) || this.isBuildFile(resource);
    }

    @Override
    public void discoverSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        JavaLanguageServerPlugin.getDefaultSourceDownloader().discoverSource(classFile, monitor);
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration(IJavaProject javaProject, String scope) throws CoreException {
        return new JavaApplicationLaunchConfiguration(javaProject.getProject(), scope, "org.eclipse.m2e.launchconfig.classpathProvider");
    }

    @Override
    public List<String> getWatchPatterns() {
        return WATCH_FILE_PATTERNS;
    }

    @Override
    public String buildToolName() {
        return "Maven";
    }

    @Override
    public String unsupportedOperationMessage() {
        return UNSUPPORTED_ON_MAVEN;
    }
}

