/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.UnsupportedJavaVersionException;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.launching.StandardVMType;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.model.build.BuildEnvironment;

public class CompatibilityChecker {
    public static final String BYPASS_COMPATIBILITY_CHECK_KEY = "org.eclipse.buildship.integtest.bypassToolingApiCompatibilityChecks";
    public static final Map<String, Set<String>> compatibilityMap = Collections.unmodifiableMap(CompatibilityChecker.loadCompatibilityMap());
    private static final String PROPERTIES_FILE = "/org/eclipse/buildship/core/internal/gradle/java-unsupported-gradle.properties";
    private static final String UNSUPPORTED_BUILD_ENVIRONMENT_MESSAGE = "Could not create an instance of Tooling API implementation using the specified Gradle distribution";

    public static IStatus validateToolingApiCompatibility(GradleBuild gradleBuild, BuildConfiguration buildConfig, IProgressMonitor monitor) {
        String bypassCompatibilityCheckProperty = System.getProperty(BYPASS_COMPATIBILITY_CHECK_KEY);
        if (!"true".equals(bypassCompatibilityCheckProperty)) {
            String gradleVersion;
            String javaVersion;
            File javaHome = buildConfig.getJavaHome();
            String string = javaVersion = javaHome != null ? new StandardVMType().readReleaseVersion(javaHome) : System.getProperty("java.version");
            if (javaVersion == null || javaVersion.isEmpty()) {
                return Status.OK_STATUS;
            }
            try {
                BuildEnvironment environment = gradleBuild.withConnection(connection -> (BuildEnvironment)connection.getModel(BuildEnvironment.class), monitor);
                gradleVersion = environment.getGradle().getGradleVersion();
            }
            catch (Exception e) {
                if (CompatibilityChecker.hasUnsupportedBuildEnvironmentMessage(e)) {
                    return ToolingApiStatus.from("Project synchronization", new UnsupportedJavaVersionException(String.format("The current build uses Java %s which is not supported. Please consult the Gradle documentation to find the compatible combinations: https://docs.gradle.org/current/userguide/compatibility.html.", javaVersion)));
                }
                return ToolingApiStatus.from("Project synchronization", e);
            }
            if (gradleVersion == null) {
                return ToolingApiStatus.from("Project synchronization", (Throwable)new GradleConnectionException("Can't determine Gradle version when synchronizing project."));
            }
            JavaVersion javaVersionObject = JavaVersion.toVersion((Object)javaVersion);
            Set<String> unsupportedGradleVersions = compatibilityMap.get(javaVersionObject.getMajorVersion());
            if (unsupportedGradleVersions != null && unsupportedGradleVersions.contains(gradleVersion)) {
                return ToolingApiStatus.from("Project synchronization", new UnsupportedJavaVersionException(String.format("The current build uses Gradle %s running on Java %s which is not supported. Please consult the Gradle documentation to find the compatible combinations: https://docs.gradle.org/current/userguide/compatibility.html.", gradleVersion, javaVersion)));
            }
        }
        return new Status(0, "org.eclipse.buildship.core", "tooling API compatibility check passed");
    }

    private static boolean hasUnsupportedBuildEnvironmentMessage(Exception e) {
        HashSet<Exception> seen = new HashSet<Exception>();
        for (Throwable current = e; current != null; current = current.getCause()) {
            if (current.getMessage().contains(UNSUPPORTED_BUILD_ENVIRONMENT_MESSAGE)) {
                return true;
            }
            if (!seen.add((Exception)current)) break;
        }
        return false;
    }

    private static Map<String, Set<String>> loadCompatibilityMap() throws GradlePluginsRuntimeException {
        HashMap<String, Set<String>> compatibilityMatrix = new HashMap<String, Set<String>>();
        URL resource = CompatibilityChecker.class.getResource(PROPERTIES_FILE);
        if (resource == null) {
            throw new GradlePluginsRuntimeException(String.format("Resource '%s' not found.", PROPERTIES_FILE));
        }
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            inputStream = connection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.entrySet().forEach(e -> {
                Object javaVersion = e.getKey();
                Object gradleVersions = e.getValue();
                if (javaVersion instanceof String && gradleVersions instanceof String) {
                    compatibilityMatrix.put((String)javaVersion, new HashSet<String>(Arrays.asList(((String)gradleVersions).split(","))));
                }
            });
        }
        catch (Exception e2) {
            throw new GradlePluginsRuntimeException(String.format("Could not load version details from resource '%s'.", resource), e2);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e3) {
                    throw new GradlePluginsRuntimeException(e3);
                }
            }
        }
        return compatibilityMatrix;
    }
}

