/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.ClassFinder;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Names;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import org.eclipse.core.runtime.ILog;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.GenericRecoveredTypeBinding;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IModuleBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.JavacCompilationUnitResolver;
import org.eclipse.jdt.core.dom.JavacConverter;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RecoveredTypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.codeassist.DOMCompletionUtil;
import org.eclipse.jdt.internal.javac.dom.JavacAnnotationBinding;
import org.eclipse.jdt.internal.javac.dom.JavacErrorMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacErrorTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacLambdaBinding;
import org.eclipse.jdt.internal.javac.dom.JavacMemberValuePairBinding;
import org.eclipse.jdt.internal.javac.dom.JavacMethodBinding;
import org.eclipse.jdt.internal.javac.dom.JavacModuleBinding;
import org.eclipse.jdt.internal.javac.dom.JavacPackageBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeBinding;
import org.eclipse.jdt.internal.javac.dom.JavacTypeVariableBinding;
import org.eclipse.jdt.internal.javac.dom.JavacVariableBinding;

public class JavacBindingResolver
extends BindingResolver {
    private JavacTask javacTask;
    public final Context context;
    public Map<Symbol, ASTNode> symbolToDeclaration;
    public final IJavaProject javaProject;
    private JavacConverter converter;
    boolean isRecoveringBindings = false;
    public final Bindings bindings = new Bindings();
    private WorkingCopyOwner owner;
    private HashMap<ASTNode, IBinding> resolvedBindingsCache = new HashMap();
    private java.util.List<JCTree.JCCompilationUnit> javacCompilationUnits;
    private Map<String, String> boxingMap = null;

    public JavacBindingResolver(IJavaProject javaProject, JavacTask javacTask, Context context, JavacConverter converter, WorkingCopyOwner owner, java.util.List<JCTree.JCCompilationUnit> javacCompilationUnits) {
        this.javacTask = javacTask;
        this.context = context;
        this.javaProject = javaProject;
        this.converter = converter;
        this.owner = owner;
        this.javacCompilationUnits = javacCompilationUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolve() {
        if (this.symbolToDeclaration != null) {
            return;
        }
        JavacTask tmpTask = this.javacTask;
        if (tmpTask == null) {
            return;
        }
        Object object = tmpTask;
        synchronized (object) {
            if (this.javacTask == null) {
                return;
            }
            boolean alreadyAnalyzed = this.converter.domToJavac.values().stream().map(TreeInfo::symbolFor).anyMatch(Objects::nonNull);
            if (!alreadyAnalyzed) {
                try {
                    JavacTask javacTask = this.javacTask;
                    if (javacTask instanceof JavacTaskImpl) {
                        Iterable<? extends Element> elements;
                        JavacTaskImpl javacTaskImpl = (JavacTaskImpl)javacTask;
                        if (this.javacCompilationUnits != null && !this.javacCompilationUnits.isEmpty()) {
                            java.util.List<JCTree.JCCompilationUnit> trees = this.javacCompilationUnits;
                            elements = javacTaskImpl.enter(trees);
                        } else {
                            elements = javacTaskImpl.enter();
                        }
                        elements = javacTaskImpl.analyze(elements);
                    } else {
                        Iterable<? extends Element> elements = this.javacTask.analyze();
                    }
                }
                catch (IOException | Error | RuntimeException e) {
                    ILog.get().error(e.getMessage(), e);
                }
            }
            JavacCompilationUnitResolver.cleanup(this.context);
        }
        this.javacTask = null;
        object = this;
        synchronized (object) {
            if (this.symbolToDeclaration == null) {
                HashMap<Symbol, ASTNode> wipSymbolToDeclaration = new HashMap<Symbol, ASTNode>();
                this.converter.domToJavac.forEach((jdt, javac) -> {
                    Symbol symbol;
                    if ((jdt instanceof MethodDeclaration || jdt instanceof VariableDeclaration || jdt instanceof EnumConstantDeclaration || jdt instanceof AnnotationTypeMemberDeclaration || jdt instanceof AbstractTypeDeclaration || jdt instanceof AnonymousClassDeclaration || jdt instanceof TypeParameter) && (symbol = TreeInfo.symbolFor(javac)) != null) {
                        wipSymbolToDeclaration.put(symbol, (ASTNode)jdt);
                    }
                });
                wipSymbolToDeclaration.keySet().forEach(sym -> this.bindings.getBinding((Symbol)sym, null));
                this.symbolToDeclaration = wipSymbolToDeclaration;
            }
        }
    }

    public ASTNode findDeclaringNode(IBinding binding) {
        return this.findNode(this.getJavacSymbol(binding));
    }

    public ASTNode findDeclaringNode(String bindingKey) {
        this.resolve();
        IBinding binding = this.bindings.getBinding(bindingKey);
        if (binding == null) {
            return null;
        }
        return this.findDeclaringNode(binding);
    }

    private Symbol getJavacSymbol(IBinding binding) {
        if (binding instanceof JavacMemberValuePairBinding) {
            JavacMemberValuePairBinding valuePair = (JavacMemberValuePairBinding)binding;
            return this.getJavacSymbol((IBinding)valuePair.method);
        }
        if (binding instanceof JavacAnnotationBinding) {
            JavacAnnotationBinding annotation = (JavacAnnotationBinding)binding;
            return this.getJavacSymbol((IBinding)annotation.getAnnotationType());
        }
        if (binding instanceof JavacMethodBinding) {
            JavacMethodBinding method = (JavacMethodBinding)binding;
            return method.methodSymbol;
        }
        if (binding instanceof JavacPackageBinding) {
            JavacPackageBinding packageBinding = (JavacPackageBinding)binding;
            return packageBinding.getPackageSymbol();
        }
        if (binding instanceof JavacTypeBinding) {
            JavacTypeBinding type = (JavacTypeBinding)binding;
            return type.typeSymbol;
        }
        if (binding instanceof JavacVariableBinding) {
            JavacVariableBinding variable = (JavacVariableBinding)binding;
            return variable.variableSymbol;
        }
        return null;
    }

    public ASTNode findNode(Symbol symbol) {
        if (this.symbolToDeclaration != null) {
            return this.symbolToDeclaration.get(symbol);
        }
        return null;
    }

    public ITypeBinding resolveType(Type type) {
        JavacTypeBinding res;
        JCTree.JCPrimitiveTypeTree primitive;
        ASTNode aSTNode = type.getParent();
        if (aSTNode instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)aSTNode;
            if (type.getLocationInParent() == ParameterizedType.TYPE_PROPERTY) {
                return this.resolveType((Type)parameterized);
            }
        }
        this.resolve();
        aSTNode = type.getParent();
        if (aSTNode instanceof ArrayCreation) {
            ArrayCreation arrayCreation = (ArrayCreation)aSTNode;
            JCTree jcArrayCreation = this.converter.domToJavac.get(arrayCreation);
            return this.bindings.getTypeBinding(((JCTree.JCNewArray)jcArrayCreation).type);
        }
        JCTree jcTree = this.converter.domToJavac.get(type);
        if (jcTree instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)jcTree;
            if (ident.type != null) {
                if (ident.type instanceof Type.PackageType) {
                    return null;
                }
                return this.bindings.getTypeBinding(ident.type);
            }
        }
        if (jcTree instanceof JCTree.JCFieldAccess) {
            ITypeBinding tb;
            JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)jcTree;
            IBinding b = this.getFieldAccessBinding(access);
            return b instanceof ITypeBinding ? (tb = (ITypeBinding)b) : null;
        }
        if (jcTree instanceof JCTree.JCPrimitiveTypeTree) {
            primitive = (JCTree.JCPrimitiveTypeTree)jcTree;
            if (primitive.type != null) {
                return this.bindings.getTypeBinding(primitive.type);
            }
        }
        if (jcTree instanceof JCTree.JCArrayTypeTree) {
            JCTree.JCArrayTypeTree arrayType = (JCTree.JCArrayTypeTree)jcTree;
            if (arrayType.type != null) {
                return this.bindings.getTypeBinding(arrayType.type);
            }
        }
        if (jcTree instanceof JCTree.JCWildcard) {
            JCTree.JCWildcard wcType = (JCTree.JCWildcard)jcTree;
            if (wcType.type != null) {
                return this.bindings.getTypeBinding(wcType.type);
            }
        }
        if (jcTree instanceof JCTree.JCTypeApply) {
            JCTree.JCTypeApply jcta = (JCTree.JCTypeApply)jcTree;
            if (jcta.type != null) {
                Type.ErrorType errorType;
                res = this.bindings.getTypeBinding(jcta.type);
                if (res != null) {
                    return res;
                }
                com.sun.tools.javac.code.Type type2 = jcta.getType().type;
                if (type2 instanceof Type.ErrorType && (res = this.bindings.getTypeBinding((errorType = (Type.ErrorType)type2).getOriginalType(), true)) != null) {
                    return res;
                }
                if (jcta.getType().type != null && (res = this.bindings.getTypeBinding(jcta.getType().type)) != null) {
                    return res;
                }
            }
        }
        if (jcTree instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType annotated = (JCTree.JCAnnotatedType)jcTree;
            if (annotated.type != null) {
                return this.bindings.getTypeBinding(annotated.type);
            }
        }
        if (type instanceof PrimitiveType) {
            primitive = (PrimitiveType)type;
            return this.resolveWellKnownType(primitive.getPrimitiveTypeCode().toString());
        }
        if (type.getAST().apiLevel() >= 10 && type.isVar()) {
            VariableDeclarationStatement statement;
            VariableDeclaration varDecl;
            IVariableBinding varBinding;
            res = type.getParent();
            if (res instanceof VariableDeclaration && (varBinding = this.resolveVariable(varDecl = (VariableDeclaration)res)) != null) {
                return varBinding.getType();
            }
            Object object = type.getParent();
            if (object instanceof VariableDeclarationStatement && (object = this.converter.domToJavac.get(statement = (VariableDeclarationStatement)object)) instanceof JCTree.JCVariableDecl) {
                JCTree.JCVariableDecl jcDecl = (JCTree.JCVariableDecl)object;
                if (jcDecl.type != null) {
                    return this.bindings.getTypeBinding(jcDecl.type);
                }
            }
        }
        return this.createRecoveredTypeBinding(type);
    }

    private RecoveredTypeBinding createRecoveredTypeBinding(final Type type) {
        return new RecoveredTypeBinding(this, this, type){
            final /* synthetic */ JavacBindingResolver this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1);
            }

            public ITypeBinding getTypeDeclaration() {
                if (this.isParameterizedType()) {
                    return new GenericRecoveredTypeBinding(this.this$0, type, (ITypeBinding)this);
                }
                return super.getTypeDeclaration();
            }

            public IPackageBinding getPackage() {
                SimpleType simpleType;
                if (type instanceof SimpleType && (simpleType = (SimpleType)type).getName() instanceof SimpleName) {
                    return this.this$0.converter.domToJavac.values().stream().filter(CompilationUnit.class::isInstance).map(CompilationUnit.class::cast).map(CompilationUnit::getPackage).map(PackageDeclaration::resolveBinding).findAny().orElse(super.getPackage());
                }
                return super.getPackage();
            }
        };
    }

    ITypeBinding resolveType(AnnotationTypeDeclaration type) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type);
            }
        }
        return null;
    }

    ITypeBinding resolveType(RecordDeclaration type) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type);
            }
        }
        return null;
    }

    ITypeBinding resolveType(TypeDeclaration type) {
        JCTree.JCClassDecl jcClassDecl;
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(type);
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (javacNode.type instanceof Type.UnknownType && "<any?>".equals(javacNode.type.toString())) {
                return new JavacErrorTypeBinding(javacNode.type, javacNode.type.tsym, true, this, jcClassDecl.sym);
            }
        }
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, true);
            }
        }
        if (javacNode instanceof JCTree.JCClassDecl) {
            jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.sym != null && jcClassDecl.sym.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.sym.type, true);
            }
        }
        return null;
    }

    ITypeBinding resolveType(EnumDeclaration enumDecl) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(enumDecl);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, true);
            }
        }
        return null;
    }

    ITypeBinding resolveType(AnonymousClassDeclaration anonymousClassDecl) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(anonymousClassDecl);
        if (javacNode instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl jcClassDecl = (JCTree.JCClassDecl)javacNode;
            if (jcClassDecl.type != null) {
                return this.bindings.getTypeBinding(jcClassDecl.type, true);
            }
        }
        return null;
    }

    ITypeBinding resolveTypeParameter(TypeParameter typeParameter) {
        this.resolve();
        JCTree javacNode = this.converter.domToJavac.get(typeParameter);
        if (javacNode instanceof JCTree.JCTypeParameter) {
            JCTree.JCTypeParameter jcClassDecl = (JCTree.JCTypeParameter)javacNode;
            return this.bindings.getTypeBinding(jcClassDecl.type);
        }
        return null;
    }

    IVariableBinding resolveField(FieldAccess fieldAccess) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(fieldAccess);
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess javacFieldAccess = (JCTree.JCFieldAccess)javacElement;
            Symbol symbol = javacFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return this.bindings.getVariableBinding(varSymbol, true);
            }
        }
        return null;
    }

    IVariableBinding resolveField(SuperFieldAccess fieldAccess) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(fieldAccess);
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess javacFieldAccess = (JCTree.JCFieldAccess)javacElement;
            Symbol symbol = javacFieldAccess.sym;
            if (symbol instanceof Symbol.VarSymbol) {
                Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
                return this.bindings.getVariableBinding(varSymbol, true);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(MethodInvocation method) {
        Object templateParameters;
        com.sun.tools.javac.code.Type methodTemplateType;
        AnnoConstruct typeSymbol;
        Type.ErrorType errorType;
        Symbol ownerClass;
        com.sun.tools.javac.code.Type parentType;
        Symbol sym;
        Symbol.MethodSymbol methodSymbol;
        Object object;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        java.util.List<Object> typeArgs = java.util.List.of();
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
            typeArgs = javacMethodInvocation.getTypeArguments().stream().map(jcExpr -> jcExpr.type).toList();
        }
        AnnoConstruct type = javacElement.type;
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            if (type == null) {
                AnnoConstruct classType;
                AbstractTypeDeclaration decl;
                MethodInvocation node;
                for (node = method; node != null && !(node instanceof AbstractTypeDeclaration); node = node.getParent()) {
                }
                if (node instanceof AbstractTypeDeclaration && (object = this.converter.domToJavac.get(decl = (AbstractTypeDeclaration)node)) instanceof JCTree.JCClassDecl) {
                    JCTree.JCClassDecl javacClassDecl = (JCTree.JCClassDecl)object;
                    object = javacClassDecl.type;
                    if (object instanceof Type.ClassType && !((Type.ClassType)(classType = (Type.ClassType)object)).isErroneous()) {
                        type = classType;
                    }
                }
                if (type != null) {
                    classType = type.tsym.members().findFirst(ident.getName(), Symbol.MethodSymbol.class::isInstance);
                    if (classType instanceof Symbol.MethodSymbol) {
                        Type.MethodType methodType;
                        JavacMethodBinding res;
                        methodSymbol = (Symbol.MethodSymbol)classType;
                        classType = methodSymbol.type;
                        if (classType instanceof Type.MethodType && (res = this.bindings.getMethodBinding(methodType = (Type.MethodType)classType, methodSymbol, null, false)) != null) {
                            return res;
                        }
                    }
                }
            }
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            v0 = ident.sym;
        } else if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            v0 = fieldAccess.sym;
        } else {
            v0 = sym = null;
        }
        if (type instanceof Type.MethodType) {
            Type.MethodType methodType = (Type.MethodType)type;
            if (sym instanceof Symbol.MethodSymbol) {
                methodSymbol = (Symbol.MethodSymbol)sym;
                parentType = null;
                object = methodSymbol.owner;
                if (object instanceof Symbol.ClassSymbol) {
                    ownerClass = (Symbol.ClassSymbol)object;
                    if (JavacBindingResolver.isTypeOfType(((Symbol.ClassSymbol)ownerClass).type)) {
                        ITypeBinding iTypeBinding;
                        if (((Symbol.ClassSymbol)ownerClass).type.isParameterized() && method.getExpression() != null && (iTypeBinding = this.resolveExpressionType(method.getExpression())) instanceof JavacTypeBinding) {
                            JavacTypeBinding exprType = (JavacTypeBinding)iTypeBinding;
                            parentType = exprType.type;
                        } else {
                            parentType = ((Symbol.ClassSymbol)ownerClass).type;
                        }
                    }
                }
                return this.bindings.getMethodBinding(methodType, methodSymbol, parentType, false);
            }
        }
        if (type instanceof Type.ErrorType && (parentType = (errorType = (Type.ErrorType)type).getOriginalType()) instanceof Type.MethodType) {
            Iterator<Symbol> methods;
            Type.MethodType methodType = (Type.MethodType)parentType;
            ownerClass = sym.owner;
            if (ownerClass instanceof Symbol.TypeSymbol && (methods = ((Symbol)(typeSymbol = (Symbol.TypeSymbol)ownerClass)).members().getSymbolsByName(sym.getSimpleName(), m -> m instanceof Symbol.MethodSymbol && methodType.equals(m.type)).iterator()).hasNext()) {
                return this.bindings.getMethodBinding(methodType, (Symbol.MethodSymbol)methods.next(), null, false);
            }
            return this.bindings.getErrorMethodBinding(methodType, sym);
        }
        if (type == null && sym instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSym = (Symbol.MethodSymbol)sym;
            typeSymbol = methodSym.type;
            if (typeSymbol instanceof Type.ForAll) {
                methodTemplateType = (Type.ForAll)typeSymbol;
                HashMap<Type.TypeVar, com.sun.tools.javac.code.Type> resolutionMapping = new HashMap<Type.TypeVar, com.sun.tools.javac.code.Type>();
                templateParameters = ((Type.ForAll)methodTemplateType).getTypeVariables();
                for (int i = 0; i < typeArgs.size() && i < ((List)templateParameters).size(); ++i) {
                    resolutionMapping.put((Type.TypeVar)((List)templateParameters).get(i), (com.sun.tools.javac.code.Type)typeArgs.get(i));
                }
                Type.MethodType methodType = new Type.MethodType(((List)((Type.ForAll)methodTemplateType).asMethodType().getParameterTypes()).map(t -> JavacBindingResolver.applyType(t, resolutionMapping)), JavacBindingResolver.applyType(((Type.ForAll)methodTemplateType).asMethodType().getReturnType(), resolutionMapping), ((List)((Type.ForAll)methodTemplateType).asMethodType().getThrownTypes()).map(t -> JavacBindingResolver.applyType(t, resolutionMapping)), ((Type.ForAll)methodTemplateType).tsym);
                return this.bindings.getMethodBinding(methodType, methodSym, methodSym.owner.type, false);
            }
        }
        if (type == null && sym != null && sym.type.isErroneous() && (methodTemplateType = sym.owner.type) instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)methodTemplateType;
            JavacTypeBinding parentTypeBinding = this.bindings.getTypeBinding(classType);
            return Arrays.stream(parentTypeBinding.getDeclaredMethods()).filter(binding -> binding.getName().equals(sym.getSimpleName().toString())).findAny().orElse(null);
        }
        if (type == null && sym instanceof Symbol.MethodSymbol) {
            Type.ClassType classType;
            JavacTypeBinding parentTypeBinding;
            IMethodBinding res;
            JCTree.JCFieldAccess selectedMethod;
            Symbol.MethodSymbol methodSymbol2 = (Symbol.MethodSymbol)sym;
            if (methodSymbol2.type instanceof Type.MethodType && javacElement instanceof JCTree.JCFieldAccess && (selectedMethod = (JCTree.JCFieldAccess)javacElement).getExpression() != null && (templateParameters = selectedMethod.getExpression().type) instanceof Type.ClassType && (res = (IMethodBinding)Arrays.stream((parentTypeBinding = this.bindings.getTypeBinding(classType = (Type.ClassType)templateParameters)).getDeclaredMethods()).filter(binding -> {
                if (!(binding instanceof JavacMethodBinding)) return false;
                JavacMethodBinding javacMethodBinding = (JavacMethodBinding)binding;
                if (javacMethodBinding.methodSymbol != methodSymbol2) return false;
                return true;
            }).findAny().orElse(null)) != null) {
                return res;
            }
        }
        if (sym instanceof Symbol.MethodSymbol && sym.type instanceof Type.MethodType) {
            return (IMethodBinding)this.bindings.getBinding(sym, sym.type);
        }
        return null;
    }

    private static com.sun.tools.javac.code.Type applyType(com.sun.tools.javac.code.Type from, Map<Type.TypeVar, com.sun.tools.javac.code.Type> resolutionMapping) {
        if (from instanceof Type.TypeVar) {
            Type.TypeVar typeVar = (Type.TypeVar)from;
            com.sun.tools.javac.code.Type directMapping = resolutionMapping.get(from);
            if (directMapping != null) {
                return directMapping;
            }
            return typeVar;
        }
        if (from instanceof Type.JCNoType || from instanceof Type.JCVoidType || from instanceof Type.JCPrimitiveType) {
            return from;
        }
        if (from instanceof Type.ClassType) {
            Type.ClassType classType = (Type.ClassType)from;
            List<com.sun.tools.javac.code.Type> args = ((List)classType.getTypeArguments()).map(typeArg -> JavacBindingResolver.applyType(typeArg, resolutionMapping));
            if (Objects.equals(args, classType.getTypeArguments())) {
                return classType;
            }
            return new Type.ClassType(classType.getEnclosingType(), args, classType.tsym);
        }
        if (from instanceof Type.ArrayType) {
            Type.ArrayType arrayType = (Type.ArrayType)from;
            com.sun.tools.javac.code.Type targetElemType = JavacBindingResolver.applyType(arrayType.elemtype, resolutionMapping);
            if (Objects.equals(targetElemType, arrayType.elemtype)) {
                return arrayType;
            }
            return new Type.ArrayType(targetElemType, arrayType.tsym);
        }
        return from;
    }

    IMethodBinding resolveMethod(MethodDeclaration method) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        if (javacElement instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)javacElement;
            if (!(methodDecl.type instanceof Type.ErrorType)) {
                if (methodDecl.type != null) {
                    return this.bindings.getMethodBinding(methodDecl.type.asMethodType(), methodDecl.sym, null, true);
                }
                Symbol.MethodSymbol methodSymbol = methodDecl.sym;
                if (methodSymbol instanceof Symbol.MethodSymbol) {
                    Symbol.MethodSymbol methodSymbol2 = methodSymbol;
                    if (methodSymbol2.type != null) {
                        return this.bindings.getMethodBinding(methodSymbol2.type.asMethodType(), methodSymbol2, null, true);
                    }
                }
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(LambdaExpression lambda) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(lambda);
        if (javacElement instanceof JCTree.JCLambda) {
            IMethodBinding iMethodBinding;
            JCTree.JCLambda jcLambda = (JCTree.JCLambda)javacElement;
            JavacTypeBinding typeBinding = this.bindings.getTypeBinding(jcLambda.type);
            if (typeBinding != null && (iMethodBinding = typeBinding.getFunctionalInterfaceMethod()) instanceof JavacMethodBinding) {
                JavacMethodBinding methodBinding = (JavacMethodBinding)iMethodBinding;
                return this.bindings.getLambdaBinding(methodBinding, lambda);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(MethodReference methodReference) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(methodReference);
        if (javacElement instanceof JCTree.JCMemberReference) {
            JCTree.JCMemberReference memberRef = (JCTree.JCMemberReference)javacElement;
            Symbol symbol = memberRef.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(memberRef.referentType == null ? methodSymbol.type.asMethodType() : memberRef.referentType.asMethodType(), methodSymbol, null, false);
            }
        }
        return null;
    }

    IMethodBinding resolveMember(AnnotationTypeMemberDeclaration member) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(member);
        if (javacElement instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)javacElement;
            return this.bindings.getMethodBinding(methodDecl.type.asMethodType(), methodDecl.sym, null, true);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    IMethodBinding resolveConstructor(EnumConstantDeclaration enumConstantDeclaration) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(enumConstantDeclaration);
        if (javacElement instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcvd = (JCTree.JCVariableDecl)javacElement;
            javacElement = jcvd.init;
        }
        if (!(javacElement instanceof JCTree.JCNewClass)) return null;
        JCTree.JCNewClass jcExpr = (JCTree.JCNewClass)javacElement;
        if (jcExpr.constructor.type.isErroneous()) return null;
        JavacMethodBinding javacMethodBinding = this.bindings.getMethodBinding(jcExpr.constructor.type.asMethodType(), (Symbol.MethodSymbol)jcExpr.constructor, null, true);
        return javacMethodBinding;
    }

    IMethodBinding resolveConstructor(SuperConstructorInvocation expression) {
        Symbol.MethodSymbol methodSymbol;
        Symbol symbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(expression);
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                methodSymbol = (Symbol.MethodSymbol)symbol;
                if (ident.type != null && (ident.type instanceof Type.MethodType || ident.type instanceof Type.ForAll)) {
                    return this.bindings.getMethodBinding(ident.type.asMethodType(), methodSymbol, null, false);
                }
                if (methodSymbol.asType() instanceof Type.MethodType || methodSymbol.asType() instanceof Type.ForAll) {
                    return this.bindings.getMethodBinding(((com.sun.tools.javac.code.Type)methodSymbol.asType()).asMethodType(), methodSymbol, null, false);
                }
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(fieldAccess.type.asMethodType(), methodSymbol, null, false);
            }
        }
        return null;
    }

    IMethodBinding resolveMethod(SuperMethodInvocation method) {
        Symbol symbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(method);
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(ident.type.asMethodType(), methodSymbol, null, false);
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                if (fieldAccess.type != null) {
                    return this.bindings.getMethodBinding(fieldAccess.type.asMethodType(), methodSymbol, null, false);
                }
            }
        }
        return null;
    }

    IBinding resolveCached(ASTNode node, Function<ASTNode, IBinding> l) {
        IBinding res = this.resolvedBindingsCache.get(node);
        if (res == null) {
            res = l.apply(node);
            this.resolvedBindingsCache.put(node, res);
        }
        return res;
    }

    IBinding resolveName(Name name) {
        return this.resolveCached((ASTNode)name, n -> this.resolveNameImpl((Name)n));
    }

    private IBinding resolveNameImpl(Name name) {
        VariableDeclaration decl;
        ExpressionMethodReference methodRef;
        MethodDeclaration methodDeclaration;
        MethodInvocation methodInvocation;
        MethodRef mref;
        QualifiedName parentName;
        ImportDeclaration importDecl;
        IBinding ret;
        Element element;
        IBinding res;
        ITypeBinding typeBinding;
        SimpleType simpleType;
        QualifiedName qname;
        ASTNode aSTNode;
        this.resolve();
        ASTNode parent = name.getParent();
        if (name.getLocationInParent() == QualifiedName.NAME_PROPERTY && parent instanceof QualifiedName && (aSTNode = (qname = (QualifiedName)parent).getParent()) instanceof SimpleType && (simpleType = (SimpleType)aSTNode).getLocationInParent() == ParameterizedType.TYPE_PROPERTY && (typeBinding = this.resolveType((Type)((ParameterizedType)simpleType.getParent()))) != null) {
            return typeBinding;
        }
        if (name.getLocationInParent() == QualifiedType.NAME_PROPERTY && parent.getLocationInParent() == QualifiedType.QUALIFIER_PROPERTY) {
            ITypeBinding typeBinding2 = this.resolveType((Type)((QualifiedType)parent));
            return typeBinding2.getTypeDeclaration();
        }
        if (name.getLocationInParent() == SimpleType.NAME_PROPERTY || name.getLocationInParent() == QualifiedType.NAME_PROPERTY || name.getLocationInParent() == NameQualifiedType.NAME_PROPERTY) {
            return this.resolveType((Type)parent);
        }
        JCTree tree = this.converter.domToJavac.get(name);
        if (tree != null && (res = this.resolveNameToJavac(name, tree)) != null) {
            return res;
        }
        DocTreePath path = this.converter.findDocTreePath((ASTNode)name);
        if (path != null && (element = JavacTrees.instance(this.context).getElement(path)) instanceof Symbol) {
            Symbol symbol = (Symbol)element;
            return this.bindings.getBinding(symbol, null);
        }
        Symbol.PackageSymbol ps = this.findPackageSymbol(name);
        if (ps != null && ps.exists()) {
            return this.bindings.getPackageBinding(ps);
        }
        if (this.isPackageName(name)) {
            return this.bindings.getPackageBinding(name);
        }
        if (tree instanceof JCTree.JCIdent) {
            JavacPackageBinding b;
            JCTree.JCIdent jcid = (JCTree.JCIdent)tree;
            if (jcid.sym instanceof Symbol.ClassSymbol && jcid.type instanceof Type.ErrorType && (b = this.bindings.findExistingPackageBinding(name)) != null) {
                return b;
            }
        }
        if (tree == null && (name.getFlags() & 2) != 0 && (tree = this.converter.domToJavac.get(parent)) instanceof JCTree.JCFieldAccess) {
            ParameterizedType parameterized;
            ITypeBinding parameterizedType;
            ASTNode grandParent;
            JCTree.JCIdent jcid;
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
            JCTree.JCExpression jCExpression = jcfa.selected;
            if (jCExpression instanceof JCTree.JCIdent && (jcid = (JCTree.JCIdent)jCExpression).toString().equals(name.toString())) {
                tree = jcfa.selected;
            }
            if ((grandParent = parent.getParent()) instanceof ParameterizedType && (parameterizedType = this.resolveType((Type)(parameterized = (ParameterizedType)grandParent))) != null) {
                return parameterizedType;
            }
        }
        if (tree != null && (ret = this.resolveNameToJavac(name, tree)) != null) {
            return ret;
        }
        if (parent instanceof ImportDeclaration && (importDecl = (ImportDeclaration)parent).getName() == name) {
            return this.resolveImport(importDecl);
        }
        if (parent instanceof QualifiedName && (parentName = (QualifiedName)parent).getName() == name) {
            return this.resolveNameImpl((Name)parentName);
        }
        if (parent instanceof MethodRef && (mref = (MethodRef)parent).getName() == name) {
            return this.resolveReference(mref);
        }
        if (parent instanceof MemberRef && (mref = (MemberRef)parent).getName() == name) {
            return this.resolveReference((MemberRef)mref);
        }
        if (parent instanceof MethodInvocation && (methodInvocation = (MethodInvocation)parent).getName() == name) {
            return this.resolveMethod(methodInvocation);
        }
        if (parent instanceof MethodDeclaration && (methodDeclaration = (MethodDeclaration)parent).getName() == name) {
            return this.resolveMethod(methodDeclaration);
        }
        if (parent instanceof ExpressionMethodReference && (methodRef = (ExpressionMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof TypeMethodReference && (methodRef = (TypeMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof SuperMethodReference && (methodRef = (SuperMethodReference)parent).getName() == name) {
            return this.resolveMethod((MethodReference)methodRef);
        }
        if (parent instanceof VariableDeclaration && (decl = (VariableDeclaration)parent).getName() == name) {
            return this.resolveVariable(decl);
        }
        return null;
    }

    private boolean isPackageName(Name name) {
        Name working = name;
        boolean insideQualifier = false;
        while (working instanceof Name) {
            QualifiedName qnn;
            JCTree tree = this.converter.domToJavac.get(working);
            if (tree instanceof JCTree.JCFieldAccess) {
                Symbol.PackageSymbol psym;
                JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
                Symbol symbol = jcfa.sym;
                return symbol instanceof Symbol.PackageSymbol && (psym = (Symbol.PackageSymbol)symbol).exists();
            }
            if (working instanceof QualifiedName && (qnn = (QualifiedName)working).getQualifier() == working) {
                insideQualifier = true;
            }
            working = working.getParent();
        }
        return insideQualifier;
    }

    private Symbol.PackageSymbol findPackageSymbol(Name name) {
        QualifiedName qn;
        JCTree tree;
        SimpleName sn;
        ASTNode parent;
        if (name instanceof SimpleName && (parent = (sn = (SimpleName)name).getParent()) instanceof QualifiedName) {
            QualifiedName qn2 = (QualifiedName)parent;
            JCTree tree2 = this.converter.domToJavac.get(parent);
            if (tree2 instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree2;
                if (qn2.getQualifier().equals((Object)name)) {
                    Object object = jcfa.selected;
                    if (object instanceof JCTree.JCIdent) {
                        JCTree.JCIdent jcid = (JCTree.JCIdent)object;
                        object = jcid.sym;
                        if (object instanceof Symbol.PackageSymbol) {
                            Symbol.PackageSymbol pss = (Symbol.PackageSymbol)object;
                            return pss;
                        }
                    }
                } else if (qn2.getName().equals((Object)name)) {
                    Symbol.PackageSymbol pss;
                    Symbol symbol = jcfa.sym;
                    return symbol instanceof Symbol.PackageSymbol ? (pss = (Symbol.PackageSymbol)symbol) : null;
                }
            }
        }
        if (name instanceof QualifiedName && (tree = this.converter.domToJavac.get(qn = (QualifiedName)name)) instanceof JCTree.JCFieldAccess) {
            Symbol.PackageSymbol pss;
            JCTree.JCFieldAccess jcfa = (JCTree.JCFieldAccess)tree;
            Symbol symbol = jcfa.sym;
            return symbol instanceof Symbol.PackageSymbol ? (pss = (Symbol.PackageSymbol)symbol) : null;
        }
        return null;
    }

    IBinding resolveNameToJavac(Name name, JCTree tree) {
        JCTree variableDecl;
        ParameterizedType pt;
        AnnotatableType st;
        SimpleType type;
        AbstractTypeDeclaration typeDeclaration;
        Object object = name.getParent();
        boolean isTypeDeclaration = object instanceof AbstractTypeDeclaration && (typeDeclaration = (AbstractTypeDeclaration)object).getName() == name || (object = name.getParent()) instanceof SimpleType && (type = (SimpleType)object).getName() == name;
        object = name.getParent();
        if (object instanceof AnnotatableType && (object = (st = (AnnotatableType)object).getParent()) instanceof ParameterizedType && st == (pt = (ParameterizedType)object).getType()) {
            JavacTypeBinding b;
            tree = this.converter.domToJavac.get(pt);
            if (tree.type != null && !tree.type.isErroneous() && (b = this.bindings.getTypeBinding(tree.type, isTypeDeclaration)) != null) {
                return b;
            }
        }
        if (tree instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)tree;
            if (ident.sym != null) {
                Type.ErrorType errorType;
                object = ident.type;
                if (object instanceof Type.ErrorType && (errorType = (Type.ErrorType)object).getOriginalType() instanceof Type.ErrorType && !this.isRecoveringBindings()) {
                    return null;
                }
                if (isTypeDeclaration) {
                    return this.bindings.getTypeBinding(ident.type != null ? ident.type : ident.sym.type, true);
                }
                return this.bindings.getBinding(ident.sym, ident.type != null ? ident.type : ident.sym.type);
            }
        }
        if (tree instanceof JCTree.JCTypeApply) {
            variableDecl = (JCTree.JCTypeApply)tree;
            if (variableDecl.type != null) {
                return this.bindings.getTypeBinding(variableDecl.type);
            }
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)tree;
            return this.getFieldAccessBinding(fieldAccess);
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
            if (methodInvocation.meth.type != null) {
                return this.bindings.getBinding(((JCTree.JCFieldAccess)methodInvocation.meth).sym, methodInvocation.meth.type);
            }
        }
        if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classDecl = (JCTree.JCClassDecl)tree;
            if (classDecl.sym != null) {
                return this.bindings.getBinding(classDecl.sym, classDecl.type);
            }
        }
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodDecl = (JCTree.JCMethodDecl)tree;
            if (methodDecl.sym != null) {
                return this.bindings.getBinding(methodDecl.sym, methodDecl.type);
            }
        }
        if (tree instanceof JCTree.JCVariableDecl) {
            variableDecl = (JCTree.JCVariableDecl)tree;
            if (((JCTree.JCVariableDecl)variableDecl).sym != null) {
                return this.bindings.getBinding(((JCTree.JCVariableDecl)variableDecl).sym, ((JCTree.JCVariableDecl)variableDecl).type);
            }
        }
        if (tree instanceof JCTree.JCTypeParameter) {
            variableDecl = (JCTree.JCTypeParameter)tree;
            if (((JCTree.JCTypeParameter)variableDecl).type != null && ((JCTree.JCTypeParameter)variableDecl).type.tsym != null) {
                return this.bindings.getBinding(((JCTree.JCTypeParameter)variableDecl).type.tsym, ((JCTree.JCTypeParameter)variableDecl).type);
            }
        }
        if (tree instanceof JCTree.JCModuleDecl) {
            variableDecl = (JCTree.JCModuleDecl)tree;
            if (((JCTree.JCModuleDecl)variableDecl).sym != null && ((JCTree.JCModuleDecl)variableDecl).sym.type instanceof Type.ModuleType) {
                return this.bindings.getModuleBinding((JCTree.JCModuleDecl)variableDecl);
            }
        }
        return null;
    }

    IVariableBinding resolveVariable(EnumConstantDeclaration enumConstant) {
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(enumConstant);
        if (jCTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)jCTree;
            if (decl.type != null && !decl.type.isErroneous() || this.isRecoveringBindings()) {
                return this.bindings.getVariableBinding(decl.sym, true);
            }
        }
        return null;
    }

    IVariableBinding resolveVariable(VariableDeclaration variable) {
        this.resolve();
        boolean isUnique = JavacBindingResolver.calculateIsUnique(variable);
        JCTree jCTree = this.converter.domToJavac.get(variable);
        if (jCTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)jCTree;
            if ((decl.type != null && !decl.type.isErroneous() || this.isRecoveringBindings()) && decl.name != Names.instance((Context)this.context).error) {
                return this.bindings.getVariableBinding(decl.sym, isUnique);
            }
        }
        return null;
    }

    public static boolean calculateIsUnique(final VariableDeclaration variable) {
        MethodDeclaration parentMethod = (MethodDeclaration)DOMCompletionUtil.findParent((ASTNode)variable, new int[]{31});
        if (parentMethod == null) {
            return true;
        }
        final String variableName = variable.getName().toString();
        class UniquenessVisitor
        extends ASTVisitor {
            boolean isUnique = true;

            UniquenessVisitor() {
            }

            public boolean visit(VariableDeclarationFragment node) {
                if (node != variable && variableName.equals(node.getName().toString())) {
                    this.isUnique = false;
                }
                return super.visit(node);
            }

            public boolean visit(SingleVariableDeclaration node) {
                if (node != variable && variableName.equals(node.getName().toString())) {
                    this.isUnique = false;
                }
                return super.visit(node);
            }
        }
        UniquenessVisitor uniquenessVisitor = new UniquenessVisitor();
        parentMethod.accept((ASTVisitor)uniquenessVisitor);
        return uniquenessVisitor.isUnique;
    }

    public static boolean calculateIsUnique(MethodDeclaration methodDecl, String name) {
        class UniquenessVisitor
        extends ASTVisitor {
            int count = 0;
            final /* synthetic */ String val$name;

            UniquenessVisitor(String string) {
                this.val$name = string;
            }

            public boolean visit(VariableDeclarationFragment node) {
                if (this.val$name.equals(node.getName().toString())) {
                    ++this.count;
                }
                return super.visit(node);
            }

            public boolean visit(SingleVariableDeclaration node) {
                if (this.val$name.equals(node.getName().toString())) {
                    ++this.count;
                }
                return super.visit(node);
            }
        }
        UniquenessVisitor uniquenessVisitor = new UniquenessVisitor(name);
        methodDecl.accept((ASTVisitor)uniquenessVisitor);
        return uniquenessVisitor.count <= 1;
    }

    public IPackageBinding resolvePackage(PackageDeclaration decl) {
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(decl);
        if (jCTree instanceof JCTree.JCPackageDecl) {
            JCTree.JCPackageDecl jcPackageDecl = (JCTree.JCPackageDecl)jCTree;
            return this.bindings.getPackageBinding(jcPackageDecl.packge);
        }
        return null;
    }

    public ITypeBinding resolveExpressionType(Expression expr) {
        JCTree.JCTypeCast jcCast;
        this.resolve();
        if (expr instanceof SimpleName) {
            SimpleName name = (SimpleName)expr;
            IBinding binding = this.resolveName((Name)name);
            if (binding == null || binding.isRecovered() && !this.isRecoveringBindings()) {
                return null;
            }
            IBinding iBinding = binding;
            Objects.requireNonNull(iBinding);
            IBinding iBinding2 = iBinding;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVariableBinding.class, ITypeBinding.class, IMethodBinding.class}, (IBinding)iBinding2, n)) {
                case 0: {
                    IVariableBinding variableBinding = (IVariableBinding)iBinding2;
                    return variableBinding.getType();
                }
                case 1: {
                    ITypeBinding typeBinding = (ITypeBinding)iBinding2;
                    return typeBinding;
                }
                case 2: {
                    IMethodBinding methodBinding = (IMethodBinding)iBinding2;
                    return methodBinding.getReturnType();
                }
            }
            return null;
        }
        JCTree jcTree = this.converter.domToJavac.get(expr);
        if (jcTree instanceof JCTree.JCExpression) {
            JavacTypeBinding res;
            JCTree.JCExpression expression = (JCTree.JCExpression)jcTree;
            if (JavacBindingResolver.isTypeOfType(expression.type) && !expression.type.isErroneous() && (res = this.bindings.getTypeBinding(expression.type)) != null) {
                return res;
            }
        }
        if (jcTree instanceof JCTree.JCMethodInvocation) {
            Type.ErrorType errorType;
            com.sun.tools.javac.code.Type type;
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)jcTree;
            com.sun.tools.javac.code.Type variableBinding = javacMethodInvocation.meth.type;
            if (variableBinding instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)variableBinding;
                return this.bindings.getTypeBinding(methodType.getReturnType());
            }
            variableBinding = javacMethodInvocation.meth.type;
            if (variableBinding instanceof Type.ErrorType && (type = (errorType = (Type.ErrorType)variableBinding).getOriginalType()) instanceof Type.MethodType) {
                Type.MethodType methodType = (Type.MethodType)type;
                return this.bindings.getTypeBinding(methodType.getReturnType());
            }
            return null;
        }
        if (jcTree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)jcTree;
            if (newClass.type != null && Symtab.instance((Context)this.context).errSymbol == newClass.type.tsym) {
                jcTree = newClass.getIdentifier();
            }
        }
        if (jcTree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)jcTree;
            if (jcFieldAccess.type instanceof Type.PackageType) {
                return null;
            }
            if (expr instanceof SuperFieldAccess) {
                return this.bindings.getTypeBinding(jcFieldAccess.selected.type);
            }
            if (jcFieldAccess.type != null && !jcFieldAccess.type.isErroneous()) {
                return this.bindings.getTypeBinding(jcFieldAccess.type);
            }
            if (jcFieldAccess.sym != null) {
                return this.bindings.getTypeBinding(jcFieldAccess.sym.type);
            }
        }
        if (jcTree instanceof JCTree.JCVariableDecl) {
            JCTree.JCVariableDecl jcVariableDecl = (JCTree.JCVariableDecl)jcTree;
            if (jcVariableDecl.type != null) {
                return this.bindings.getTypeBinding(jcVariableDecl.type);
            }
            return null;
        }
        if (jcTree instanceof JCTree.JCTypeCast && (jcCast = (JCTree.JCTypeCast)jcTree).getType() != null) {
            return this.bindings.getTypeBinding(jcCast.getType().type);
        }
        if (jcTree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral jcLiteral = (JCTree.JCLiteral)jcTree;
            if (jcLiteral.type != null && jcLiteral.type.isErroneous()) {
                if (jcLiteral.typetag == TypeTag.CLASS) {
                    return this.resolveWellKnownType("java.lang.String");
                }
                if (jcLiteral.typetag == TypeTag.BOT) {
                    return this.bindings.getTypeBinding(Symtab.instance((Context)this.context).botType);
                }
                return this.resolveWellKnownType(jcLiteral.typetag.name().toLowerCase());
            }
        }
        if (jcTree instanceof JCTree.JCExpression) {
            JavacTypeBinding res;
            JCTree.JCExpression jcExpr = (JCTree.JCExpression)jcTree;
            if (jcExpr.type instanceof Type.PackageType) {
                return null;
            }
            Symbol recoveredSymbol = JavacBindingResolver.getRecoveredSymbol(jcExpr.type);
            if (recoveredSymbol != null) {
                IBinding recoveredBinding;
                IBinding iBinding = recoveredBinding = this.bindings.getBinding(recoveredSymbol, recoveredSymbol.type);
                Objects.requireNonNull(iBinding);
                IBinding iBinding3 = iBinding;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IVariableBinding.class, ITypeBinding.class, IMethodBinding.class}, (IBinding)iBinding3, n)) {
                    case 0 -> {
                        IVariableBinding variableBinding = (IVariableBinding)iBinding3;
                        yield variableBinding.getType();
                    }
                    case 1 -> {
                        ITypeBinding typeBinding;
                        yield typeBinding = (ITypeBinding)iBinding3;
                    }
                    case 2 -> {
                        IMethodBinding methodBinding = (IMethodBinding)iBinding3;
                        yield methodBinding.getReturnType();
                    }
                    default -> null;
                };
            }
            if (jcExpr.type != null && (res = this.bindings.getTypeBinding(jcExpr.type)) != null) {
                return res;
            }
            if (expr instanceof ClassInstanceCreation) {
                ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)expr;
                return this.createRecoveredTypeBinding(classInstanceCreation.getType());
            }
        }
        return null;
    }

    IMethodBinding resolveConstructor(ClassInstanceCreation expression) {
        return (IMethodBinding)this.resolveCached((ASTNode)expression, n -> this.resolveConstructorImpl((ClassInstanceCreation)n));
    }

    public static boolean isTypeOfType(com.sun.tools.javac.code.Type t) {
        boolean bl;
        if (t == null) {
            bl = false;
        } else {
            switch (t.getKind()) {
                case PACKAGE: 
                case MODULE: 
                case EXECUTABLE: 
                case OTHER: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private IMethodBinding resolveConstructorImpl(ClassInstanceCreation expression) {
        ITypeBinding type;
        this.resolve();
        JCTree jCTree = this.converter.domToJavac.get(expression);
        if (jCTree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass jcExpr = (JCTree.JCNewClass)jCTree;
            if (jcExpr.constructor != null && !jcExpr.constructor.type.isErroneous()) {
                return this.bindings.getMethodBinding(jcExpr.constructor.type.asMethodType(), (Symbol.MethodSymbol)jcExpr.constructor, jcExpr.type, false);
            }
        }
        if ((type = this.resolveType(expression.getType())) != null) {
            boolean hasTrailingNull;
            java.util.List<ITypeBinding> givenTypes = expression.arguments().stream().map(this::resolveExpressionType).toList();
            boolean matchExactParamCount = false;
            do {
                java.util.List<IMethodBinding> typeFilteredCandidates;
                hasTrailingNull = !givenTypes.isEmpty() && givenTypes.getLast() == null;
                boolean matchExactParamCountFinal = matchExactParamCount;
                java.util.List<ITypeBinding> finalGivenTypes = givenTypes;
                java.util.List<IMethodBinding> candidates = Arrays.stream(type.getDeclaredMethods()).filter(IMethodBinding::isConstructor).filter(other -> matchExactParamCountFinal ? other.getParameterTypes().length == finalGivenTypes.size() : other.getParameterTypes().length >= finalGivenTypes.size()).toList();
                if (candidates.size() == 1) {
                    return candidates.get(0);
                }
                if (candidates.size() > 1 && expression.arguments().size() > 0 && (typeFilteredCandidates = candidates.stream().filter(other -> this.matchTypes(finalGivenTypes, other.getParameterTypes())).toList()).size() == 1) {
                    return typeFilteredCandidates.get(0);
                }
                if (!hasTrailingNull) continue;
                givenTypes = givenTypes.subList(0, givenTypes.size() - 1);
                matchExactParamCount = true;
            } while (hasTrailingNull);
        }
        return null;
    }

    private boolean matchTypes(java.util.List<ITypeBinding> givenTypes, ITypeBinding[] expectedTypes) {
        for (int i = 0; i < Math.min(givenTypes.size(), expectedTypes.length); ++i) {
            ITypeBinding givenType = givenTypes.get(i);
            ITypeBinding expectedType = expectedTypes[i];
            if (givenType == null || givenType.isAssignmentCompatible(expectedType)) continue;
            return false;
        }
        return true;
    }

    IMethodBinding resolveConstructor(ConstructorInvocation invocation) {
        return (IMethodBinding)this.resolveCached((ASTNode)invocation, n -> this.resolveConstructorImpl((ConstructorInvocation)n));
    }

    private IMethodBinding resolveConstructorImpl(ConstructorInvocation invocation) {
        Symbol symbol;
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(invocation);
        if (javacElement instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation javacMethodInvocation = (JCTree.JCMethodInvocation)javacElement;
            javacElement = javacMethodInvocation.getMethodSelect();
        }
        if (javacElement instanceof JCTree.JCIdent) {
            JCTree.JCIdent ident = (JCTree.JCIdent)javacElement;
            symbol = ident.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(ident.type != null && ident.type.getKind() == TypeKind.EXECUTABLE ? ident.type.asMethodType() : methodSymbol.type.asMethodType(), methodSymbol, null, false);
            }
        }
        if (javacElement instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javacElement;
            symbol = fieldAccess.sym;
            if (symbol instanceof Symbol.MethodSymbol) {
                Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)symbol;
                return this.bindings.getMethodBinding(fieldAccess.type.asMethodType(), methodSymbol, null, false);
            }
        }
        return null;
    }

    public Types getTypes() {
        return Types.instance(this.context);
    }

    IModuleBinding resolveModule(ModuleDeclaration module) {
        return (IModuleBinding)this.resolveCached((ASTNode)module, n -> this.resolveModuleImpl((ModuleDeclaration)n));
    }

    private IBinding resolveModuleImpl(ModuleDeclaration module) {
        this.resolve();
        JCTree javacElement = this.converter.domToJavac.get(module);
        if (javacElement instanceof JCTree.JCModuleDecl) {
            JCTree.JCModuleDecl jcmd = (JCTree.JCModuleDecl)javacElement;
            com.sun.tools.javac.code.Type o = jcmd.sym.type;
            if (o instanceof Type.ModuleType) {
                Type.ModuleType mt = (Type.ModuleType)o;
                return this.bindings.getModuleBinding(mt);
            }
        }
        return null;
    }

    public Object getValueFromAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute instanceof Attribute.Constant) {
            Attribute.Constant constant = (Attribute.Constant)attribute;
            return constant.value;
        }
        if (attribute instanceof Attribute.Class) {
            Attribute.Class clazz = (Attribute.Class)attribute;
            return this.bindings.getTypeBinding(clazz.classType);
        }
        if (attribute instanceof Attribute.Enum) {
            Attribute.Enum enumm = (Attribute.Enum)attribute;
            return this.bindings.getVariableBinding(enumm.value, true);
        }
        if (attribute instanceof Attribute.Array) {
            Attribute.Array array = (Attribute.Array)attribute;
            return Stream.of(array.values).map(nestedAttr -> {
                if (nestedAttr instanceof Attribute.Constant) {
                    Attribute.Constant constant = (Attribute.Constant)nestedAttr;
                    return constant.value;
                }
                if (nestedAttr instanceof Attribute.Class) {
                    Attribute.Class clazz = (Attribute.Class)nestedAttr;
                    return this.bindings.getTypeBinding(clazz.classType);
                }
                if (nestedAttr instanceof Attribute.Enum) {
                    Attribute.Enum enumerable = (Attribute.Enum)nestedAttr;
                    return this.bindings.getVariableBinding(enumerable.value, true);
                }
                throw new IllegalArgumentException("Unexpected attribute type: " + nestedAttr.getClass().getCanonicalName());
            }).toArray(Object[]::new);
        }
        throw new IllegalArgumentException("Unexpected attribute type: " + attribute.getClass().getCanonicalName());
    }

    IBinding resolveImport(ImportDeclaration importDeclaration) {
        return this.resolveCached((ASTNode)importDeclaration, n -> this.resolveImportImpl((ImportDeclaration)n));
    }

    private IBinding resolveImportImpl(ImportDeclaration importDeclaration) {
        JCTree javac = this.converter.domToJavac.get(importDeclaration.getName());
        if (javac instanceof JCTree.JCFieldAccess) {
            com.sun.tools.javac.code.Type type;
            JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)javac;
            if (fieldAccess.sym != null) {
                return this.bindings.getBinding(fieldAccess.sym, null);
            }
            if (importDeclaration.isStatic() && (type = fieldAccess.getExpression().type) != null) {
                IBinding binding = Arrays.stream(this.bindings.getTypeBinding(type).getDeclaredMethods()).filter(method -> Objects.equals(fieldAccess.getIdentifier().toString(), method.getName())).findAny().orElse(null);
                if (binding == null) {
                    binding = Arrays.stream(this.bindings.getTypeBinding(type).getDeclaredFields()).filter(field -> Objects.equals(fieldAccess.getIdentifier().toString(), field.getName())).findAny().orElse(null);
                }
                return binding;
            }
        }
        return null;
    }

    public ITypeBinding resolveWellKnownType(String typeName) {
        com.sun.tools.javac.code.Type type;
        this.resolve();
        Symtab symtab = Symtab.instance(this.context);
        switch (typeName) {
            case "byte": 
            case "java.lang.Byte": {
                com.sun.tools.javac.code.Type type2 = symtab.byteType;
                break;
            }
            case "char": 
            case "java.lang.Character": {
                com.sun.tools.javac.code.Type type2 = symtab.charType;
                break;
            }
            case "double": 
            case "java.lang.Double": {
                com.sun.tools.javac.code.Type type2 = symtab.doubleType;
                break;
            }
            case "float": 
            case "java.lang.Float": {
                com.sun.tools.javac.code.Type type2 = symtab.floatType;
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                com.sun.tools.javac.code.Type type2 = symtab.intType;
                break;
            }
            case "long": 
            case "java.lang.Long": {
                com.sun.tools.javac.code.Type type2 = symtab.longType;
                break;
            }
            case "short": 
            case "java.lang.Short": {
                com.sun.tools.javac.code.Type type2 = symtab.shortType;
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                com.sun.tools.javac.code.Type type2 = symtab.booleanType;
                break;
            }
            case "void": 
            case "java.lang.Void": {
                com.sun.tools.javac.code.Type type2 = symtab.voidType;
                break;
            }
            case "java.lang.Object": {
                com.sun.tools.javac.code.Type type2 = symtab.objectType;
                break;
            }
            case "java.lang.String": {
                com.sun.tools.javac.code.Type type2 = symtab.stringType;
                break;
            }
            case "java.lang.StringBuffer": {
                com.sun.tools.javac.code.Type type2 = symtab.stringBufferType;
                break;
            }
            case "java.lang.Throwable": {
                com.sun.tools.javac.code.Type type2 = symtab.throwableType;
                break;
            }
            case "java.lang.Exception": {
                com.sun.tools.javac.code.Type type2 = symtab.exceptionType;
                break;
            }
            case "java.lang.RuntimeException": {
                com.sun.tools.javac.code.Type type2 = symtab.runtimeExceptionType;
                break;
            }
            case "java.lang.Error": {
                com.sun.tools.javac.code.Type type2 = symtab.errorType;
                break;
            }
            case "java.lang.Class": {
                com.sun.tools.javac.code.Type type2 = symtab.classType;
                break;
            }
            case "java.lang.Cloneable": {
                com.sun.tools.javac.code.Type type2 = symtab.cloneableType;
                break;
            }
            case "java.io.Serializable": {
                com.sun.tools.javac.code.Type type2 = symtab.serializableType;
                break;
            }
            default: {
                com.sun.tools.javac.code.Type type2 = type = null;
            }
        }
        if (type == null) {
            ClassFinder finder = ClassFinder.instance(this.context);
            Modules modules = Modules.instance(this.context);
            Names names = Names.instance(this.context);
            if (finder != null && modules != null && names != null) {
                try {
                    Symbol.ClassSymbol sym = finder.loadClass(modules.getDefaultModule(), names.fromString(typeName));
                    if (sym != null) {
                        type = sym.type;
                    }
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    // empty catch block
                }
            }
        }
        return type != null ? this.bindings.getTypeBinding(type, true) : null;
    }

    IAnnotationBinding resolveAnnotation(Annotation annotation) {
        return (IAnnotationBinding)this.resolveCached((ASTNode)annotation, n -> this.resolveAnnotationImpl((Annotation)n));
    }

    IAnnotationBinding resolveAnnotationImpl(Annotation annotation) {
        this.resolve();
        ITypeBinding recipient = null;
        ASTNode aSTNode = annotation.getParent();
        if (aSTNode instanceof AnnotatableType) {
            AnnotatableType annotatable = (AnnotatableType)aSTNode;
            recipient = annotatable.resolveBinding();
        } else {
            aSTNode = annotation.getParent();
            if (aSTNode instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)aSTNode;
                recipient = ((VariableDeclarationFragment)fieldDeclaration.fragments().get(0)).resolveBinding();
            } else {
                aSTNode = annotation.getParent();
                if (aSTNode instanceof TypeDeclaration) {
                    TypeDeclaration td = (TypeDeclaration)aSTNode;
                    recipient = td.resolveBinding();
                }
            }
        }
        JCTree javac = this.converter.domToJavac.get(annotation);
        if (javac instanceof JCTree.JCAnnotation) {
            JCTree.JCAnnotation jcAnnotation = (JCTree.JCAnnotation)javac;
            return this.bindings.getAnnotationBinding(jcAnnotation.attribute, (IBinding)recipient);
        }
        return null;
    }

    IMemberValuePairBinding resolveMemberValuePair(MemberValuePair memberValuePair) {
        this.resolve();
        Object object = this.converter.domToJavac.get(memberValuePair);
        if (object instanceof JCTree.JCAssign) {
            JCTree.JCAssign assign = (JCTree.JCAssign)object;
            object = assign.lhs;
            if (object instanceof JCTree.JCIdent) {
                JCTree.JCIdent ident = (JCTree.JCIdent)object;
                object = ident.sym;
                if (object instanceof Symbol.MethodSymbol) {
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)object;
                    return this.bindings.getMemberValuePairBinding(methodSymbol, null);
                }
            }
        }
        return null;
    }

    IBinding resolveReference(MethodRef ref) {
        return this.resolveCached((ASTNode)ref, n -> this.resolveReferenceImpl((MethodRef)n));
    }

    private IBinding resolveReferenceImpl(MethodRef ref) {
        DocTreePath[] possible;
        this.resolve();
        DocTreePath path = this.converter.findDocTreePath((ASTNode)ref);
        if (path != null) {
            Tree t;
            Element e = JavacTrees.instance(this.context).getElement(path);
            if (e instanceof Symbol) {
                Symbol symbol = (Symbol)e;
                IBinding r1 = this.bindings.getBinding(symbol, null);
                return r1;
            }
            TreePath dt = path.getTreePath();
            if (dt != null && (t = dt.getLeaf()) instanceof JCTree.JCMethodDecl) {
                JCTree.JCMethodDecl jcmd = (JCTree.JCMethodDecl)t;
                Symbol.MethodSymbol ms = jcmd.sym;
                IBinding r1 = ms == null ? null : this.bindings.getBinding(ms, jcmd.type);
                return r1;
            }
        }
        if (ref.parameters() != null && ref.parameters().size() == 0 && (possible = this.converter.searchRelatedDocTreePath(ref)) != null) {
            for (int i = 0; i < possible.length; ++i) {
                Symbol symbol;
                IBinding r1;
                Element e = JavacTrees.instance(this.context).getElement(possible[i]);
                if (!(e instanceof Symbol) || (r1 = this.bindings.getBinding(symbol = (Symbol)e, null)) == null) continue;
                return r1;
            }
        }
        return null;
    }

    private IBinding getFieldAccessBinding(JCTree.JCFieldAccess fieldAccess) {
        JCTree.JCFieldAccess jcfa3;
        JCTree.JCExpression jCExpression;
        JCTree.JCFieldAccess jcfa2;
        JCTree.JCFieldAccess jCFieldAccess = jcfa2 = fieldAccess.sym == null && (jCExpression = fieldAccess.selected) instanceof JCTree.JCFieldAccess ? (jcfa3 = (JCTree.JCFieldAccess)jCExpression) : fieldAccess;
        if (jcfa2.sym != null) {
            com.sun.tools.javac.code.Type typeToUse = jcfa2.type;
            if (jcfa2.selected instanceof JCTree.JCTypeApply) {
                typeToUse = jcfa2.sym.type;
            }
            IBinding bRet = this.bindings.getBinding(jcfa2.sym, typeToUse);
            if (jcfa2 != fieldAccess && bRet instanceof ITypeBinding) {
                ITypeBinding itb = (ITypeBinding)bRet;
                String fieldAccessIdentifier = fieldAccess.getIdentifier().toString();
                Function<IBinding[], IBinding> func = bindings -> {
                    for (int i = 0; i < ((IBinding[])bindings).length; ++i) {
                        String childName = bindings[i].getName();
                        if (!childName.equals(fieldAccessIdentifier)) continue;
                        return bindings[i];
                    }
                    return null;
                };
                IBinding ret = func.apply((IBinding[])itb.getDeclaredTypes());
                if (ret != null) {
                    return ret;
                }
                ret = func.apply((IBinding[])itb.getDeclaredFields());
                if (ret != null) {
                    return ret;
                }
                ret = func.apply((IBinding[])itb.getDeclaredMethods());
                if (ret != null) {
                    return ret;
                }
            }
            return bRet;
        }
        return null;
    }

    IBinding resolveReference(MemberRef ref) {
        return this.resolveCached((ASTNode)ref, n -> this.resolveReferenceImpl((MemberRef)n));
    }

    private IBinding resolveReferenceImpl(MemberRef ref) {
        Element element;
        this.resolve();
        DocTreePath path = this.converter.findDocTreePath((ASTNode)ref);
        if (path != null && (element = JavacTrees.instance(this.context).getElement(path)) instanceof Symbol) {
            Symbol symbol = (Symbol)element;
            return this.bindings.getBinding(symbol, null);
        }
        return null;
    }

    private static Symbol getRecoveredSymbol(com.sun.tools.javac.code.Type type) {
        if (type instanceof Type.ErrorType) {
            try {
                Field candidateSymbolField = type.getClass().getField("candidateSymbol");
                candidateSymbolField.setAccessible(true);
                Object symbolFieldValue = candidateSymbolField.get(type);
                if (symbolFieldValue instanceof Symbol) {
                    Symbol symbol = (Symbol)symbolFieldValue;
                    return symbol;
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return null;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return this.owner;
    }

    Object resolveConstantExpressionValue(Expression expression) {
        Object object;
        JCTree jcTree = this.converter.domToJavac.get(expression);
        if (jcTree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral literal = (JCTree.JCLiteral)jcTree;
            return literal.getValue();
        }
        Symbol symbol = TreeInfo.symbolFor(jcTree);
        if (symbol instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            object = varSymbol.getConstantValue();
        } else {
            object = null;
        }
        return object;
    }

    boolean resolveBoxing(Expression expression) {
        ASTNode aSTNode = expression.getParent();
        if (aSTNode instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)aSTNode;
            IMethodBinding mb = this.resolveMethod(mi);
            int foundArg = -1;
            if (mb != null) {
                ITypeBinding[] tbs;
                for (int i = 0; i < mi.arguments().size() && foundArg == -1; ++i) {
                    if (mi.arguments().get(i) != expression) continue;
                    foundArg = i;
                }
                if (foundArg != -1 && (tbs = mb.getParameterTypes()).length > foundArg) {
                    ITypeBinding foundType = tbs[foundArg];
                    if (expression instanceof NumberLiteral) {
                        NumberLiteral nl = (NumberLiteral)expression;
                        if (this.isBoxedVersion(nl, foundType)) {
                            return true;
                        }
                    } else if (expression instanceof MethodInvocation) {
                        ITypeBinding retTypeInner;
                        MethodInvocation inner = (MethodInvocation)expression;
                        JavacMethodBinding mbInner = (JavacMethodBinding)this.resolveMethod(inner);
                        ITypeBinding iTypeBinding = retTypeInner = mbInner == null ? null : mbInner.getReturnType();
                        if (this.isBoxedVersion(retTypeInner, foundType)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean isBoxedVersion(NumberLiteral unboxed, ITypeBinding boxed) {
        if (boxed instanceof JavacTypeBinding) {
            String boxedString;
            JavacTypeBinding boxedBind = (JavacTypeBinding)boxed;
            String string = boxedString = boxedBind.typeSymbol == null ? null : boxedBind.typeSymbol.toString();
            if ("java.lang.Integer".equals(boxedString) || "java.lang.Float".equals(boxedString) || "java.lang.Double".equals(boxedString)) {
                return true;
            }
        }
        return false;
    }

    private boolean isBoxedVersion(ITypeBinding unboxed, ITypeBinding boxed) {
        if (this.boxingMap == null) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("java.lang.Boolean", "boolean");
            m.put("java.lang.Byte", "byte");
            m.put("java.lang.Character", "char");
            m.put("java.lang.Float", "float");
            m.put("java.lang.Integer", "int");
            m.put("java.lang.Long", "long");
            m.put("java.lang.Short", "short");
            m.put("java.lang.Double", "double");
            this.boxingMap = m;
        }
        if (boxed instanceof JavacTypeBinding) {
            JavacTypeBinding boxedBind = (JavacTypeBinding)boxed;
            if (unboxed instanceof JavacTypeBinding) {
                String unboxedString;
                JavacTypeBinding unboxedBind = (JavacTypeBinding)unboxed;
                String boxedString = boxedBind.typeSymbol == null ? null : boxedBind.typeSymbol.toString();
                String string = unboxedString = unboxedBind.typeSymbol == null ? null : unboxedBind.typeSymbol.toString();
                if (this.boxingMap.get(boxedString) != null && unboxedString.equals(this.boxingMap.get(boxedString))) {
                    return true;
                }
                if (this.boxingMap.keySet().contains(boxedString) && this.boxingMap.values().contains(unboxedString)) {
                    return true;
                }
            }
        }
        return false;
    }

    boolean resolveUnboxing(Expression expression) {
        ASTNode aSTNode;
        Type t = null;
        if (expression instanceof ClassInstanceCreation) {
            ClassInstanceCreation cic = (ClassInstanceCreation)expression;
            t = cic.getType();
        }
        if (t != null && (aSTNode = expression.getParent()) instanceof MethodInvocation) {
            MethodInvocation mi = (MethodInvocation)aSTNode;
            int foundArg = -1;
            if (mi != null) {
                ITypeBinding el;
                ITypeBinding lastArg;
                ITypeBinding boxed;
                ITypeBinding unboxed;
                IMethodBinding mb;
                ITypeBinding[] tbs;
                for (int i = 0; i < mi.arguments().size() && foundArg == -1; ++i) {
                    if (mi.arguments().get(i) != expression) continue;
                    foundArg = i;
                }
                if (foundArg != -1 && ((tbs = (mb = this.resolveMethod(mi)).getParameterTypes()).length > foundArg ? this.isBoxedVersion(unboxed = tbs[foundArg], boxed = this.resolveType(t)) : tbs.length > 0 && mb.isVarargs() && (lastArg = tbs[tbs.length - 1]).isArray() && (el = lastArg.getElementType()).isPrimitive() && this.isBoxedVersion(el, this.resolveType(t)))) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isRecoveringBindings() {
        return this.isRecoveringBindings;
    }

    public class Bindings {
        private Map<String, JavacAnnotationBinding> annotationBindings = new HashMap<String, JavacAnnotationBinding>();
        private Map<String, JavacMemberValuePairBinding> memberValuePairBindings = new HashMap<String, JavacMemberValuePairBinding>();
        private Map<JavacMethodBinding, JavacMethodBinding> methodBindings = new HashMap<JavacMethodBinding, JavacMethodBinding>();
        private Map<String, JavacModuleBinding> moduleBindings = new HashMap<String, JavacModuleBinding>();
        private Map<String, JavacPackageBinding> packageBindings = new HashMap<String, JavacPackageBinding>();
        private Map<JavacTypeBinding, JavacTypeBinding> typeBinding = new HashMap<JavacTypeBinding, JavacTypeBinding>();
        private Map<JavacTypeVariableBinding, JavacTypeVariableBinding> typeVariableBindings = new HashMap<JavacTypeVariableBinding, JavacTypeVariableBinding>();
        private Map<String, JavacVariableBinding> variableBindings = new HashMap<String, JavacVariableBinding>();
        private Map<String, JavacLambdaBinding> lambdaBindings = new HashMap<String, JavacLambdaBinding>();

        public JavacAnnotationBinding getAnnotationBinding(Attribute.Compound ann, IBinding recipient) {
            JavacAnnotationBinding newInstance = new JavacAnnotationBinding(this, ann, JavacBindingResolver.this, recipient){};
            String k = newInstance.getKey();
            if (k != null) {
                this.annotationBindings.putIfAbsent(k, newInstance);
                return this.annotationBindings.get(k);
            }
            return null;
        }

        public JavacMemberValuePairBinding getMemberValuePairBinding(Symbol.MethodSymbol key, Attribute value) {
            JavacMemberValuePairBinding newInstance = new JavacMemberValuePairBinding(this, key, value, JavacBindingResolver.this){};
            String k = newInstance.getKey();
            if (k != null) {
                this.memberValuePairBindings.putIfAbsent(k, newInstance);
                return this.memberValuePairBindings.get(k);
            }
            return null;
        }

        public JavacMethodBinding getMethodBinding(Type.MethodType methodType, Symbol.MethodSymbol sym, com.sun.tools.javac.code.Type type, boolean isSynthetic, boolean isDeclaration) {
            if (isSynthetic) {
                return this.getSyntheticMethodBinding(methodType, sym, type);
            }
            return this.getMethodBinding(methodType, sym, type, isDeclaration);
        }

        public JavacMethodBinding getMethodBinding(Type.MethodType methodType, Symbol.MethodSymbol methodSymbol, com.sun.tools.javac.code.Type parentType, boolean isDeclaration) {
            JavacMethodBinding newInstance = new JavacMethodBinding(this, methodType, methodSymbol, parentType, JavacBindingResolver.this, false, isDeclaration){};
            return this.insertAndReturn(newInstance);
        }

        public JavacMethodBinding getSyntheticMethodBinding(Type.MethodType methodType, Symbol.MethodSymbol methodSymbol, com.sun.tools.javac.code.Type parentType) {
            JavacMethodBinding newInstance = new JavacMethodBinding(this, methodType, methodSymbol, parentType, JavacBindingResolver.this, true, false){};
            return this.insertAndReturn(newInstance);
        }

        public JavacMethodBinding getErrorMethodBinding(Type.MethodType methodType, Symbol originatingSymbol) {
            JavacErrorMethodBinding newInstance = new JavacErrorMethodBinding(this, originatingSymbol, methodType, JavacBindingResolver.this){};
            return this.insertAndReturn(newInstance);
        }

        private JavacMethodBinding insertAndReturn(JavacMethodBinding newInstance) {
            this.methodBindings.putIfAbsent(newInstance, newInstance);
            return this.methodBindings.get(newInstance);
        }

        public JavacModuleBinding getModuleBinding(Type.ModuleType moduleType) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleType, JavacBindingResolver.this){};
            String k = newInstance.getKey();
            if (k != null) {
                this.moduleBindings.putIfAbsent(k, newInstance);
                return this.moduleBindings.get(k);
            }
            return null;
        }

        public JavacModuleBinding getModuleBinding(Symbol.ModuleSymbol moduleSymbol) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleSymbol, JavacBindingResolver.this){};
            String k = newInstance.getKey();
            if (k != null) {
                this.moduleBindings.putIfAbsent(k, newInstance);
                return this.moduleBindings.get(k);
            }
            return null;
        }

        public JavacModuleBinding getModuleBinding(JCTree.JCModuleDecl moduleDecl) {
            JavacModuleBinding newInstance = new JavacModuleBinding(this, moduleDecl, JavacBindingResolver.this){};
            String k = newInstance.getKey();
            if (k != null) {
                this.moduleBindings.put(k, newInstance);
                return this.moduleBindings.get(k);
            }
            return null;
        }

        public JavacPackageBinding getPackageBinding(Symbol.PackageSymbol packageSymbol) {
            Symbol.PackageSymbol parentPack;
            if (!packageSymbol.exists()) {
                return null;
            }
            Symbol symbol = packageSymbol.owner;
            if (symbol instanceof Symbol.PackageSymbol && !((parentPack = (Symbol.PackageSymbol)symbol) instanceof Symbol.RootPackageSymbol)) {
                this.getPackageBinding(parentPack);
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, packageSymbol, JavacBindingResolver.this){};
            return this.preferentiallyInsertPackageBinding(newInstance);
        }

        public JavacPackageBinding getPackageBinding(Name name) {
            String n = this.packageNameToString(name);
            if (n == null) {
                return null;
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, n, JavacBindingResolver.this){};
            return this.preferentiallyInsertPackageBinding(newInstance);
        }

        public JavacPackageBinding findExistingPackageBinding(Name name) {
            String k;
            String n;
            String string = n = name == null ? null : name.toString();
            if (n == null) {
                return null;
            }
            JavacPackageBinding newInstance = new JavacPackageBinding(this, n, JavacBindingResolver.this){};
            String string2 = k = newInstance == null ? null : newInstance.getKey();
            if (k != null) {
                JavacPackageBinding current = this.packageBindings.get(k);
                return current;
            }
            return null;
        }

        private String packageNameToString(Name name) {
            ASTNode aSTNode;
            String n = null;
            if (name instanceof QualifiedName) {
                n = name.toString();
            } else if (name instanceof SimpleName && (aSTNode = name.getParent()) instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)aSTNode;
                if (qn.getName() == name) {
                    n = qn.toString();
                } else if (qn.getQualifier() == name) {
                    n = name.toString();
                }
            }
            return n;
        }

        private JavacPackageBinding preferentiallyInsertPackageBinding(JavacPackageBinding newest) {
            String k;
            String string = k = newest == null ? null : newest.getKey();
            if (k != null) {
                JavacPackageBinding current = this.packageBindings.get(k);
                if (current == null) {
                    this.packageBindings.putIfAbsent(k, newest);
                } else if (current.getPackageSymbol() == null && newest.getPackageSymbol() != null) {
                    current.setPackageSymbol(newest.getPackageSymbol());
                }
                return this.packageBindings.get(k);
            }
            return null;
        }

        public JavacTypeBinding getTypeBinding(JCTree tree, com.sun.tools.javac.code.Type type) {
            return this.getTypeBinding(type, tree instanceof JCTree.JCClassDecl);
        }

        public JavacTypeBinding getTypeBinding(com.sun.tools.javac.code.Type type) {
            if (type == null) {
                return null;
            }
            return this.getTypeBinding(type.baseType(), false);
        }

        public JavacTypeBinding getTypeBinding(com.sun.tools.javac.code.Type type, boolean isDeclaration) {
            if (type instanceof Type.TypeVar) {
                Type.TypeVar typeVar = (Type.TypeVar)type;
                return this.getTypeVariableBinding(typeVar);
            }
            if (type == null || type == com.sun.tools.javac.code.Type.noType) {
                return null;
            }
            if (type instanceof Type.ErrorType) {
                Symbol.ClassSymbol classErrorSymbol;
                Type.ErrorType errorType = (Type.ErrorType)type;
                com.sun.tools.javac.code.Type originalType = errorType.getOriginalType();
                if (!(originalType == com.sun.tools.javac.code.Type.noType || originalType instanceof Type.MethodType || originalType instanceof Type.ForAll || originalType instanceof Type.ErrorType)) {
                    JavacTypeBinding newInstance = new JavacTypeBinding(this, originalType, type.tsym, isDeclaration, JavacBindingResolver.this){};
                    this.typeBinding.putIfAbsent(newInstance, newInstance);
                    JavacTypeBinding jcb = this.typeBinding.get(newInstance);
                    jcb.setRecovered(true);
                    return jcb;
                }
                Object newInstance = errorType.tsym;
                if (newInstance instanceof Symbol.ClassSymbol && Character.isJavaIdentifierStart((classErrorSymbol = (Symbol.ClassSymbol)newInstance).getSimpleName().charAt(0))) {
                    newInstance = new JavacTypeBinding(this, classErrorSymbol.type, classErrorSymbol, isDeclaration, JavacBindingResolver.this){};
                    this.typeBinding.putIfAbsent((JavacTypeBinding)newInstance, (JavacTypeBinding)newInstance);
                    JavacTypeBinding jcb = this.typeBinding.get(newInstance);
                    jcb.setRecovered(true);
                    return jcb;
                }
                return null;
            }
            if (!type.isParameterized() && !type.isRaw() && type instanceof Type.ClassType) {
                Type.ClassType classType = (Type.ClassType)type;
                if (classType.interfaces_field == null) {
                    type = type.tsym.type;
                }
            }
            JavacTypeBinding newInstance = new JavacTypeBinding(this, type, type.tsym, isDeclaration, JavacBindingResolver.this){};
            this.typeBinding.putIfAbsent(newInstance, newInstance);
            return this.typeBinding.get(newInstance);
        }

        public JavacTypeVariableBinding getTypeVariableBinding(Type.TypeVar typeVar) {
            JavacTypeVariableBinding newInstance = new JavacTypeVariableBinding(this, typeVar, (Symbol.TypeVariableSymbol)typeVar.tsym, JavacBindingResolver.this){};
            this.typeVariableBindings.putIfAbsent(newInstance, newInstance);
            return this.typeVariableBindings.get(newInstance);
        }

        public JavacVariableBinding getVariableBinding(Symbol.VarSymbol varSymbol, boolean isUnique) {
            if (varSymbol == null) {
                return null;
            }
            JavacVariableBinding newInstance = new JavacVariableBinding(this, varSymbol, JavacBindingResolver.this, isUnique){};
            String k = newInstance.getKey();
            if (k != null) {
                this.variableBindings.putIfAbsent(k, newInstance);
                return this.variableBindings.get(k);
            }
            return null;
        }

        public JavacLambdaBinding getLambdaBinding(JavacMethodBinding javacMethodBinding, LambdaExpression lambda) {
            JavacLambdaBinding newInstance = new JavacLambdaBinding(javacMethodBinding, lambda);
            String k = newInstance.getKey();
            if (k != null) {
                this.lambdaBindings.putIfAbsent(k, newInstance);
                return this.lambdaBindings.get(k);
            }
            return null;
        }

        public IBinding getBinding(Symbol owner, com.sun.tools.javac.code.Type type) {
            com.sun.tools.javac.code.Type type2;
            Symbol recoveredSymbol = JavacBindingResolver.getRecoveredSymbol(type);
            if (recoveredSymbol != null) {
                return this.getBinding(recoveredSymbol, recoveredSymbol.type);
            }
            if (type != null && (type instanceof Type.ErrorType || owner.owner == null || owner.owner.type == com.sun.tools.javac.code.Type.noType) && (type2 = type.getOriginalType()) instanceof Type.MethodType) {
                Type.MethodType missingMethodType = (Type.MethodType)type2;
                return this.getErrorMethodBinding(missingMethodType, owner);
            }
            if (owner instanceof Symbol.PackageSymbol) {
                Symbol.PackageSymbol other = (Symbol.PackageSymbol)owner;
                return this.getPackageBinding(other);
            }
            if (owner instanceof Symbol.ModuleSymbol) {
                Symbol.ModuleSymbol typeSymbol = (Symbol.ModuleSymbol)owner;
                return this.getModuleBinding(typeSymbol);
            }
            if (owner instanceof Symbol.TypeVariableSymbol) {
                Symbol.TypeVariableSymbol typeVariableSymbol = (Symbol.TypeVariableSymbol)owner;
                if (type instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)type;
                    return this.getTypeVariableBinding(typeVar);
                }
                com.sun.tools.javac.code.Type type3 = typeVariableSymbol.type;
                if (type3 instanceof Type.TypeVar) {
                    Type.TypeVar typeVar = (Type.TypeVar)type3;
                    return this.getTypeVariableBinding(typeVar);
                }
            } else {
                if (owner instanceof Symbol.TypeSymbol) {
                    Symbol.TypeSymbol typeSymbol = (Symbol.TypeSymbol)owner;
                    return this.getTypeBinding(JavacBindingResolver.isTypeOfType(type) ? type : typeSymbol.type);
                }
                if (owner instanceof Symbol.MethodSymbol) {
                    Type.MethodType methodType;
                    Type.MethodType aMethodType;
                    Symbol.MethodSymbol other = (Symbol.MethodSymbol)owner;
                    Type.MethodType methodType2 = type instanceof Type.MethodType ? (aMethodType = (Type.MethodType)type) : (methodType = owner.type != null ? owner.type.asMethodType() : null);
                    if (methodType != null) {
                        return this.getMethodBinding(methodType, other, null, false);
                    }
                } else if (owner instanceof Symbol.VarSymbol) {
                    Symbol.VarSymbol other = (Symbol.VarSymbol)owner;
                    if (JavacBindingResolver.this.symbolToDeclaration != null) {
                        ASTNode ownerDecl = JavacBindingResolver.this.symbolToDeclaration.get(owner.owner);
                        MethodDeclaration methodDecl = (MethodDeclaration)DOMCompletionUtil.findParent(ownerDecl, new int[]{31});
                        if (methodDecl != null) {
                            boolean isUnique = JavacBindingResolver.calculateIsUnique(methodDecl, other.name.toString());
                            return this.getVariableBinding(other, isUnique);
                        }
                        return this.getVariableBinding(other, true);
                    }
                }
            }
            return null;
        }

        public IBinding getBinding(String key) {
            IBinding binding = (IBinding)this.annotationBindings.get(key);
            if (binding != null) {
                return binding;
            }
            binding = (IBinding)this.memberValuePairBindings.get(key);
            if (binding != null) {
                return binding;
            }
            binding = this.methodBindings.values().stream().filter(methodBindings -> key.equals(methodBindings.getKey())).findAny().orElse(null);
            if (binding != null) {
                return binding;
            }
            binding = (IBinding)this.moduleBindings.get(key);
            if (binding != null) {
                return binding;
            }
            binding = (IBinding)this.packageBindings.get(key);
            if (binding != null) {
                return binding;
            }
            binding = this.typeBinding.values().stream().filter(typeBinding -> key.equals(typeBinding.getKey())).findAny().orElse(null);
            if (binding != null) {
                return binding;
            }
            return (IBinding)this.variableBindings.get(key);
        }
    }

    public static class BindingKeyException
    extends Exception {
        private static final long serialVersionUID = -4468681148041117634L;

        public BindingKeyException(Throwable t) {
            super(t);
        }

        public BindingKeyException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

