/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.runner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import junit.extensions.TestDecorator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jdt.internal.junit.runner.ITestPrioritizer;

public class FailuresFirstPrioritizer
implements ITestPrioritizer {
    private HashSet<String> fPriorities;

    public FailuresFirstPrioritizer(String[] priorities) {
        this.fPriorities = new HashSet<String>(Arrays.asList(priorities));
    }

    @Override
    public Test prioritize(Test suite) {
        this.doPrioritize(suite, new ArrayList<Test>());
        return suite;
    }

    private void doPrioritize(Test suite, List<Test> path) {
        if (suite instanceof TestCase) {
            TestCase testCase = (TestCase)suite;
            if (this.hasPriority(testCase)) {
                this.reorder((Test)testCase, path);
            }
        } else if (suite instanceof TestSuite) {
            TestSuite aSuite = (TestSuite)suite;
            path.add(suite);
            this.loopTests(path, aSuite);
            path.remove(path.size() - 1);
        } else if (suite instanceof TestDecorator) {
            TestDecorator aDecorator = (TestDecorator)suite;
            path.add((Test)aDecorator);
            this.doPrioritize(aDecorator.getTest(), path);
            path.remove(path.size() - 1);
        }
    }

    private void loopTests(List<Test> path, TestSuite aSuite) {
        Enumeration e = aSuite.tests();
        while (e.hasMoreElements()) {
            this.doPrioritize((Test)e.nextElement(), path);
        }
    }

    private void reorder(Test test, List<Test> path) {
        this.doReorder(test, path, path.size() - 1);
    }

    private void doReorder(Test test, List<Test> path, int top) {
        if (top < 0) {
            return;
        }
        Test topTest = path.get(top);
        if (topTest instanceof TestSuite) {
            TestSuite suite = (TestSuite)topTest;
            this.moveTestToFront(suite, test);
        }
        this.doReorder(topTest, path, top - 1);
    }

    void moveTestToFront(TestSuite suite, Test test) {
        Vector tests = (Vector)FailuresFirstPrioritizer.getField(suite, "fTests");
        int i = 0;
        while (i < tests.size()) {
            if (tests.get(i) == test) {
                tests.remove(i);
                tests.insertElementAt(test, 0);
            }
            ++i;
        }
    }

    private boolean hasPriority(TestCase testCase) {
        return this.fPriorities.contains(testCase.toString());
    }

    public static Object getField(Object object, String fieldName) {
        return FailuresFirstPrioritizer.getFieldInClass(object, fieldName, object.getClass());
    }

    private static Object getFieldInClass(Object object, String fieldName, Class<?> clazz) {
        Field field = null;
        if (clazz == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception exception) {
            return FailuresFirstPrioritizer.getFieldInClass(object, fieldName, clazz.getSuperclass());
        }
    }
}

