/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corrections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.manipulation.ChangeCorrectionProposalCore;
import org.eclipse.jdt.internal.core.manipulation.dom.ASTResolving;
import org.eclipse.jdt.internal.core.manipulation.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.core.manipulation.dom.OperatorPrecedence;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposalCore;
import org.eclipse.jdt.ls.core.internal.Messages;
import org.eclipse.jdt.ls.core.internal.corrections.CorrectionMessages;
import org.eclipse.jdt.ls.core.internal.corrections.ProposalKindWrapper;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.text.correction.CUCorrectionCommandProposal;
import org.eclipse.jdt.ls.core.internal.text.correction.QuickAssistProcessor;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposalCore;
import org.eclipse.lsp4j.CodeActionParams;

public class InvertBooleanUtility {
    public static final String INVERT_VARIABLE_COMMAND = "invertVariable";

    public static ProposalKindWrapper getInvertVariableProposal(CodeActionParams params, IInvocationContext context, ASTNode covering, boolean returnAsCommand) {
        Object newIdentifier;
        String notString;
        if (!(covering instanceof SimpleName)) {
            return null;
        }
        SimpleName coveringName = (SimpleName)covering;
        if (!coveringName.isDeclaration()) {
            return null;
        }
        final IBinding variableBinding = coveringName.resolveBinding();
        if (!(variableBinding instanceof IVariableBinding)) {
            return null;
        }
        IVariableBinding binding = (IVariableBinding)variableBinding;
        if (binding.isField()) {
            return null;
        }
        if (!InvertBooleanUtility.isBoolean((Expression)coveringName)) {
            return null;
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseBooleanVariable;
        if (returnAsCommand) {
            CUCorrectionCommandProposal p = new CUCorrectionCommandProposal(label, context.getCompilationUnit(), 1, "java.action.applyRefactoringCommand", Arrays.asList(INVERT_VARIABLE_COMMAND, params));
            return CodeActionHandler.wrap((ChangeCorrectionProposalCore)p, "refactor");
        }
        final AST ast = covering.getAST();
        MethodDeclaration method = ASTResolving.findParentMethodDeclaration((ASTNode)covering);
        SimpleName[] linkedNodes = LinkedNodeFinder.findByBinding((ASTNode)method, (IBinding)variableBinding);
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        String KEY_NAME = "name";
        LinkedCorrectionProposalCore proposal = new LinkedCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 1);
        String oldIdentifier = coveringName.getIdentifier();
        if (oldIdentifier.startsWith(notString = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, ""))) {
            int notLength = notString.length();
            newIdentifier = oldIdentifier.length() > notLength ? Character.toLowerCase(oldIdentifier.charAt(notLength)) + oldIdentifier.substring(notLength + 1) : oldIdentifier;
        } else {
            newIdentifier = Messages.format(CorrectionMessages.AdvancedQuickAssistProcessor_negatedVariableName, Character.toUpperCase(oldIdentifier.charAt(0)) + oldIdentifier.substring(1));
        }
        proposal.addLinkedPositionProposal("name", (String)newIdentifier);
        proposal.addLinkedPositionProposal("name", oldIdentifier);
        final HashSet renamedNames = new HashSet();
        int i = 0;
        while (i < linkedNodes.length) {
            SimpleName name = linkedNodes[i];
            if (!renamedNames.contains(name)) {
                SimpleName newName = ast.newSimpleName((String)newIdentifier);
                proposal.addLinkedPosition(rewrite.track((ASTNode)newName), name == coveringName, "name");
                StructuralPropertyDescriptor location = name.getLocationInParent();
                if (location == SingleVariableDeclaration.NAME_PROPERTY) {
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else if (location == Assignment.LEFT_HAND_SIDE_PROPERTY) {
                    Assignment assignment = (Assignment)name.getParent();
                    expression = assignment.getRightHandSide();
                    int exStart = expression.getStartPosition();
                    int exEnd = exStart + expression.getLength();
                    HashSet<SimpleName> overlapNames = new HashSet<SimpleName>();
                    int j = 0;
                    while (j < linkedNodes.length) {
                        int name2Start;
                        SimpleName name2 = linkedNodes[j];
                        if (name2 != null && exStart <= (name2Start = name2.getStartPosition()) && name2Start < exEnd) {
                            overlapNames.add(name2);
                        }
                        ++j;
                    }
                    SimpleNameRenameProvider provider = new SimpleNameRenameProvider((String)newIdentifier){
                        private final /* synthetic */ String val$newIdentifier;
                        {
                            this.val$newIdentifier = string;
                        }

                        @Override
                        public SimpleName getRenamed(SimpleName simpleName) {
                            if (simpleName.resolveBinding() == variableBinding) {
                                renamedNames.add(simpleName);
                                return ast.newSimpleName(this.val$newIdentifier);
                            }
                            return null;
                        }
                    };
                    Expression inversedExpression = InvertBooleanUtility.getInversedExpression(rewrite, expression, provider);
                    for (Object e : overlapNames) {
                        if (renamedNames.contains(e)) continue;
                        return null;
                    }
                    Assignment.Operator operator = assignment.getOperator();
                    if (operator == Assignment.Operator.BIT_AND_ASSIGN) {
                        Assignment assignment2 = ast.newAssignment();
                        assignment2.setLeftHandSide((Expression)newName);
                        assignment2.setRightHandSide(inversedExpression);
                        assignment2.setOperator(Assignment.Operator.BIT_OR_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment2, null);
                    } else if (operator == Assignment.Operator.BIT_OR_ASSIGN) {
                        Assignment assignment3 = ast.newAssignment();
                        assignment3.setLeftHandSide((Expression)newName);
                        assignment3.setRightHandSide(inversedExpression);
                        assignment3.setOperator(Assignment.Operator.BIT_AND_ASSIGN);
                        rewrite.replace((ASTNode)assignment, (ASTNode)assignment3, null);
                    } else {
                        rewrite.replace((ASTNode)expression, (ASTNode)inversedExpression, null);
                        rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                    }
                } else if (location == VariableDeclarationFragment.NAME_PROPERTY) {
                    VariableDeclarationFragment vdf = (VariableDeclarationFragment)name.getParent();
                    expression = vdf.getInitializer();
                    if (expression != null) {
                        rewrite.replace((ASTNode)expression, (ASTNode)InvertBooleanUtility.getInversedExpression(rewrite, expression), null);
                    }
                    rewrite.replace((ASTNode)name, (ASTNode)newName, null);
                } else {
                    PrefixExpression prefixExpression;
                    ASTNode aSTNode = name.getParent();
                    if (aSTNode instanceof PrefixExpression && (prefixExpression = (PrefixExpression)aSTNode).getOperator() == PrefixExpression.Operator.NOT) {
                        rewrite.replace(name.getParent(), (ASTNode)newName, null);
                    } else {
                        PrefixExpression expression = ast.newPrefixExpression();
                        expression.setOperator(PrefixExpression.Operator.NOT);
                        expression.setOperand((Expression)newName);
                        rewrite.replace((ASTNode)name, (ASTNode)expression, null);
                    }
                }
            }
            ++i;
        }
        return CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor");
    }

    public static boolean getInverseConditionProposals(CodeActionParams params, IInvocationContext context, ASTNode covering, Collection<ProposalKindWrapper> proposals) {
        ArrayList<ASTNode> coveredNodes = QuickAssistProcessor.getFullyCoveredNodes(context, covering);
        return InvertBooleanUtility.getInverseConditionProposals(params, context, covering, coveredNodes, proposals);
    }

    private static boolean getInverseConditionProposals(CodeActionParams params, IInvocationContext context, ASTNode covering, ArrayList<ASTNode> coveredNodes, Collection<ProposalKindWrapper> proposals) {
        ASTRewrite rewrite;
        if (proposals == null) {
            return false;
        }
        if (context.getSelectionLength() == 0) {
            Expression foundExpression = null;
            while (covering instanceof Expression) {
                Expression booleanExpression = InvertBooleanUtility.getBooleanExpression(covering);
                if (booleanExpression != null) {
                    foundExpression = InvertBooleanUtility.getBooleanExpression(covering);
                }
                covering = covering.getParent();
            }
            if (foundExpression == null) {
                return false;
            }
            AST ast = foundExpression.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            Expression inversedExpression = InvertBooleanUtility.getInversedExpression(rewrite, foundExpression);
            rewrite.replace((ASTNode)foundExpression, (ASTNode)inversedExpression, null);
        } else {
            if (coveredNodes.isEmpty()) {
                return false;
            }
            AST ast = covering.getAST();
            rewrite = ASTRewrite.create((AST)ast);
            boolean hasChanges = false;
            for (ASTNode covered : coveredNodes) {
                Expression coveredExpression = InvertBooleanUtility.getBooleanExpression(covered);
                if (coveredExpression == null) continue;
                Expression inversedExpression = InvertBooleanUtility.getInversedExpression(rewrite, coveredExpression);
                rewrite.replace((ASTNode)coveredExpression, (ASTNode)inversedExpression, null);
                hasChanges = true;
            }
            if (!hasChanges) {
                return false;
            }
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_inverseConditions_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 1);
        proposals.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "refactor"));
        return true;
    }

    private static Expression getInversedNotExpression(ASTRewrite rewrite, Expression expression, AST ast) {
        PrefixExpression prefixExpression = ast.newPrefixExpression();
        prefixExpression.setOperator(PrefixExpression.Operator.NOT);
        ParenthesizedExpression parenthesizedExpression = InvertBooleanUtility.getParenthesizedExpression(ast, (Expression)rewrite.createCopyTarget((ASTNode)expression));
        prefixExpression.setOperand((Expression)parenthesizedExpression);
        return prefixExpression;
    }

    private static boolean isBoolean(Expression expression) {
        AST ast;
        ITypeBinding typeBinding = expression.resolveTypeBinding();
        return typeBinding == (ast = expression.getAST()).resolveWellKnownType("boolean") || typeBinding == ast.resolveWellKnownType("java.lang.Boolean");
    }

    private static Expression getBooleanExpression(ASTNode node) {
        if (!(node instanceof Expression)) {
            return null;
        }
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent == QualifiedName.NAME_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        while (locationInParent == ParenthesizedExpression.EXPRESSION_PROPERTY) {
            node = node.getParent();
            locationInParent = node.getLocationInParent();
        }
        Expression expression = (Expression)node;
        if (!InvertBooleanUtility.isBoolean(expression)) {
            return null;
        }
        if (expression.getParent() instanceof InfixExpression) {
            return expression;
        }
        if (locationInParent == Assignment.RIGHT_HAND_SIDE_PROPERTY || locationInParent == IfStatement.EXPRESSION_PROPERTY || locationInParent == WhileStatement.EXPRESSION_PROPERTY || locationInParent == DoStatement.EXPRESSION_PROPERTY || locationInParent == ReturnStatement.EXPRESSION_PROPERTY || locationInParent == ForStatement.EXPRESSION_PROPERTY || locationInParent == AssertStatement.EXPRESSION_PROPERTY || locationInParent == MethodInvocation.ARGUMENTS_PROPERTY || locationInParent == ConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == SuperMethodInvocation.ARGUMENTS_PROPERTY || locationInParent == EnumConstantDeclaration.ARGUMENTS_PROPERTY || locationInParent == SuperConstructorInvocation.ARGUMENTS_PROPERTY || locationInParent == ClassInstanceCreation.ARGUMENTS_PROPERTY || locationInParent == ConditionalExpression.EXPRESSION_PROPERTY || locationInParent == PrefixExpression.OPERAND_PROPERTY) {
            return expression;
        }
        return null;
    }

    private static Expression getInversedInfixExpression(ASTRewrite rewrite, InfixExpression expression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        newExpression.setLeftOperand(InvertBooleanUtility.getRenamedNameCopy(provider, rewrite, expression.getLeftOperand()));
        newExpression.setRightOperand(InvertBooleanUtility.getRenamedNameCopy(provider, rewrite, expression.getRightOperand()));
        return newExpression;
    }

    private static Expression parenthesizeIfRequired(Expression operand, int newOperatorPrecedence) {
        if (newOperatorPrecedence > OperatorPrecedence.getExpressionPrecedence((Expression)operand)) {
            return InvertBooleanUtility.getParenthesizedExpression(operand.getAST(), operand);
        }
        return operand;
    }

    private static ParenthesizedExpression getParenthesizedExpression(AST ast, Expression expression) {
        ParenthesizedExpression parenthesizedExpression = ast.newParenthesizedExpression();
        parenthesizedExpression.setExpression(expression);
        return parenthesizedExpression;
    }

    private static Expression getInversedAndOrExpression(ASTRewrite rewrite, InfixExpression infixExpression, InfixExpression.Operator newOperator, SimpleNameRenameProvider provider) {
        InfixExpression newExpression = rewrite.getAST().newInfixExpression();
        newExpression.setOperator(newOperator);
        int newOperatorPrecedence = OperatorPrecedence.getOperatorPrecedence((InfixExpression.Operator)newOperator);
        Expression leftOperand = InvertBooleanUtility.getInversedExpression(rewrite, infixExpression.getLeftOperand(), provider);
        newExpression.setLeftOperand(InvertBooleanUtility.parenthesizeIfRequired(leftOperand, newOperatorPrecedence));
        Expression rightOperand = InvertBooleanUtility.getInversedExpression(rewrite, infixExpression.getRightOperand(), provider);
        newExpression.setRightOperand(InvertBooleanUtility.parenthesizeIfRequired(rightOperand, newOperatorPrecedence));
        List extraOperands = infixExpression.extendedOperands();
        List newExtraOperands = newExpression.extendedOperands();
        int i = 0;
        while (i < extraOperands.size()) {
            Expression extraOperand = InvertBooleanUtility.getInversedExpression(rewrite, (Expression)extraOperands.get(i), provider);
            newExtraOperands.add(InvertBooleanUtility.parenthesizeIfRequired(extraOperand, newOperatorPrecedence));
            ++i;
        }
        return newExpression;
    }

    private static Expression getRenamedNameCopy(SimpleNameRenameProvider provider, ASTRewrite rewrite, Expression expression) {
        SimpleName name;
        SimpleName newName;
        if (provider != null && expression instanceof SimpleName && (newName = provider.getRenamed(name = (SimpleName)expression)) != null) {
            return newName;
        }
        return (Expression)rewrite.createCopyTarget((ASTNode)expression);
    }

    private static Expression getInversedExpression(ASTRewrite rewrite, Expression expression) {
        return InvertBooleanUtility.getInversedExpression(rewrite, expression, null);
    }

    private static Expression getInversedExpression(ASTRewrite rewrite, Expression expression, SimpleNameRenameProvider provider) {
        PrefixExpression prefixExpression;
        AST ast = rewrite.getAST();
        if (expression instanceof BooleanLiteral) {
            BooleanLiteral booleanLiteral = (BooleanLiteral)expression;
            return ast.newBooleanLiteral(!booleanLiteral.booleanValue());
        }
        if (expression instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)expression;
            InfixExpression.Operator operator = infixExpression.getOperator();
            if (operator == InfixExpression.Operator.LESS) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.GREATER) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.LESS_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.LESS_EQUALS) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.GREATER, provider);
            }
            if (operator == InfixExpression.Operator.GREATER_EQUALS) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.LESS, provider);
            }
            if (operator == InfixExpression.Operator.EQUALS) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.NOT_EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.NOT_EQUALS) {
                return InvertBooleanUtility.getInversedInfixExpression(rewrite, infixExpression, InfixExpression.Operator.EQUALS, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_AND) {
                return InvertBooleanUtility.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_OR, provider);
            }
            if (operator == InfixExpression.Operator.CONDITIONAL_OR) {
                return InvertBooleanUtility.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.CONDITIONAL_AND, provider);
            }
            if (operator == InfixExpression.Operator.AND) {
                return InvertBooleanUtility.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.OR, provider);
            }
            if (operator == InfixExpression.Operator.OR) {
                return InvertBooleanUtility.getInversedAndOrExpression(rewrite, infixExpression, InfixExpression.Operator.AND, provider);
            }
            if (operator == InfixExpression.Operator.XOR) {
                return InvertBooleanUtility.getInversedNotExpression(rewrite, expression, ast);
            }
        }
        if (expression instanceof PrefixExpression && (prefixExpression = (PrefixExpression)expression).getOperator() == PrefixExpression.Operator.NOT) {
            Expression renamedNameCopy;
            Expression operand = prefixExpression.getOperand();
            if (operand instanceof ParenthesizedExpression) {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)operand;
                if (NecessaryParenthesesChecker.canRemoveParentheses((Expression)operand, (ASTNode)expression.getParent(), (StructuralPropertyDescriptor)expression.getLocationInParent())) {
                    operand = parenthesizedExpression.getExpression();
                }
            }
            if ((renamedNameCopy = InvertBooleanUtility.getRenamedNameCopy(provider, rewrite, operand)) instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)renamedNameCopy;
                infixExpression.setOperator(((InfixExpression)operand).getOperator());
            }
            return renamedNameCopy;
        }
        if (expression instanceof InstanceofExpression) {
            return InvertBooleanUtility.getInversedNotExpression(rewrite, expression, ast);
        }
        if (expression instanceof ParenthesizedExpression) {
            ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)expression;
            Expression innerExpression = parenthesizedExpression.getExpression();
            while (innerExpression instanceof ParenthesizedExpression) {
                ParenthesizedExpression innerParenthesizedExpression = (ParenthesizedExpression)innerExpression;
                innerExpression = innerParenthesizedExpression.getExpression();
            }
            if (innerExpression instanceof InstanceofExpression) {
                return InvertBooleanUtility.getInversedExpression(rewrite, innerExpression, provider);
            }
            parenthesizedExpression = InvertBooleanUtility.getParenthesizedExpression(ast, InvertBooleanUtility.getInversedExpression(rewrite, innerExpression, provider));
            return parenthesizedExpression;
        }
        if (expression instanceof ConditionalExpression) {
            ConditionalExpression conditionalExpression = (ConditionalExpression)expression;
            ConditionalExpression newExpression = ast.newConditionalExpression();
            newExpression.setExpression((Expression)rewrite.createCopyTarget((ASTNode)conditionalExpression.getExpression()));
            newExpression.setThenExpression(InvertBooleanUtility.getInversedExpression(rewrite, conditionalExpression.getThenExpression()));
            newExpression.setElseExpression(InvertBooleanUtility.getInversedExpression(rewrite, conditionalExpression.getElseExpression()));
            return newExpression;
        }
        PrefixExpression prefixExpression2 = ast.newPrefixExpression();
        prefixExpression2.setOperator(PrefixExpression.Operator.NOT);
        Expression renamedNameCopy = InvertBooleanUtility.getRenamedNameCopy(provider, rewrite, expression);
        if (NecessaryParenthesesChecker.needsParentheses((Expression)renamedNameCopy, (ASTNode)prefixExpression2, (StructuralPropertyDescriptor)PrefixExpression.OPERAND_PROPERTY)) {
            renamedNameCopy = InvertBooleanUtility.getParenthesizedExpression(ast, renamedNameCopy);
        }
        prefixExpression2.setOperand(renamedNameCopy);
        return prefixExpression2;
    }

    public static boolean getSplitAndConditionProposals(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        InfixExpression parentInfixExpression;
        ASTNode aSTNode;
        InfixExpression.Operator andOperator = InfixExpression.Operator.CONDITIONAL_AND;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != andOperator) {
            return false;
        }
        int offset = InvertBooleanUtility.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while ((aSTNode = topInfixExpression.getParent()) instanceof InfixExpression && (parentInfixExpression = (InfixExpression)aSTNode).getOperator() == andOperator) {
            topInfixExpression = parentInfixExpression;
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        InvertBooleanUtility.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, andOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.EXPRESSION_PROPERTY, (Object)leftCondition, null);
        IfStatement innerIf = ast.newIfStatement();
        innerIf.setExpression(rightCondition);
        innerIf.setThenStatement((Statement)rewrite.createMoveTarget((ASTNode)ifStatement.getThenStatement()));
        Block innerBlock = ast.newBlock();
        innerBlock.statements().add(innerIf);
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement != null) {
            innerIf.setElseStatement((Statement)rewrite.createCopyTarget((ASTNode)elseStatement));
        }
        rewrite.replace((ASTNode)ifStatement.getThenStatement(), (ASTNode)innerBlock, null);
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitAndCondition_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 1);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        return true;
    }

    public static boolean getSplitOrConditionProposals(IInvocationContext context, ASTNode node, Collection<ProposalKindWrapper> resultingCollections) {
        InfixExpression.Operator orOperator = InfixExpression.Operator.CONDITIONAL_OR;
        if (!(node instanceof InfixExpression)) {
            return false;
        }
        InfixExpression infixExpression = (InfixExpression)node;
        if (infixExpression.getOperator() != orOperator) {
            return false;
        }
        int offset = InvertBooleanUtility.isOperatorSelected(infixExpression, context.getSelectionOffset(), context.getSelectionLength());
        if (offset == -1) {
            return false;
        }
        Statement statement = ASTResolving.findParentStatement((ASTNode)node);
        if (!(statement instanceof IfStatement)) {
            return false;
        }
        IfStatement ifStatement = (IfStatement)statement;
        InfixExpression topInfixExpression = infixExpression;
        while (topInfixExpression.getParent() instanceof InfixExpression && ((InfixExpression)topInfixExpression.getParent()).getOperator() == orOperator) {
            topInfixExpression = (InfixExpression)topInfixExpression.getParent();
        }
        if (ifStatement.getExpression() != topInfixExpression) {
            return false;
        }
        if (resultingCollections == null) {
            return true;
        }
        AST ast = ifStatement.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Expression[] newOperands = new Expression[2];
        InvertBooleanUtility.breakInfixOperationAtOperation(rewrite, (Expression)topInfixExpression, orOperator, offset, true, newOperands);
        Expression leftCondition = newOperands[0];
        Expression rightCondition = newOperands[1];
        rewrite.replace((ASTNode)ifStatement.getExpression(), (ASTNode)leftCondition, null);
        IfStatement secondIf = ast.newIfStatement();
        secondIf.setExpression(rightCondition);
        secondIf.setThenStatement((Statement)rewrite.createCopyTarget((ASTNode)ifStatement.getThenStatement()));
        Statement elseStatement = ifStatement.getElseStatement();
        if (elseStatement == null) {
            rewrite.set((ASTNode)ifStatement, (StructuralPropertyDescriptor)IfStatement.ELSE_STATEMENT_PROPERTY, (Object)secondIf, null);
        } else {
            rewrite.replace((ASTNode)elseStatement, (ASTNode)secondIf, null);
            secondIf.setElseStatement((Statement)rewrite.createMoveTarget((ASTNode)elseStatement));
        }
        String label = CorrectionMessages.AdvancedQuickAssistProcessor_splitOrCondition_description;
        ASTRewriteCorrectionProposalCore proposal = new ASTRewriteCorrectionProposalCore(label, context.getCompilationUnit(), rewrite, 1);
        resultingCollections.add(CodeActionHandler.wrap((ChangeCorrectionProposalCore)proposal, "quickfix"));
        return true;
    }

    private static boolean isSelectingOperator(ASTNode n1, ASTNode n2, int offset, int length) {
        if (offset + length <= n2.getStartPosition() && offset >= ASTNodes.getExclusiveEnd((ASTNode)n1)) {
            return true;
        }
        if (n1.getStartPosition() == offset && ASTNodes.getExclusiveEnd((ASTNode)n2) == offset + length) {
            return !(n1 instanceof InfixExpression) && !(n2 instanceof InfixExpression);
        }
        return false;
    }

    private static int isOperatorSelected(InfixExpression infixExpression, int offset, int length) {
        Expression right;
        Expression left = infixExpression.getLeftOperand();
        if (InvertBooleanUtility.isSelectingOperator((ASTNode)left, (ASTNode)(right = infixExpression.getRightOperand()), offset, length)) {
            return ASTNodes.getExclusiveEnd((ASTNode)left);
        }
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            left = right;
            if (InvertBooleanUtility.isSelectingOperator((ASTNode)left, (ASTNode)(right = (ASTNode)extended.get(i)), offset, length)) {
                return ASTNodes.getExclusiveEnd((ASTNode)left);
            }
            ++i;
        }
        return -1;
    }

    private static void breakInfixOperationAtOperation(ASTRewrite rewrite, Expression expression, InfixExpression.Operator operator, int operatorOffset, boolean removeParentheses, Expression[] res) {
        if (expression.getStartPosition() + expression.getLength() <= operatorOffset) {
            res[0] = InvertBooleanUtility.combineOperands(rewrite, res[0], expression, removeParentheses, operator);
            return;
        }
        if (operatorOffset <= expression.getStartPosition()) {
            res[1] = InvertBooleanUtility.combineOperands(rewrite, res[1], expression, removeParentheses, operator);
            return;
        }
        if (!(expression instanceof InfixExpression)) {
            throw new IllegalArgumentException("Cannot break up non-infix expression");
        }
        InfixExpression infixExpression = (InfixExpression)expression;
        if (infixExpression.getOperator() != operator) {
            throw new IllegalArgumentException("Incompatible operator");
        }
        InvertBooleanUtility.breakInfixOperationAtOperation(rewrite, infixExpression.getLeftOperand(), operator, operatorOffset, removeParentheses, res);
        InvertBooleanUtility.breakInfixOperationAtOperation(rewrite, infixExpression.getRightOperand(), operator, operatorOffset, removeParentheses, res);
        List extended = infixExpression.extendedOperands();
        int i = 0;
        while (i < extended.size()) {
            InvertBooleanUtility.breakInfixOperationAtOperation(rewrite, (Expression)extended.get(i), operator, operatorOffset, removeParentheses, res);
            ++i;
        }
    }

    private static Expression combineOperands(ASTRewrite rewrite, Expression existing, Expression originalNode, boolean removeParentheses, InfixExpression.Operator operator) {
        if (existing == null && removeParentheses) {
            while (originalNode instanceof ParenthesizedExpression) {
                ParenthesizedExpression parenthesizedExpression = (ParenthesizedExpression)originalNode;
                originalNode = parenthesizedExpression.getExpression();
            }
        }
        Expression newRight = (Expression)rewrite.createMoveTarget((ASTNode)originalNode);
        if (originalNode instanceof InfixExpression) {
            InfixExpression infixExpression = (InfixExpression)originalNode;
            ((InfixExpression)newRight).setOperator(infixExpression.getOperator());
        }
        if (existing == null) {
            return newRight;
        }
        AST ast = rewrite.getAST();
        InfixExpression infix = ast.newInfixExpression();
        infix.setOperator(operator);
        infix.setLeftOperand(existing);
        infix.setRightOperand(newRight);
        return infix;
    }

    private static interface SimpleNameRenameProvider {
        public SimpleName getRenamed(SimpleName var1);
    }
}

