/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gradle;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.microsoft.gradle.GradleServices;
import com.microsoft.gradle.semantictokens.TokenModifier;
import com.microsoft.gradle.semantictokens.TokenType;
import com.microsoft.gradle.transport.NamedPipeStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DocumentFilter;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;

public class GradleLanguageServer
implements LanguageServer,
LanguageClientAware {
    private GradleServices gradleServices = new GradleServices();

    public static void main(String[] args) {
        GradleLanguageServer server = new GradleLanguageServer();
        try {
            NamedPipeStream pipeStream = new NamedPipeStream(args[0]);
            Launcher launcher = Launcher.createLauncher((Object)server, LanguageClient.class, (InputStream)pipeStream.getInputStream(), (OutputStream)pipeStream.getOutputStream());
            server.connect((LanguageClient)launcher.getRemoteProxy());
            launcher.startListening();
        }
        catch (IOException e) {
            throw new RuntimeException("Gradle language server start failed", e);
        }
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        Iterator iterator;
        Map initOptions = (Map)new Gson().fromJson((JsonElement)params.getInitializationOptions(), Map.class);
        List workspaceFolders = params.getWorkspaceFolders();
        if (workspaceFolders != null && (iterator = workspaceFolders.iterator()).hasNext()) {
            WorkspaceFolder folder = (WorkspaceFolder)iterator.next();
            URI uri = URI.create(folder.getUri());
            this.gradleServices.getLibraryResolver().setWorkspacePath(Paths.get(uri));
        }
        Object settings = initOptions.get("settings");
        this.gradleServices.applySetting(settings);
        ServerCapabilities serverCapabilities = new ServerCapabilities();
        SemanticTokensWithRegistrationOptions semanticOptions = new SemanticTokensWithRegistrationOptions();
        semanticOptions.setFull(new SemanticTokensServerFull(Boolean.valueOf(false)));
        semanticOptions.setRange(Boolean.valueOf(false));
        semanticOptions.setDocumentSelector(Arrays.asList(new DocumentFilter("gradle", "file", null)));
        semanticOptions.setLegend(new SemanticTokensLegend(Arrays.stream(TokenType.values()).map(TokenType::toString).collect(Collectors.toList()), Arrays.stream(TokenModifier.values()).map(TokenModifier::toString).collect(Collectors.toList())));
        serverCapabilities.setSemanticTokensProvider(semanticOptions);
        serverCapabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setOpenClose(Boolean.TRUE);
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.TRUE));
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Incremental);
        serverCapabilities.setTextDocumentSync(textDocumentSyncOptions);
        CompletionOptions completionOptions = new CompletionOptions(Boolean.valueOf(false), Arrays.asList(".", ":"));
        serverCapabilities.setCompletionProvider(completionOptions);
        serverCapabilities.setExecuteCommandProvider(new ExecuteCommandOptions(GradleServices.supportedCommands));
        InitializeResult initializeResult = new InitializeResult(serverCapabilities);
        return CompletableFuture.completedFuture(initializeResult);
    }

    public CompletableFuture<Object> shutdown() {
        return CompletableFuture.completedFuture(new Object());
    }

    public void exit() {
        System.exit(0);
    }

    public TextDocumentService getTextDocumentService() {
        return this.gradleServices;
    }

    public WorkspaceService getWorkspaceService() {
        return this.gradleServices;
    }

    public void connect(LanguageClient client) {
        this.gradleServices.connect(client);
    }

    public void setTrace(SetTraceParams params) {
    }
}

