/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.format.CharWidthProvider;
import com.vladsch.flexmark.util.format.options.BlockQuoteMarker;
import com.vladsch.flexmark.util.format.options.CodeFenceMarker;
import com.vladsch.flexmark.util.format.options.DiscretionaryText;
import com.vladsch.flexmark.util.format.options.ElementAlignment;
import com.vladsch.flexmark.util.format.options.ElementPlacement;
import com.vladsch.flexmark.util.format.options.ElementPlacementSort;
import com.vladsch.flexmark.util.format.options.EqualizeTrailingMarker;
import com.vladsch.flexmark.util.format.options.HeadingStyle;
import com.vladsch.flexmark.util.format.options.ListBulletMarker;
import com.vladsch.flexmark.util.format.options.ListNumberedMarker;
import com.vladsch.flexmark.util.format.options.ListSpacing;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class FormatterOptions {
    public final boolean itemContentIndent;
    public final ParserEmulationProfile emulationProfile;
    public final boolean setextHeadingEqualizeMarker;
    public final int formatFlags;
    public final int maxBlankLines;
    public final int maxTrailingBlankLines;
    public final int rightMargin;
    public final int minSetextMarkerLength;
    public final DiscretionaryText spaceAfterAtxMarker;
    public final EqualizeTrailingMarker atxHeadingTrailingMarker;
    public final HeadingStyle headingStyle;
    public final boolean blockQuoteBlankLines;
    public final BlockQuoteMarker blockQuoteMarkers;
    public final String thematicBreak;
    public final String translationIdFormat;
    public final String translationHtmlBlockPrefix;
    public final String translationHtmlInlinePrefix;
    public final String translationExcludePattern;
    public final String translationHtmlBlockTagPattern;
    public final String translationHtmlInlineTagPattern;
    public final String translationAutolinkPrefix;
    public final boolean indentedCodeMinimizeIndent;
    public final boolean fencedCodeMinimizeIndent;
    public final boolean fencedCodeMatchClosingMarker;
    public final boolean fencedCodeSpaceBeforeInfo;
    public final int fencedCodeMarkerLength;
    public final CodeFenceMarker fencedCodeMarkerType;
    public final boolean listAddBlankLineBefore;
    public final boolean listRenumberItems;
    public final boolean listRemoveEmptyItems;
    public final boolean listsItemContentAfterSuffix;
    public final ListBulletMarker listBulletMarker;
    public final ListNumberedMarker listNumberedMarker;
    public final ListSpacing listSpacing;
    public final ElementPlacement referencePlacement;
    public final ElementPlacementSort referenceSort;
    public final boolean keepImageLinksAtStart;
    public final boolean keepExplicitLinksAtStart;
    public final boolean keepHardLineBreaks;
    public final boolean keepSoftLineBreaks;
    public final boolean appendTransferredReferences;
    public final boolean optimizedInlineRendering;
    public final boolean applySpecialLeadInHandlers;
    public final boolean escapeSpecialCharsOnWrap;
    public final boolean escapeNumberedLeadInOnWrap;
    public final boolean unescapeSpecialCharsOnWrap;
    public final CharWidthProvider charWidthProvider;
    public final ElementAlignment listAlignNumeric;
    public final boolean listResetFirstItemNumber;
    public final String formatterOnTag;
    public final String formatterOffTag;
    public final boolean formatterTagsEnabled;
    public final boolean formatterTagsAcceptRegexp;
    public final boolean blankLinesInAst;
    @Nullable
    public final Pattern linkMarkerCommentPattern;

    public FormatterOptions(DataHolder options) {
        this.emulationProfile = (ParserEmulationProfile)((Object)Formatter.FORMATTER_EMULATION_PROFILE.get(options));
        this.itemContentIndent = this.emulationProfile.family != ParserEmulationProfile.FIXED_INDENT;
        this.setextHeadingEqualizeMarker = (Boolean)Formatter.SETEXT_HEADING_EQUALIZE_MARKER.get(options);
        this.formatFlags = (Integer)Formatter.FORMAT_FLAGS.get(options);
        this.maxBlankLines = (Integer)Formatter.MAX_BLANK_LINES.get(options);
        this.maxTrailingBlankLines = (Integer)Formatter.MAX_TRAILING_BLANK_LINES.get(options);
        this.rightMargin = (Integer)Formatter.RIGHT_MARGIN.get(options);
        this.minSetextMarkerLength = (Integer)Parser.HEADING_SETEXT_MARKER_LENGTH.get(options);
        this.spaceAfterAtxMarker = (DiscretionaryText)Formatter.SPACE_AFTER_ATX_MARKER.get(options);
        this.atxHeadingTrailingMarker = (EqualizeTrailingMarker)Formatter.ATX_HEADING_TRAILING_MARKER.get(options);
        this.headingStyle = (HeadingStyle)Formatter.HEADING_STYLE.get(options);
        this.thematicBreak = (String)Formatter.THEMATIC_BREAK.get(options);
        this.translationIdFormat = (String)Formatter.TRANSLATION_ID_FORMAT.get(options);
        this.translationHtmlBlockPrefix = (String)Formatter.TRANSLATION_HTML_BLOCK_PREFIX.get(options);
        this.translationHtmlInlinePrefix = (String)Formatter.TRANSLATION_HTML_INLINE_PREFIX.get(options);
        this.translationAutolinkPrefix = (String)Formatter.TRANSLATION_AUTOLINK_PREFIX.get(options);
        this.translationExcludePattern = (String)Formatter.TRANSLATION_EXCLUDE_PATTERN.get(options);
        this.translationHtmlBlockTagPattern = (String)Formatter.TRANSLATION_HTML_BLOCK_TAG_PATTERN.get(options);
        this.translationHtmlInlineTagPattern = (String)Formatter.TRANSLATION_HTML_INLINE_TAG_PATTERN.get(options);
        this.blockQuoteBlankLines = (Boolean)Formatter.BLOCK_QUOTE_BLANK_LINES.get(options);
        this.blockQuoteMarkers = (BlockQuoteMarker)Formatter.BLOCK_QUOTE_MARKERS.get(options);
        this.indentedCodeMinimizeIndent = (Boolean)Formatter.INDENTED_CODE_MINIMIZE_INDENT.get(options);
        this.fencedCodeMinimizeIndent = (Boolean)Formatter.FENCED_CODE_MINIMIZE_INDENT.get(options);
        this.fencedCodeMatchClosingMarker = (Boolean)Formatter.FENCED_CODE_MATCH_CLOSING_MARKER.get(options);
        this.fencedCodeSpaceBeforeInfo = (Boolean)Formatter.FENCED_CODE_SPACE_BEFORE_INFO.get(options);
        this.fencedCodeMarkerLength = (Integer)Formatter.FENCED_CODE_MARKER_LENGTH.get(options);
        this.fencedCodeMarkerType = (CodeFenceMarker)Formatter.FENCED_CODE_MARKER_TYPE.get(options);
        this.listAddBlankLineBefore = (Boolean)Formatter.LIST_ADD_BLANK_LINE_BEFORE.get(options);
        this.listAlignNumeric = (ElementAlignment)Formatter.LIST_ALIGN_NUMERIC.get(options);
        this.listResetFirstItemNumber = (Boolean)Formatter.LIST_RESET_FIRST_ITEM_NUMBER.get(options);
        this.listRenumberItems = (Boolean)Formatter.LIST_RENUMBER_ITEMS.get(options);
        this.listRemoveEmptyItems = (Boolean)Formatter.LIST_REMOVE_EMPTY_ITEMS.get(options);
        this.listBulletMarker = (ListBulletMarker)Formatter.LIST_BULLET_MARKER.get(options);
        this.listNumberedMarker = (ListNumberedMarker)Formatter.LIST_NUMBERED_MARKER.get(options);
        this.listSpacing = (ListSpacing)Formatter.LIST_SPACING.get(options);
        this.listsItemContentAfterSuffix = (Boolean)Formatter.LISTS_ITEM_CONTENT_AFTER_SUFFIX.get(options);
        this.referencePlacement = (ElementPlacement)Formatter.REFERENCE_PLACEMENT.get(options);
        this.referenceSort = (ElementPlacementSort)Formatter.REFERENCE_SORT.get(options);
        this.keepImageLinksAtStart = (Boolean)Formatter.KEEP_IMAGE_LINKS_AT_START.get(options);
        this.keepExplicitLinksAtStart = (Boolean)Formatter.KEEP_EXPLICIT_LINKS_AT_START.get(options);
        this.charWidthProvider = (CharWidthProvider)Formatter.FORMAT_CHAR_WIDTH_PROVIDER.get(options);
        this.keepHardLineBreaks = (Boolean)Formatter.KEEP_HARD_LINE_BREAKS.get(options);
        this.keepSoftLineBreaks = (Boolean)Formatter.KEEP_SOFT_LINE_BREAKS.get(options);
        this.formatterOnTag = (String)Formatter.FORMATTER_ON_TAG.get(options);
        this.formatterOffTag = (String)Formatter.FORMATTER_OFF_TAG.get(options);
        this.formatterTagsEnabled = (Boolean)Formatter.FORMATTER_TAGS_ENABLED.get(options);
        this.formatterTagsAcceptRegexp = (Boolean)Formatter.FORMATTER_TAGS_ACCEPT_REGEXP.get(options);
        this.linkMarkerCommentPattern = (Pattern)Formatter.LINK_MARKER_COMMENT_PATTERN.get(options);
        this.appendTransferredReferences = (Boolean)Formatter.APPEND_TRANSFERRED_REFERENCES.get(options);
        this.optimizedInlineRendering = (Boolean)Formatter.OPTIMIZED_INLINE_RENDERING.get(options);
        this.applySpecialLeadInHandlers = (Boolean)Formatter.APPLY_SPECIAL_LEAD_IN_HANDLERS.get(options);
        this.escapeSpecialCharsOnWrap = (Boolean)Formatter.ESCAPE_SPECIAL_CHARS.get(options);
        this.escapeNumberedLeadInOnWrap = (Boolean)Formatter.ESCAPE_NUMBERED_LEAD_IN.get(options);
        this.unescapeSpecialCharsOnWrap = (Boolean)Formatter.UNESCAPE_SPECIAL_CHARS.get(options);
        this.blankLinesInAst = (Boolean)Parser.BLANK_LINES_IN_AST.get(options);
    }
}

