/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.collection.iteration;

import com.vladsch.flexmark.util.collection.iteration.Indexed;
import com.vladsch.flexmark.util.collection.iteration.IndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterable;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIndexedIterator;
import com.vladsch.flexmark.util.collection.iteration.ReversibleIterable;
import org.jetbrains.annotations.NotNull;

public class IndexedIterable<R, S, I extends ReversibleIterable<Integer>>
implements ReversibleIndexedIterable<R> {
    @NotNull
    private final ReversibleIterable<Integer> iterable;
    @NotNull
    private final Indexed<S> items;

    public IndexedIterable(@NotNull Indexed<S> items, @NotNull I iterable) {
        this.items = items;
        this.iterable = iterable;
    }

    @Override
    public boolean isReversed() {
        return this.iterable.isReversed();
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> iterator() {
        return new IndexedIterator(this.items, this.iterable.iterator());
    }

    @Override
    @NotNull
    public ReversibleIndexedIterable<R> reversed() {
        return new IndexedIterable<R, S, ReversibleIterable<Integer>>(this.items, this.iterable.reversed());
    }

    @Override
    @NotNull
    public ReversibleIndexedIterator<R> reversedIterator() {
        return new IndexedIterator(this.items, this.iterable.reversedIterator());
    }
}

