/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.decompiler;

import java.net.URI;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.ls.core.internal.DecompilerResult;
import org.eclipse.jdt.ls.core.internal.IDecompiler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.decompiler.DecompilerType;

public abstract class DecompilerImpl
implements IDecompiler {
    private static Map<DecompilerType, Map<String, DecompilerResult>> decompilerCache = Collections.synchronizedMap(new EnumMap(DecompilerType.class));
    private static final int CACHE_SIZE = 100;

    private static Map<String, DecompilerResult> getLRUCache(final int maxEntries) {
        LinkedHashMap<String, DecompilerResult> map = new LinkedHashMap<String, DecompilerResult>(maxEntries + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<String, DecompilerResult> eldest) {
                return this.size() > maxEntries;
            }
        };
        return Collections.synchronizedMap(map);
    }

    private static Map<String, DecompilerResult> getCache(DecompilerType type) {
        return decompilerCache.computeIfAbsent(type, key -> DecompilerImpl.getLRUCache(100));
    }

    @Override
    public String getContent(URI uri, IProgressMonitor monitor) throws CoreException {
        String cacheKey;
        Map<String, DecompilerResult> cache = DecompilerImpl.getCache(this.getDecompilerType());
        DecompilerResult result = cache.computeIfAbsent(cacheKey = uri.toString(), key -> {
            try {
                return this.decompileContent(uri, monitor);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to decompile with " + this.getDecompilerType().name(), e);
                return null;
            }
        });
        return result == null ? null : result.getContent();
    }

    @Override
    public String getSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        DecompilerResult result = this.getDecompiledSource(classFile, monitor);
        return result == null ? null : result.getContent();
    }

    @Override
    public DecompilerResult getDecompiledSource(IClassFile classFile, IProgressMonitor monitor) throws CoreException {
        Map<String, DecompilerResult> cache = DecompilerImpl.getCache(this.getDecompilerType());
        String cacheKey = classFile.getHandleIdentifier();
        return cache.computeIfAbsent(cacheKey, key -> {
            try {
                return this.decompileContent(classFile, monitor);
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Failed to decompile with " + this.getDecompilerType().name(), e);
                return null;
            }
        });
    }

    protected abstract DecompilerResult decompileContent(URI var1, IProgressMonitor var2) throws CoreException;

    protected abstract DecompilerResult decompileContent(IClassFile var1, IProgressMonitor var2) throws CoreException;

    protected abstract DecompilerType getDecompilerType();
}

