/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ConnectionListener
implements ISelectionListener {
    private static ConnectionListener instance;
    private IDockerConnection currentConnection;

    private ConnectionListener() {
    }

    public static ConnectionListener getInstance() {
        if (instance == null) {
            instance = new ConnectionListener();
        }
        return instance;
    }

    public void init() {
        IWorkbenchWindow window;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null) {
            window.getSelectionService().addSelectionListener("org.eclipse.linuxtools.docker.ui.dockerExplorerView", (ISelectionListener)this);
        }
    }

    public IDockerConnection getCurrentConnection() {
        return this.currentConnection;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return;
        }
        Object firstSegment = treeSelection.getPaths()[0].getFirstSegment();
        if (firstSegment instanceof IDockerConnection) {
            this.currentConnection = (IDockerConnection)firstSegment;
        }
    }
}

