/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.GateFigure;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;

public class AndGateFigure
extends GateFigure {
    public static final Dimension SIZE = new Dimension(30, 34);

    public AndGateFigure() {
        this.setBackgroundColor(LogicColorConstants.andGate);
        this.setForegroundColor(LogicColorConstants.outlineColor);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        r.translate(4, 5);
        r.setSize(22, 18);
        g.setAntialias(1);
        g.setLineWidth(2);
        g.drawLine(r.x + 4, r.y, r.x + 4, r.y - 6);
        g.drawLine(r.right() - 5, r.y, r.right() - 5, r.y - 5);
        ++r.width;
        ++r.height;
        g.fillRoundRectangle(r, 5, 5);
        Rectangle outlineRect = r.getCopy();
        --outlineRect.width;
        g.drawRoundRectangle(outlineRect, 5, 5);
        r.height = 18;
        r.y += 7;
        g.fillArc(r, 180, 180);
        --r.width;
        --r.height;
        g.drawArc(r, 180, 180);
        g.drawLine(r.x + r.width / 2, r.bottom(), r.x + r.width / 2, r.bottom() + 4);
    }
}

