/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.examples.logicdesigner.figures.FixedConnectionAnchor;
import org.eclipse.gef.examples.logicdesigner.figures.LogicColorConstants;
import org.eclipse.gef.examples.logicdesigner.figures.NodeFigure;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Font;

public class LEDFigure
extends NodeFigure
implements HandleBounds {
    public static final Dimension SIZE = new Dimension(92, 71);
    protected static final Font DISPLAY_FONT = new Font(null, "DialogInput", 24, 0);
    protected static PointList connector = new PointList();
    protected static PointList bottomConnector = new PointList();
    protected static Rectangle displayRectangle = new Rectangle(14, 17, 65, 38);
    protected static Rectangle displayShadow = new Rectangle(12, 15, 66, 39);
    protected static Rectangle displayHighlight = new Rectangle(14, 17, 66, 39);
    protected static Point valuePoint = new Point(24, 15);
    private static final int HORIZONTAL_PADDING = 3;
    private static final int VERTICAL_OFFSET = -1;
    private static final int CORNER_RADIUS = 6;
    protected static final int[] GAP_CENTERS_X;
    protected static final int Y1 = 3;
    protected static final int Y2 = 66;
    protected String value;

    static {
        connector.addPoint(-3, 0);
        connector.addPoint(2, 0);
        connector.addPoint(3, 2);
        connector.addPoint(3, 8);
        connector.addPoint(-1, 8);
        connector.addPoint(-1, 2);
        bottomConnector.addPoint(-3, 0);
        bottomConnector.addPoint(2, 0);
        bottomConnector.addPoint(3, -1);
        bottomConnector.addPoint(3, -7);
        bottomConnector.addPoint(-1, -7);
        bottomConnector.addPoint(-1, -1);
        GAP_CENTERS_X = new int[]{12, 35, 57, 80};
    }

    public LEDFigure() {
        FixedConnectionAnchor c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 77;
        this.connectionAnchors.put("A", c);
        this.inputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 54;
        this.connectionAnchors.put("B", c);
        this.inputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 32;
        this.connectionAnchors.put("C", c);
        this.inputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 9;
        this.connectionAnchors.put("D", c);
        this.inputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 77;
        c.topDown = false;
        this.connectionAnchors.put("1", c);
        this.outputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 54;
        c.topDown = false;
        this.connectionAnchors.put("2", c);
        this.outputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 32;
        c.topDown = false;
        this.connectionAnchors.put("3", c);
        this.outputConnectionAnchors.add(c);
        c = new FixedConnectionAnchor((IFigure)this);
        c.offsetH = 9;
        c.topDown = false;
        this.connectionAnchors.put("4", c);
        this.outputConnectionAnchors.add(c);
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getShrinked(new Insets(3, 0, 3, 0));
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return SIZE;
    }

    protected void paintFigure(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        g.translate(r.getLocation());
        g.setBackgroundColor(LogicColorConstants.logicGreen);
        Rectangle mainBody = new Rectangle(0, 2, r.width, r.height - 4);
        g.fillRoundRectangle(mainBody, 6, 6);
        LEDFigure.drawConnectors(g, r);
        g.setBackgroundColor(ColorConstants.black);
        g.fillRoundRectangle(displayRectangle, 6, 6);
        if (this.value != null) {
            this.drawModernText(g);
        }
    }

    private static void drawConnectors(Graphics g, Rectangle r) {
        int i = 0;
        while (i < 4) {
            g.setForegroundColor(ColorConstants.listBackground);
            g.setForegroundColor(LogicColorConstants.connectorGreen);
            g.setBackgroundColor(LogicColorConstants.connectorGreen);
            connector.translate(GAP_CENTERS_X[i], 0);
            g.fillPolygon(connector);
            connector.translate(-GAP_CENTERS_X[i], 0);
            bottomConnector.translate(GAP_CENTERS_X[i], r.height - 1);
            g.fillPolygon(bottomConnector);
            bottomConnector.translate(-GAP_CENTERS_X[i], -(r.height - 1));
            ++i;
        }
    }

    private void drawModernText(Graphics g) {
        Dimension textExtents = FigureUtilities.getTextExtents((String)this.value, (Font)DISPLAY_FONT);
        int x = LEDFigure.displayRectangle.x + 3 + (LEDFigure.displayRectangle.width - 6 - textExtents.width) / 2;
        int y = LEDFigure.displayRectangle.y + (LEDFigure.displayRectangle.height - textExtents.height) / 2 + -1;
        g.setFont(DISPLAY_FONT);
        g.setForegroundColor(LogicColorConstants.displayTextLED);
        g.drawText(this.value, new Point(x, y));
    }

    public void setValue(int val) {
        Object newValue = String.valueOf(val);
        if (val < 10) {
            newValue = "0" + (String)newValue;
        }
        if (((String)newValue).equals(this.value)) {
            return;
        }
        this.value = newValue;
        this.repaint();
    }

    public String toString() {
        return "LEDFigure";
    }
}

