/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.hovers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTParser;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.ConstantDeclaration;
import org.eclipse.php.core.ast.nodes.FieldAccess;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Include;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.ReflectionVariable;
import org.eclipse.php.core.ast.nodes.Scalar;
import org.eclipse.php.core.ast.nodes.SingleFieldDeclaration;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.corext.dom.NodeFinder;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.model.IVariableFacet;
import org.eclipse.php.internal.debug.core.model.VariablesUtil;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpEvalVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackFrame;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpStackVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.ui.hovers.PHPDebugTextHover;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.w3c.dom.Node;

public class XDebugTextHover
extends PHPDebugTextHover {
    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        DBGpVariable variable;
        block38: {
            ASTNode node;
            ISourceModule sourceModule;
            DBGpStackFrame frame;
            block37: {
                Program root;
                block36: {
                    ASTParser parser;
                    block35: {
                        frame = (DBGpStackFrame)this.getFrame();
                        if (frame == null) {
                            return null;
                        }
                        variable = null;
                        sourceModule = this.getEditorInputModelElement();
                        if (sourceModule != null) break block35;
                        return null;
                    }
                    root = SharedASTProvider.getAST((ISourceModule)sourceModule, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_NO, null);
                    if (root != null || (root = (parser = ASTParser.newParser((ISourceModule)sourceModule)).createAST(null)) != null) break block36;
                    return null;
                }
                node = NodeFinder.perform((ASTNode)root, (int)hoverRegion.getOffset(), (int)hoverRegion.getLength());
                if (node != null) break block37;
                return null;
            }
            try {
                if (node instanceof Scalar) {
                    Scalar scalar = (Scalar)node;
                    if (node.getParent() instanceof ArrayAccess) {
                        ArrayAccess access = (ArrayAccess)node.getParent();
                        DBGpVariable var = this.getVariable(this.computeExpression(access.getName()));
                        Object arrayAccessKey = scalar.getStringValue();
                        if (scalar.getScalarType() == 2) {
                            arrayAccessKey = ((String)arrayAccessKey).replace("\"", "");
                        }
                        arrayAccessKey = "[" + (String)arrayAccessKey + "]";
                        if (var != null) {
                            variable = this.fetchMember(var, (String)arrayAccessKey);
                        }
                    } else if (!(scalar.getParent() instanceof Include || scalar.getScalarType() != 2 || scalar.getStringValue().startsWith("\"") && scalar.getStringValue().endsWith("\"") || (variable = this.getVariable(scalar.getStringValue())) == null)) {
                        variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_CONSTANT});
                        variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.MOD_PUBLIC});
                    }
                    break block38;
                }
                if (node.getParent() instanceof Variable && node.getParent().getParent() instanceof FieldAccess && node instanceof Identifier) {
                    String nodeName = ((Identifier)node).getName();
                    String expression = this.computeExpression(((FieldAccess)node.getParent().getParent()).getDispatcher());
                    DBGpVariable var = this.getVariable(expression);
                    if (var != null) {
                        variable = this.fetchMember(var, nodeName);
                    }
                    break block38;
                }
                if (node.getParent() instanceof StaticConstantAccess) {
                    String name;
                    String nodeName = ((Identifier)node).getName();
                    StaticConstantAccess staticAccess = (StaticConstantAccess)node.getParent();
                    String className = this.resolveTypeName((Identifier)staticAccess.getClassName());
                    if (className != null && (variable = this.getVariable(name = className + "::" + nodeName)) != null) {
                        if (nodeName.equals("class")) {
                            variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.VIRTUAL_CLASS});
                        } else {
                            variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_CONSTANT});
                            variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.MOD_PUBLIC});
                        }
                    }
                    break block38;
                }
                if (node.getParent() instanceof StaticFieldAccess && node instanceof Variable && ((Variable)node).getName() instanceof Identifier) {
                    Variable var = (Variable)node;
                    String nodeName = ((Identifier)var.getName()).getName();
                    StaticFieldAccess staticAccess = (StaticFieldAccess)node.getParent();
                    Identifier identifier = null;
                    if (staticAccess.getClassName() instanceof Identifier) {
                        identifier = (Identifier)staticAccess.getClassName();
                    } else if (staticAccess.getClassName() instanceof VariableBase) {
                        identifier = (Identifier)var.getName();
                    }
                    String className = this.resolveTypeName(identifier);
                    String name = className + "::$" + nodeName;
                    variable = this.getVariable(name);
                    break block38;
                }
                if (node.getParent() instanceof ConstantDeclaration) {
                    String nodeName = ((Identifier)node).getName();
                    IField field = (IField)sourceModule.getElementAt(node.getStart());
                    if (field.getParent() instanceof IType) {
                        IType type = (IType)field.getParent();
                        String typeName = type.getFullyQualifiedName("\\");
                        variable = !PHPFlags.isNamespace((int)type.getFlags()) ? this.getVariable(typeName + "::" + nodeName) : this.getVariable(typeName + "\\" + nodeName);
                        if (variable != null) {
                            variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_CONSTANT});
                            variable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.MOD_PUBLIC});
                        }
                    }
                    break block38;
                }
                if (node.getParent() instanceof SingleFieldDeclaration) {
                    IField field = (IField)sourceModule.getElementAt(node.getStart());
                    String typeName = "";
                    boolean isAnonymous = false;
                    if (field.getParent() instanceof IType) {
                        IType type = (IType)field.getParent();
                        typeName = type.getFullyQualifiedName("\\");
                        isAnonymous = PHPFlags.isAnonymous((int)type.getFlags());
                    }
                    Variable var = (Variable)node;
                    String nodeName = ((Identifier)var.getName()).getName();
                    if (!PHPFlags.isStatic((int)field.getFlags())) {
                        DBGpVariable varThis = this.getVariable("$this");
                        if (varThis != null && (isAnonymous || typeName.equals(varThis.getValue().getValueString()))) {
                            variable = this.fetchMember(varThis, nodeName);
                        }
                    } else {
                        variable = this.getVariable(typeName + "::$" + nodeName);
                    }
                    break block38;
                }
                Object variableName = null;
                if (node instanceof Identifier && node.getParent() instanceof Variable && !((Variable)node.getParent()).isDollared()) {
                    variableName = "$" + ((Identifier)node).getName();
                } else {
                    IDocument document = textViewer.getDocument();
                    if (document != null) {
                        variableName = node instanceof ReflectionVariable ? document.get(((ReflectionVariable)node).getName().getStart(), ((ReflectionVariable)node).getName().getLength()) : document.get(hoverRegion.getOffset(), hoverRegion.getLength());
                    }
                }
                IVariable[] iVariableArray = frame.getVariables();
                int n = iVariableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IVariable stackVariable = iVariableArray[n2];
                    if (stackVariable.getName().equals(variableName)) {
                        variable = (DBGpVariable)stackVariable;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                PHPDebugPlugin.log((Throwable)e);
            }
        }
        return variable;
    }

    @Override
    protected IStackFrame getFrame() {
        IAdaptable adaptable = DebugUITools.getDebugContext();
        if (adaptable != null) {
            return (IStackFrame)adaptable.getAdapter(DBGpStackFrame.class);
        }
        return null;
    }

    @Nullable
    protected DBGpVariable getVariable(String expression) {
        DBGpStackFrame frame = (DBGpStackFrame)this.getFrame();
        if (frame == null) {
            return null;
        }
        DBGpVariable variable = null;
        variable = this.isStack(expression) ? this.getByProperty(frame, expression) : this.getByEval(frame, expression);
        return variable;
    }

    private void setContextFacets(IVariable variable) {
        if (variable instanceof DBGpVariable) {
            DBGpVariable dbgpVariable = (DBGpVariable)variable;
            try {
                String endName = dbgpVariable.getName();
                if (VariablesUtil.isThis((String)endName)) {
                    dbgpVariable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_THIS});
                } else if (VariablesUtil.isSuperGlobal((String)endName)) {
                    dbgpVariable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_SUPER_GLOBAL});
                } else if (VariablesUtil.isClassIndicator((String)endName)) {
                    dbgpVariable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.VIRTUAL_CLASS});
                } else {
                    dbgpVariable.addFacets(new IVariableFacet.Facet[]{IVariableFacet.Facet.KIND_LOCAL});
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    protected DBGpVariable getByEval(DBGpStackFrame context, String expression) {
        DBGpTarget debugTarget = (DBGpTarget)context.getDebugTarget();
        Node resp = debugTarget.eval(expression);
        if (resp == null) {
            return null;
        }
        return new DBGpEvalVariable((IDebugTarget)debugTarget, expression, resp, new IVariableFacet.Facet[0]);
    }

    protected DBGpVariable getByProperty(DBGpStackFrame context, String variable) {
        String stackLevel;
        DBGpTarget debugTarget = (DBGpTarget)context.getDebugTarget();
        Node resp = debugTarget.getProperty(variable, stackLevel = context.getStackLevel(), 0);
        if (resp == null || "error".equals(resp.getNodeName())) {
            stackLevel = "-1";
            resp = debugTarget.getProperty(variable, stackLevel, 0);
        }
        if (resp == null) {
            return null;
        }
        DBGpStackVariable var = new DBGpStackVariable((IDebugTarget)debugTarget, resp, Integer.valueOf(stackLevel).intValue(), new IVariableFacet.Facet[0]);
        this.setContextFacets((IVariable)var);
        return var;
    }

    private boolean isStack(String expression) {
        ISourceRange enclosingIdentifier;
        return expression.startsWith("$") && (enclosingIdentifier = PHPTextSequenceUtilities.getEnclosingIdentifier((CharSequence)expression, (int)0)) != null && enclosingIdentifier.getLength() == expression.length() + 1;
    }

    private DBGpVariable fetchMember(DBGpVariable variable, String memberName) {
        block5: {
            if (variable.getValue() != null && variable.getValue().getVariables() != null) break block5;
            return null;
        }
        try {
            IVariable[] iVariableArray = variable.getValue().getVariables();
            int n = iVariableArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVariable child = iVariableArray[n2];
                if (child.getName().equals(memberName) && child instanceof DBGpVariable) {
                    return (DBGpVariable)child;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }
}

