/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.rename.RenameClassProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameProcessorTestCase0029408
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        TestUtils.setProjectPHPVersion((IProject)this.project1, (PHPVersion)PHPVersion.PHP5_3);
        IFolder folder = TestUtils.createFolder((IProject)this.project1, (String)"src");
        this.file = TestUtils.createFile((IFolder)folder, (String)"test00294081.php", (String)"<?php class MyClass{const constant = 'constant value';function showCons1tant() {echo self::constant;}}$class = new MyClass ();$class->showConstant ();echo $class::constant;?>");
        TestUtils.waitForIndexer();
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRename() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        int start = 117;
        ASTNode selectedNode = this.locateNode(program, start, 0);
        Assert.assertNotNull((Object)selectedNode);
        RenameClassProcessor processor = new RenameClassProcessor(this.file, selectedNode);
        processor.setNewElementName("MyClassNewName");
        processor.setUpdateTextualMatches(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        try {
            String content = FileUtils.getContents(this.file);
            Assert.assertEquals((Object)"<?php class MyClassNewName{const constant = 'constant value';function showCons1tant() {echo self::constant;}}$class = new MyClassNewName ();$class->showConstant ();echo $class::constant;?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

