/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final String INTERNAL_ENCODING = "ASCII";
    private static String base64CharSetSequence = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
    private static byte[] valToBase64CharTable;
    private static int[] base64ToValTable;

    static {
        try {
            valToBase64CharTable = base64CharSetSequence.getBytes(INTERNAL_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        base64ToValTable = new int[256];
        int i = 0;
        while (i < 256) {
            Base64.base64ToValTable[i] = -1;
            ++i;
        }
        i = 0;
        while (i < valToBase64CharTable.length) {
            Base64.base64ToValTable[Base64.valToBase64CharTable[i] & 0xFF] = i;
            ++i;
        }
    }

    private Base64() {
    }

    private static int[] three2four(byte a, byte b, byte c) {
        int[] result = new int[]{a >>> 2 & 0x3F & 0xFF, (a & 3) << 4 | (b & 0xF0) >>> 4 & 0xFF, (b & 0xF) << 2 | (c & 0xC0) >>> 6 & 0xFF, c & 0x3F};
        return result;
    }

    public static String encode(byte[] input) {
        byte[] result = Base64.encodeToBytes(input);
        String strResult = null;
        try {
            strResult = new String(result, INTERNAL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            strResult = new String(result);
        }
        return strResult;
    }

    public static byte[] decode(String input) {
        byte[] byteInput = null;
        try {
            byteInput = input.getBytes(INTERNAL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            byteInput = input.getBytes();
        }
        byte[] result = Base64.decode(byteInput);
        return result;
    }

    private static byte[] encodeToBytes(byte[] input) {
        int outsize = input.length / 3 * 4;
        if (input.length % 3 != 0) {
            outsize += 4;
        }
        byte[] encoded = new byte[outsize];
        byte zero = 0;
        byte[] data = new byte[4];
        int pos = 0;
        int i = 0;
        while (i < input.length) {
            switch (input.length - i) {
                case 1: {
                    int[] result = Base64.three2four(input[i], zero, zero);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[64];
                    data[3] = valToBase64CharTable[64];
                    break;
                }
                case 2: {
                    int[] result = Base64.three2four(input[i], input[i + 1], zero);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[result[2]];
                    data[3] = valToBase64CharTable[64];
                    break;
                }
                default: {
                    int[] result = Base64.three2four(input[i], input[i + 1], input[i + 2]);
                    data[0] = valToBase64CharTable[result[0]];
                    data[1] = valToBase64CharTable[result[1]];
                    data[2] = valToBase64CharTable[result[2]];
                    data[3] = valToBase64CharTable[result[3]];
                }
            }
            int j = 0;
            while (j < 4) {
                encoded[pos] = data[j];
                ++pos;
                ++j;
            }
            i += 3;
        }
        return encoded;
    }

    private static byte[] decode(byte[] input) {
        int outsize = input.length / 4 * 3;
        if (input.length % 4 != 0) {
            outsize += input.length % 4 - 1;
        }
        if (outsize == 0) {
            return new byte[0];
        }
        byte[] decoded = new byte[outsize];
        int[] base64set = new int[4];
        int outputPos = 0;
        int decodepos = 0;
        int i = 0;
        while (i < input.length) {
            int byteVal = input[i] & 0xFF;
            if (base64ToValTable[byteVal] != -1) {
                base64set[decodepos] = base64ToValTable[byteVal];
                if (++decodepos == 4) {
                    decodepos = 0;
                    decoded[outputPos] = (byte)(base64set[0] << 2 | (base64set[1] & 0x30) >>> 4);
                    ++outputPos;
                    if (base64set[2] != 64) {
                        decoded[outputPos] = (byte)((base64set[1] & 0xF) << 4 | (base64set[2] & 0x3C) >>> 2);
                        ++outputPos;
                        if (base64set[3] != 64) {
                            decoded[outputPos] = (byte)((base64set[2] & 3) << 6 | base64set[3]);
                            ++outputPos;
                        }
                    }
                }
            }
            ++i;
        }
        if (decodepos > 1) {
            decoded[outputPos] = (byte)(base64set[0] << 2 | (base64set[1] & 0x30) >>> 4);
            ++outputPos;
            if (decodepos > 2 && base64set[2] != 64) {
                decoded[outputPos] = (byte)((base64set[1] & 0xF) << 4 | (base64set[2] & 0x3C) >>> 2);
                ++outputPos;
            }
        }
        byte[] finalDecoded = decoded;
        if (outsize > outputPos) {
            if (outputPos > 0) {
                finalDecoded = new byte[outputPos];
                System.arraycopy(decoded, 0, finalDecoded, 0, outputPos);
            } else {
                return new byte[0];
            }
        }
        return finalDecoded;
    }
}

