/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.refactoring.core.move.PHPProjectMoveProcessor;
import org.eclipse.php.refactoring.ui.PHPRefactoringUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.dialogs.ProjectContentsLocationArea;

public class RefactoringProjectMoveWizardPage
extends UserInputWizardPage {
    private IProject project;
    private static String PROJECT_LOCATION_SELECTION_TITLE = IDEWorkbenchMessages.ProjectLocationSelectionDialog_selectionTitle;
    private ProjectContentsLocationArea locationArea;
    private Button fReferenceCheckbox;

    public RefactoringProjectMoveWizardPage(IProject existingProject) {
        super(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.0"));
        this.project = existingProject;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        result.setLayout((Layout)new GridLayout());
        this.locationArea = new ProjectContentsLocationArea(this.getErrorReporter(), result, this.project);
        this.setButtonLayoutData(this.locationArea.getBrowseButton());
        this.setPageComplete(false);
        this.addUpdateReferenceComponent(result);
        Dialog.applyDialogFont((Control)result);
    }

    private ProjectContentsLocationArea.IErrorMessageReporter getErrorReporter() {
        return new ProjectContentsLocationArea.IErrorMessageReporter(){

            public void reportError(String errorMessage, boolean notError) {
                if (errorMessage != null) {
                    if (notError) {
                        RefactoringProjectMoveWizardPage.this.setMessage(errorMessage, 2);
                    } else {
                        RefactoringProjectMoveWizardPage.this.setMessage(errorMessage, 3);
                    }
                    RefactoringProjectMoveWizardPage.this.setPageComplete(false);
                } else {
                    RefactoringProjectMoveWizardPage.this.verifyDestination(new Path(RefactoringProjectMoveWizardPage.this.locationArea.getProjectLocation()).append(RefactoringProjectMoveWizardPage.this.project.getName()).toString(), false);
                }
            }
        };
    }

    private final void verifyDestination(String selected, boolean initialVerification) {
        try {
            RefactoringStatus status = this.verifyDestination(selected);
            if (initialVerification) {
                this.setPageComplete(status.isOK());
            } else {
                this.setPageComplete(status);
            }
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
            this.setPageComplete(false);
        }
    }

    protected RefactoringStatus verifyDestination(String selected) throws Exception {
        PHPProjectMoveProcessor processor = this.getPHPMoveProcessor();
        RefactoringStatus refactoringStatus = processor.setDestination(selected);
        return refactoringStatus;
    }

    private PHPProjectMoveProcessor getPHPMoveProcessor() {
        return (PHPProjectMoveProcessor)this.getRefactoring().getAdapter(PHPProjectMoveProcessor.class);
    }

    private void addUpdateReferenceComponent(Composite result) {
        final PHPProjectMoveProcessor processor = this.getPHPMoveProcessor();
        this.fReferenceCheckbox = new Button(result, 32);
        this.fReferenceCheckbox.setText(PHPRefactoringUIMessages.getString("RefactoringMoveWizardPage.3"));
        this.fReferenceCheckbox.setSelection(processor.getUpdateReferences());
        this.fReferenceCheckbox.setEnabled(true);
        this.fReferenceCheckbox.setSelection(true);
        processor.setUpdateReferences(true);
        this.fReferenceCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                processor.setUpdateReferences(((Button)e.widget).getSelection());
                RefactoringProjectMoveWizardPage.this.getRefactoringWizard().setForcePreviewReview(processor.getUpdateReferences());
            }
        });
    }
}

