/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.util.GenericXMLWriter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuildpathPackage {
    private static final String CURRENT_VERSION = "1";
    private static final String TAG_VERSION = "version";
    private static final String TAG_USERLIBRARY = "composerPackage";
    private static final String TAG_PATH = "path";
    private static final String TAG_ARCHIVE = "archive";
    private static final String TAG_SYSTEMLIBRARY = "systemlibrary";

    public BuildpathPackage(IBuildpathEntry[] entries, boolean isSystem) {
    }

    public static String serialize(IBuildpathEntry[] entries, boolean isSystemLibrary) throws IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, StandardCharsets.UTF_8);
        XMLWriter xmlWriter = new XMLWriter(writer, null, true);
        HashMap<String, String> library = new HashMap<String, String>();
        library.put(TAG_VERSION, String.valueOf(CURRENT_VERSION));
        library.put(TAG_SYSTEMLIBRARY, String.valueOf(isSystemLibrary));
        xmlWriter.printTag(TAG_USERLIBRARY, library, true, true, false);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            BuildpathEntry cpEntry = (BuildpathEntry)entries[i];
            HashMap<String, String> archive = new HashMap<String, String>();
            archive.put(TAG_PATH, cpEntry.getPath().toString());
            boolean hasExtraAttributes = false;
            boolean hasRestrictions = cpEntry.getAccessRuleSet() != null;
            xmlWriter.printTag(TAG_ARCHIVE, archive, true, true, !hasExtraAttributes && !hasRestrictions);
            if (hasExtraAttributes || hasRestrictions) {
                xmlWriter.endTag(TAG_ARCHIVE, true, true);
            }
            ++i;
        }
        xmlWriter.endTag(TAG_USERLIBRARY, true, true);
        writer.flush();
        writer.close();
        xmlWriter.close();
        return s.toString(StandardCharsets.UTF_8.name());
    }

    public static BuildpathPackage createFromString(Reader reader) throws IOException {
        Element cpElement;
        try {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
            }
            catch (SAXException sAXException) {
                throw new IOException(Messages.file_badFormat);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IOException(Messages.file_badFormat);
            }
        }
        finally {
            reader.close();
        }
        if (!cpElement.getNodeName().equalsIgnoreCase(TAG_USERLIBRARY)) {
            throw new IOException(Messages.file_badFormat);
        }
        boolean isSystem = Boolean.valueOf(cpElement.getAttribute(TAG_SYSTEMLIBRARY));
        NodeList list = cpElement.getChildNodes();
        int length = list.getLength();
        ArrayList<IBuildpathEntry> res = new ArrayList<IBuildpathEntry>(length);
        int i = 0;
        while (i < length) {
            Element element;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && (element = (Element)node).getNodeName().equals(TAG_ARCHIVE)) {
                String path = element.getAttribute(TAG_PATH);
                IBuildpathEntry entry = DLTKCore.newLibraryEntry((IPath)Path.fromPortableString((String)path), (IAccessRule[])new IAccessRule[0], (IBuildpathAttribute[])new IBuildpathAttribute[0], (boolean)false, (boolean)true);
                res.add(entry);
            }
            ++i;
        }
        IBuildpathEntry[] entries = res.toArray(new IBuildpathEntry[res.size()]);
        return new BuildpathPackage(entries, isSystem);
    }

    private static class XMLWriter
    extends GenericXMLWriter {
        public XMLWriter(Writer writer, IScriptProject project, boolean printXmlVersion) {
            super(writer, Util.getLineSeparator(null, (IScriptProject)project), printXmlVersion);
        }
    }
}

