/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer;

import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryIntegerParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class SignedParser
implements ICommonTreeParser {
    public static final SignedParser INSTANCE = new SignedParser();
    private static final String INVALID_BOOLEAN_VALUE = "Invalid boolean value ";

    private SignedParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean parse(ICTFMetadataNode tree, ICommonTreeParser.ICommonTreeParserParameter unused) throws ParseException {
        boolean ret = false;
        ICTFMetadataNode firstChild = tree.getChild(0);
        if (TsdlUtils.isUnaryString(firstChild)) {
            String strval = TsdlUtils.concatenateUnaryStrings(tree.getChildren());
            if (strval.equals("true") || strval.equals("TRUE")) {
                ret = true;
                return ret;
            } else {
                if (!strval.equals("false") && !strval.equals("FALSE")) throw new ParseException(INVALID_BOOLEAN_VALUE + firstChild.getChild(0).getText());
                ret = false;
            }
            return ret;
        } else {
            if (!TsdlUtils.isUnaryInteger(firstChild)) throw new ParseException(INVALID_BOOLEAN_VALUE);
            if (tree.getChildCount() > 1) {
                throw new ParseException(INVALID_BOOLEAN_VALUE);
            }
            long intval = UnaryIntegerParser.INSTANCE.parse(firstChild, null);
            if (intval == 1L) {
                ret = true;
                return ret;
            } else {
                if (intval != 0L) throw new ParseException(INVALID_BOOLEAN_VALUE + firstChild.getChild(0).getText());
                ret = false;
            }
        }
        return ret;
    }
}

