/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.wizards.datatransfer.IFileExporter;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarOutputStream;

public class TarFileExporter
implements IFileExporter {
    private final TarOutputStream outputStream;
    private final boolean resolveLinks;

    public TarFileExporter(String filename, boolean compress, boolean resolveLinks) throws IOException {
        this.resolveLinks = resolveLinks;
        TarOutputStream tos = compress ? new TarOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(filename)))) : new TarOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.outputStream = tos;
    }

    @Override
    public void finished() throws IOException {
        this.outputStream.close();
    }

    private void write(TarEntry entry, IFile contents) throws IOException, CoreException {
        URI location = contents.getLocationURI();
        if (location == null) {
            throw new FileNotFoundException(contents.getFullPath().toOSString());
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream contentStream = contents.getContents(false);){
            int n;
            entry.setSize(EFS.getStore((URI)location).fetchInfo().getLength());
            this.outputStream.putNextEntry(entry);
            byte[] readBuffer = new byte[4096];
            while ((n = contentStream.read(readBuffer)) > 0) {
                this.outputStream.write(readBuffer, 0, n);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.outputStream.closeEntry();
    }

    @Override
    public void write(IContainer container, String destinationPath) throws IOException {
        ResourceAttributes attributes;
        if (!this.resolveLinks && container.isLinked(2)) {
            return;
        }
        TarEntry newEntry = new TarEntry(destinationPath);
        if (container.getLocalTimeStamp() != -1L) {
            newEntry.setTime(container.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = container.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        newEntry.setFileType(53);
        this.outputStream.putNextEntry(newEntry);
    }

    @Override
    public void write(IFile resource, String destinationPath) throws IOException, CoreException {
        ResourceAttributes attributes;
        if (!this.resolveLinks && resource.isLinked(2)) {
            return;
        }
        TarEntry newEntry = new TarEntry(destinationPath);
        if (resource.getLocalTimeStamp() != -1L) {
            newEntry.setTime(resource.getLocalTimeStamp() / 1000L);
        }
        if ((attributes = resource.getResourceAttributes()) != null && attributes.isExecutable()) {
            newEntry.setMode(newEntry.getMode() | 0x49L);
        }
        if (attributes != null && attributes.isReadOnly()) {
            newEntry.setMode(newEntry.getMode() & 0xFFFFFFFFFFFFFF6DL);
        }
        this.write(newEntry, resource);
    }
}

