/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaViewerFilter;

public class WorkingSetFilter
extends JavaViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private WorkingSetCompareEntry[] fCachedCompareEntries = null;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        if (this.fWorkingSet != workingSet) {
            this.fWorkingSet = workingSet;
            this.notifyWorkingSetContentChange();
        }
    }

    @Override
    protected void initFilter() {
        this.notifyWorkingSetContentChange();
    }

    public final void notifyWorkingSetContentChange() {
        if (this.fWorkingSet != null) {
            IAdaptable[] elements = this.fWorkingSet.getElements();
            this.fCachedCompareEntries = new WorkingSetCompareEntry[elements.length];
            int i = 0;
            while (i < elements.length) {
                this.fCachedCompareEntries[i] = new WorkingSetCompareEntry(elements[i]);
                ++i;
            }
        } else {
            this.fCachedCompareEntries = null;
        }
    }

    @Override
    protected void freeFilter() {
        this.fCachedCompareEntries = null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.isEmpty()) {
            return true;
        }
        if (element instanceof PackageFragmentRootContainer) {
            return this.isEnclosing((PackageFragmentRootContainer)element);
        }
        if (element instanceof IAdaptable) {
            return this.isEnclosing((IAdaptable)element);
        }
        return true;
    }

    public boolean isEnclosing(IAdaptable a) {
        WorkingSetCompareEntry curr = new WorkingSetCompareEntry(a);
        if (this.fCachedCompareEntries != null) {
            int i = 0;
            while (i < this.fCachedCompareEntries.length) {
                if (this.fCachedCompareEntries[i].contains(curr)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.fWorkingSet != null) {
            IAdaptable[] elements = this.fWorkingSet.getElements();
            int i = 0;
            while (i < elements.length) {
                if (new WorkingSetCompareEntry(elements[i]).contains(curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isEnclosing(PackageFragmentRootContainer container) {
        IAdaptable[] roots = container.getChildren();
        int i = 0;
        while (i < roots.length) {
            if (this.isEnclosing(roots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class WorkingSetCompareEntry {
        private IPath fResourcePath;
        private IJavaScriptElement fJavaElement;

        public WorkingSetCompareEntry(IAdaptable a) {
            if (a instanceof IJavaScriptElement) {
                this.init((IJavaScriptElement)a);
            } else if (a instanceof IResource) {
                this.init((IResource)a);
            } else if (a instanceof JsGlobalScopeContainer.RequiredProjectWrapper) {
                JsGlobalScopeContainer.RequiredProjectWrapper wrapper = (JsGlobalScopeContainer.RequiredProjectWrapper)a;
                IJavaScriptProject proj = wrapper.getParentJsGlobalScopeContainer().getJavaProject();
                IFile fakeInternal = proj.getProject().getFile(String.valueOf(wrapper.getProject().getElementName()) + "-fake-jar.jar");
                this.init((IJavaScriptElement)proj.getPackageFragmentRoot((IResource)fakeInternal));
            } else {
                IJavaScriptElement je = (IJavaScriptElement)a.getAdapter(IJavaScriptElement.class);
                if (je != null) {
                    this.init(je);
                } else {
                    IResource resource = (IResource)a.getAdapter(IResource.class);
                    if (resource != null) {
                        this.init(resource);
                    } else {
                        this.fResourcePath = null;
                        this.fJavaElement = null;
                    }
                }
            }
        }

        private void init(IResource resource) {
            this.fJavaElement = JavaScriptCore.create((IResource)resource);
            this.fResourcePath = resource.getFullPath();
        }

        private void init(IJavaScriptElement curr) {
            this.fJavaElement = curr;
            this.fResourcePath = curr.getPath();
        }

        public boolean contains(WorkingSetCompareEntry element) {
            IPath other;
            if (this.fJavaElement != null && element.fJavaElement != null) {
                IPackageFragmentRoot pkgRoot;
                IJavaScriptElement other2 = element.fJavaElement;
                if (this.fJavaElement.getElementType() == 2 && (pkgRoot = (IPackageFragmentRoot)other2.getAncestor(3)) != null && pkgRoot.isExternal() && pkgRoot.isArchive() && ((IJavaScriptProject)this.fJavaElement).isOnIncludepath(other2)) {
                    return true;
                }
                return this.isAncestor(other2, this.fJavaElement) || this.isAncestor(this.fJavaElement, other2);
            }
            return this.fResourcePath != null && element.fResourcePath != null && ((other = element.fResourcePath).isPrefixOf(this.fResourcePath) || this.fResourcePath.isPrefixOf(other));
        }

        /*
         * Unable to fully structure code
         */
        private boolean isAncestor(IJavaScriptElement elem, IJavaScriptElement parent) {
            anc = elem.getAncestor(parent.getElementType());
            if (!parent.equals(anc)) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                if (!parent.equals(anc = anc.getParent().getAncestor(parent.getElementType()))) continue;
                return true;
lbl6:
                // 2 sources

                ** while (anc instanceof IMember)
            }
lbl7:
            // 1 sources

            return false;
        }
    }
}

