/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.io.CharConversionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringActions;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class UseSupertypeAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public UseSupertypeAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public UseSupertypeAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.UseSupertypeAction_use_Supertype);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.use_supertype_action");
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection));
        }
        catch (JavaScriptModelException e) {
            if (!(e.getException() instanceof CharConversionException) && JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaScriptPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    @Override
    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection)) {
                IType singleSelectedType = UseSupertypeAction.getSingleSelectedType(selection);
                if (!ActionUtil.isEditable(this.getShell(), (IJavaScriptElement)singleSelectedType)) {
                    return;
                }
                RefactoringExecutionStarter.startUseSupertypeRefactoring(singleSelectedType, this.getShell());
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    private static IType getSingleSelectedType(IStructuredSelection selection) throws JavaScriptModelException {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof IType) {
            return (IType)first;
        }
        if (first instanceof IJavaScriptUnit) {
            return JavaElementUtil.getMainType((IJavaScriptUnit)first);
        }
        return null;
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isUseSuperTypeAvailable(selection));
        }
        catch (JavaScriptModelException javaScriptModelException) {
            this.setEnabled(false);
        }
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IType type = RefactoringActions.getEnclosingOrPrimaryType(this.fEditor);
            if (RefactoringAvailabilityTester.isUseSuperTypeAvailable(type)) {
                if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaScriptElement)type)) {
                    return;
                }
                RefactoringExecutionStarter.startUseSupertypeRefactoring(type, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.UseSupertypeAction_to_activate);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }
}

