/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVMEventHandlerUtils;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.FusedVirtualMachineStateProvider;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.fused.handlers.VMKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class KvmNestedVmExitInjectHandler
extends VMKernelEventHandler {
    public KvmNestedVmExitInjectHandler(IKernelAnalysisEventLayout layout, FusedVirtualMachineStateProvider sp) {
        super(layout, sp);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) {
        Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpu == null) {
            return;
        }
        FusedVirtualMachineStateProvider sp = this.getStateProvider();
        VirtualMachine host = sp.getCurrentMachine(event);
        if (host == null) {
            return;
        }
        if (host.isGuest()) {
            return;
        }
        int currentCPUNode = FusedVMEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        Object value = ss.queryOngoing(quark);
        int thread = value instanceof Integer ? (Integer)value : -1;
        thread = VirtualCPU.getVirtualCPU(host, cpu.longValue()).getCurrentThread();
        if (thread == -1) {
            return;
        }
        HostThread ht = new HostThread(event.getTrace().getHostId(), Integer.valueOf(thread));
        host.removeThreadFromReadyForNextLayerSet(ht);
    }
}

