/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages;

import com.google.common.base.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2Instance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public class Ros2PubInstance
extends Ros2Instance<Ros2ObjectHandle> {
    public static final byte CUSTOM_TYPE_ID = 65;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_PUB_INSTANCE_VALUE_FACTORY = Ros2PubInstance::read;
    private final long fTid;
    private final @NonNull HostProcessPointer fMessage;
    private final long fSourceTimestamp;

    public Ros2PubInstance(@NonNull Ros2ObjectHandle publisherHandle, long tid, @NonNull HostProcessPointer message, long sourceTimestamp) {
        super(publisherHandle);
        this.fTid = tid;
        this.fMessage = message;
        this.fSourceTimestamp = sourceTimestamp;
    }

    public @NonNull Ros2ObjectHandle getPublisherHandle() {
        return (Ros2ObjectHandle)((Object)this.getOriginHandle());
    }

    public long getTid() {
        return this.fTid;
    }

    public @NonNull HostProcessPointer getMessage() {
        return this.fMessage;
    }

    public long getSourceTimestamp() {
        return this.fSourceTimestamp;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fTid, this.fMessage, this.fSourceTimestamp, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2PubInstance o = (Ros2PubInstance)((Object)obj);
        return this.fTid == o.fTid && this.fMessage.equals((Object)o.fMessage) && this.fSourceTimestamp == o.fSourceTimestamp;
    }

    @Override
    public String toString() {
        return String.format("Ros2PubInstance: publisherHandle=%s, tid=%d, message=[%s], sourceTimestamp=%d", super.toString(), this.fTid, this.fMessage.toString(), this.fSourceTimestamp);
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)65;
    }

    @Override
    protected void serializeValue(ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        buffer.putLong(this.fTid);
        this.fMessage.serializeValue(buffer);
        buffer.putLong(this.fSourceTimestamp);
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += 8;
        size += this.fMessage.getSerializedValueSize();
        return size += 8;
    }

    public static @NonNull Ros2PubInstance read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle publisherHandle = Ros2ObjectHandle.read(buffer);
        long tid = buffer.getLong();
        HostProcessPointer message = HostProcessPointer.read(buffer);
        long sourceTimestamp = buffer.getLong();
        return new Ros2PubInstance(publisherHandle, tid, message, sourceTimestamp);
    }
}

