/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.ui.views;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tracecompass.incubator.internal.ros2.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class Ros2HideInternalObjectsAction
extends Action {
    private static final @NonNull String IMG_UI = "icons/elcl16/hide_internal.gif";
    private static final @NonNull String ACTION_TEXT = "Hide ROS 2 internal";
    private static final @NonNull String ACTION_TOOLTIP_TEXT = "Hide internal ROS 2 objects";
    private static final List<String> HIDDEN_TOPICS = Arrays.asList("/parameter_events", "/rosout");
    private final TimeGraphViewer fTimeGraphViewer;
    private final @NonNull Ros2HideInternalViewerFilter fFilter;

    public Ros2HideInternalObjectsAction(TimeGraphViewer timeGraphViewer) {
        super(ACTION_TEXT, 2);
        this.fTimeGraphViewer = timeGraphViewer;
        this.fFilter = new Ros2HideInternalViewerFilter();
        this.setToolTipText(ACTION_TOOLTIP_TEXT);
        this.setImageDescriptor(Objects.requireNonNull(Activator.getDefault()).getImageDescripterFromPath(IMG_UI));
        this.update();
    }

    public void run() {
        this.update();
    }

    private void update() {
        if (this.isChecked()) {
            this.fTimeGraphViewer.addFilter((ViewerFilter)this.fFilter);
        } else {
            this.fTimeGraphViewer.removeFilter((ViewerFilter)this.fFilter);
        }
        this.fTimeGraphViewer.refresh();
    }

    private class Ros2HideInternalViewerFilter
    extends ViewerFilter {
        private Ros2HideInternalViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof ITimeGraphEntry)) {
                return true;
            }
            ITimeGraphEntry entry = (ITimeGraphEntry)element;
            return !HIDDEN_TOPICS.contains(entry.getName());
        }
    }
}

