/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScriptLocation;
import org.eclipse.ease.ui.scripts.repository.impl.InputStreamParser;
import org.eclipse.ui.PlatformUI;

public class WorkspaceParser
extends InputStreamParser {
    public void parse(IResource resource, final IScriptLocation entry) {
        if (resource instanceof IContainer) {
            try {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (resource instanceof IFile) {
                            WorkspaceParser.this.parse(resource, entry);
                        }
                        return entry.isRecursive();
                    }
                }, entry.isRecursive() ? 2 : 1, 0);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else if (resource instanceof IFile) {
            String location = "workspace:/" + resource.getFullPath();
            IRepositoryService repositoryService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
            repositoryService.updateLocation(entry, location, resource.getModificationStamp());
        }
    }
}

