/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.modules.WrapToScript;

public abstract class AbstractCodeFactory
implements ICodeFactory {
    public static final String LINE_DELIMITER = System.getProperty("line.separator");

    protected String buildParameterList(List<ICodeFactory.Parameter> parameters) {
        return parameters.stream().map(p -> this.toSafeName(p.getName())).collect(Collectors.joining(", "));
    }

    @Override
    public String getDefaultValue(ICodeFactory.Parameter parameter) {
        String defaultStringValue = parameter.getDefaultValue().replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");
        if ("org.eclipse.ease.modules.ScriptParameter.null".equals(defaultStringValue)) {
            return this.getNullString();
        }
        Class<String> clazz = parameter.getClazz();
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.toString(Integer.parseInt(defaultStringValue));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException(String.format("Cannot convert default value '%s' of parameter '%s' to %s", parameter.getDefaultValue(), parameter.getName(), parameter.getClazz().getSimpleName()), e1);
            }
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.toString(Long.parseLong(defaultStringValue));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException(String.format("Cannot convert default value '%s' of parameter '%s' to %s", parameter.getDefaultValue(), parameter.getName(), parameter.getClazz().getSimpleName()), e1);
            }
        }
        if (Byte.class.equals(clazz) || Byte.TYPE.equals(clazz)) {
            try {
                return Integer.toString(Integer.parseInt(defaultStringValue));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException(String.format("Cannot convert default value '%s' of parameter '%s' to %s", parameter.getDefaultValue(), parameter.getName(), parameter.getClazz().getSimpleName()), e1);
            }
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            try {
                return Float.toString(Float.parseFloat(defaultStringValue));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException(String.format("Cannot convert default value '%s' of parameter '%s' to %s", parameter.getDefaultValue(), parameter.getName(), parameter.getClazz().getSimpleName()), e1);
            }
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            try {
                return Double.toString(Double.parseDouble(defaultStringValue));
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException(String.format("Cannot convert default value '%s' of parameter '%s' to %s", parameter.getDefaultValue(), parameter.getName(), parameter.getClazz().getSimpleName()), e1);
            }
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.parseBoolean(defaultStringValue) ? this.getTrueString() : this.getFalseString();
        }
        if (Character.class.equals(clazz) || Character.TYPE.equals(clazz)) {
            if (defaultStringValue.isEmpty()) {
                throw new IllegalArgumentException(String.format("Cannot convert empty default value of parameter '%s' to %s", parameter.getName(), parameter.getClazz().getSimpleName()));
            }
            return "'" + defaultStringValue.charAt(0) + "'";
        }
        if (String.class.equals(clazz)) {
            return "\"" + defaultStringValue + "\"";
        }
        if ("org.eclipse.ease.modules.ScriptParameter.undefined".equals(defaultStringValue)) {
            try {
                clazz.getConstructor(new Class[0]);
                return this.classInstantiation(clazz, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            clazz.getConstructor(String.class);
            return this.classInstantiation(clazz, new String[]{"\"" + defaultStringValue + "\""});
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (clazz.isAssignableFrom(String.class)) {
            return this.classInstantiation(String.class, new String[]{"\"" + defaultStringValue + "\""});
        }
        return this.getNullString();
    }

    public static Collection<String> getMethodNames(Method method) {
        HashSet<String> methodNames = new HashSet<String>();
        methodNames.add(method.getName());
        methodNames.addAll(AbstractCodeFactory.getMethodAliases(method));
        return methodNames;
    }

    public static Collection<String> getMethodAliases(Method method) {
        HashSet<String> methodAliases = new HashSet<String>();
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!name.isBlank()) {
                    methodAliases.add(name.trim());
                }
                ++n2;
            }
        }
        return methodAliases;
    }

    protected abstract String getNullString();

    protected String getTrueString() {
        return Boolean.TRUE.toString();
    }

    protected String getFalseString() {
        return Boolean.FALSE.toString();
    }

    @Override
    public String createFunctionCall(Method method, Object ... parameters) {
        String parameterString = Arrays.asList(parameters).stream().map(p -> this.parameterToString(p)).collect(Collectors.joining(", "));
        return String.format("%s(%s);", method.getName(), parameterString);
    }

    private String parameterToString(Object parameter) {
        if (parameter instanceof String) {
            return String.format("\"%s\"", ((String)parameter).replace("\"", "\\\"").replace("\\", "\\\\"));
        }
        if (parameter == null) {
            return this.getNullString();
        }
        if (parameter instanceof Boolean) {
            return (Boolean)parameter != false ? this.getTrueString() : this.getFalseString();
        }
        return parameter.toString();
    }

    protected String getSingleLineCommentToken() {
        return "// ";
    }

    protected String getMultiLineCommentStartToken() {
        return "/*";
    }

    protected String getMultiLineCommentEndToken() {
        return "*/";
    }

    @Override
    public String createCommentedString(String comment, boolean addBlockComment) {
        if (addBlockComment) {
            return String.valueOf(this.getMultiLineCommentStartToken()) + comment + this.getMultiLineCommentEndToken();
        }
        String token = this.getSingleLineCommentToken();
        Stream<String> split = Pattern.compile("\r?\n").splitAsStream(comment);
        return split.map(s -> String.valueOf(token) + s).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public String createWrapper(IEnvironment environment, Object instance, String identifier, boolean customNamespace, IScriptEngine engine) {
        if (!customNamespace) {
            String code;
            StringBuilder scriptCode = new StringBuilder();
            for (Method method : ModuleHelper.getMethods(instance.getClass())) {
                if (!this.isSupportedByLanguage(method) || (code = this.createFunctionWrapper(environment, identifier, method)) == null || code.isEmpty()) continue;
                scriptCode.append(code);
                scriptCode.append('\n');
            }
            for (Field field : ModuleHelper.getFields(instance.getClass())) {
                if (!this.isSupportedByLanguage(field) || (code = this.createFieldWrapper(environment, identifier, field)) == null || code.isEmpty()) continue;
                scriptCode.append(code);
                scriptCode.append('\n');
            }
            return scriptCode.toString();
        }
        throw new RuntimeException("Object wrappers not supported by default wrapper");
    }

    protected boolean isSupportedByLanguage(Method method) {
        return this.isSupportedByLanguage(method.getAnnotation(WrapToScript.class));
    }

    protected boolean isSupportedByLanguage(Field field) {
        return this.isSupportedByLanguage(field.getAnnotation(WrapToScript.class));
    }

    private boolean isSupportedByLanguage(WrapToScript annotation) {
        String languages;
        if (annotation != null && !(languages = annotation.supportedLanguages().trim()).isEmpty()) {
            String[] supportedLanguages = languages.split(",");
            if (supportedLanguages[0].startsWith("!")) {
                String[] stringArray = supportedLanguages;
                int n = supportedLanguages.length;
                int n2 = 0;
                while (n2 < n) {
                    String language = stringArray[n2];
                    if (language.substring(1).equals(this.getLanguageIdentifier())) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = supportedLanguages;
                int n = supportedLanguages.length;
                int n3 = 0;
                while (n3 < n) {
                    String language = stringArray[n3];
                    if (language.equals(this.getLanguageIdentifier())) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        }
        return true;
    }

    protected abstract Object getLanguageIdentifier();

    protected abstract String createFunctionWrapper(IEnvironment var1, String var2, Method var3);

    protected abstract String createFieldWrapper(IEnvironment var1, String var2, Field var3);

    protected abstract String toSafeName(String var1);
}

