/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.platform.resources;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ease.IExecutionListener;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.modules.platform.resources.FilesystemHandle;
import org.eclipse.ease.modules.platform.resources.FilesystemTools;
import org.eclipse.ease.modules.platform.resources.IFileHandle;
import org.eclipse.ease.modules.platform.resources.ResourceHandle;
import org.eclipse.ease.modules.platform.resources.WorkspaceTools;
import org.eclipse.ease.tools.ResourceTools;

public class ResourcesModule
extends AbstractScriptModule
implements IExecutionListener {
    public static final String MODULE_ID = "/System/Resources";
    @WrapToScript
    public static final int READ = 1;
    @WrapToScript
    public static final int WRITE = 2;
    @WrapToScript
    public static final int APPEND = 4;
    private final Collection<IFileHandle> fOpenHandles = new HashSet<IFileHandle>();

    @WrapToScript
    public static IWorkspaceRoot getWorkspace() {
        return WorkspaceTools.getWorkspace();
    }

    @WrapToScript
    public static IProject getProject(String name) {
        return ResourcesModule.getWorkspace().getProject(name);
    }

    @WrapToScript
    public Object getFile(String location, @ScriptParameter(defaultValue="true") boolean exists) throws FileNotFoundException {
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (exists && !this.fileExists(resource)) {
            throw new FileNotFoundException(String.format("File '%s' does not exist", location));
        }
        return resource;
    }

    @WrapToScript
    public static IProject createProject(String name) throws IOException {
        return WorkspaceTools.createProject(name);
    }

    @WrapToScript
    public Object createFolder(Object location) throws IOException {
        Object folder = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (folder instanceof File) {
            return FilesystemTools.createFolder((File)folder);
        }
        if (folder instanceof IResource) {
            return WorkspaceTools.createFolder((IResource)folder);
        }
        throw new IOException(String.format("Invalid location '%s'", folder));
    }

    @WrapToScript
    public Object createFile(Object location) throws IOException {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof File) {
            return FilesystemTools.createFile((File)file);
        }
        if (file instanceof IFile) {
            return WorkspaceTools.createFile((IFile)file);
        }
        throw new IOException(String.format("Invalid location '%s'", file));
    }

    @WrapToScript
    public IFileHandle openFile(Object location, @ScriptParameter(defaultValue="1") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws IOException {
        return this.getFileHandle(location, mode, autoClose);
    }

    @WrapToScript
    public boolean fileExists(Object location) {
        Object resource = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        return resource != null && ResourceTools.exists((Object)resource) && ResourceTools.isFile((Object)resource);
    }

    @WrapToScript
    public void closeFile(IFileHandle handle) {
        this.fOpenHandles.remove(handle);
        handle.close();
    }

    @WrapToScript
    public String readFile(Object location, @ScriptParameter(defaultValue="-1") int bytes) throws IOException {
        IFileHandle handle = this.getFileHandle(location, 1, false);
        String result = handle.read(bytes);
        if (!(location instanceof IFileHandle)) {
            handle.close();
        }
        return result;
    }

    @WrapToScript
    public void copyFile(Object sourceLocation, Object targetLocation) throws IOException {
        IFileHandle inputFile = this.getFileHandle(sourceLocation, 1, false);
        IFileHandle targetFile = this.getFileHandle(targetLocation, -1, false);
        Files.copy(inputFile.getPath(), targetFile.getPath(), StandardCopyOption.REPLACE_EXISTING);
        if (targetFile.getFile() instanceof IResource) {
            try {
                ((IResource)targetFile.getFile()).getParent().refreshLocal(1, null);
            }
            catch (CoreException e) {
                throw new IOException("Cannot refresh workspace, ", e);
            }
        }
    }

    @WrapToScript
    public void deleteFile(Object location) throws IOException {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IResource) {
            WorkspaceTools.deleteFile((IResource)file);
        } else if (file instanceof File) {
            FilesystemTools.deleteFile((File)file);
        }
    }

    @WrapToScript
    public void deleteFolder(Object location) throws IOException {
        Object folder = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (folder instanceof IResource) {
            WorkspaceTools.deleteFolder((IResource)folder);
        } else if (folder instanceof File) {
            FilesystemTools.deleteFolder((File)folder);
        }
    }

    @WrapToScript
    public void deleteProject(Object source) throws IOException {
        block5: {
            try {
                Object project = ResourceTools.resolve((Object)source, (Object)this.getScriptEngine().getExecutedFile());
                if (project instanceof IProject) {
                    ((IProject)project).delete(true, (IProgressMonitor)new NullProgressMonitor());
                    break block5;
                }
                if (source != null) {
                    IProject localProject = ResourcesModule.getProject(source.toString());
                    if (localProject.exists()) {
                        localProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                        break block5;
                    }
                    throw new FileNotFoundException(String.format("Project '%s' cannot be found", source));
                }
                throw new IllegalArgumentException("cannot delete project <null>");
            }
            catch (CoreException e) {
                throw new IOException(String.format("Project '%s' cannot be deleted", source), e);
            }
        }
    }

    @WrapToScript
    public String readLine(Object location) throws IOException {
        IFileHandle handle = this.getFileHandle(location, 1, false);
        String result = handle.readLine();
        if (!(location instanceof IFileHandle)) {
            handle.close();
        }
        return result;
    }

    @WrapToScript
    public IFileHandle writeFile(Object location, Object data, @ScriptParameter(defaultValue="2") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws IOException {
        IFileHandle handle = this.getFileHandle(location, mode, autoClose);
        if (data instanceof byte[]) {
            handle.write((byte[])data);
        } else if (data != null) {
            handle.write(data.toString());
        }
        return handle;
    }

    @WrapToScript
    public IFileHandle writeLine(Object location, String data, @ScriptParameter(defaultValue="2") int mode, @ScriptParameter(defaultValue="true") boolean autoClose) throws IOException {
        return this.writeFile(location, String.format("%s%n", data), mode, autoClose);
    }

    private IFileHandle getFileHandle(Object location, int mode, boolean autoClose) throws IOException {
        IFileHandle handle = null;
        if (location instanceof String && ((String)location).isEmpty()) {
            handle = null;
        } else if (location instanceof IFileHandle) {
            handle = (IFileHandle)location;
        } else if (location instanceof File) {
            handle = this.findHandle(location, mode);
            if (handle == null) {
                handle = new FilesystemHandle((File)location, mode);
            }
        } else if (location instanceof IFile) {
            handle = this.findHandle(location, mode);
            if (handle == null) {
                handle = new ResourceHandle((IFile)location, mode);
            }
        } else if (location != null) {
            handle = this.getFileHandle(ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile()), mode, autoClose);
        }
        if (handle != null && !handle.exists()) {
            if (mode == 1) {
                throw new FileNotFoundException(String.format("File '%s' does not exist", location));
            }
            handle.createFile(true);
        }
        if (handle != null && autoClose) {
            this.fOpenHandles.add(handle);
            this.getScriptEngine().addExecutionListener((IExecutionListener)this);
        }
        if (handle != null) {
            return handle;
        }
        throw new FileNotFoundException("Could not locate file \"" + location + "\"");
    }

    private IFileHandle findHandle(Object location, int mode) {
        for (IFileHandle handle : this.fOpenHandles) {
            if (!Objects.equals(handle.getFile(), location) || !Objects.equals(handle.getMode(), mode)) continue;
            return handle;
        }
        return null;
    }

    @WrapToScript
    public String showFileSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, @ScriptParameter(defaultValue="0") int type, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) throws IOException {
        int mode;
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        int n = mode = type == 2 || type == 4 ? 8192 : 4096;
        if (root instanceof File) {
            return FilesystemTools.openFileSelectionDialog((File)root, mode, title);
        }
        if (root instanceof IContainer) {
            return WorkspaceTools.openFileSelectionDialog((IContainer)root, mode, title, message);
        }
        throw new IOException(String.format("Cannot resolve root folder: '%s'", rootFolder));
    }

    @WrapToScript
    public String showFolderSelectionDialog(@ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String title, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String message) throws IOException {
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof File) {
            return FilesystemTools.openFolderSelectionDialog((File)root, title, message);
        }
        if (root instanceof IContainer) {
            return WorkspaceTools.openFolderSelectionDialog((IContainer)root, title, message);
        }
        throw new IOException(String.format("Cannot resolve root folder: '%s'", rootFolder));
    }

    @WrapToScript
    public String[] findFiles(String pattern, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") Object rootFolder, @ScriptParameter(defaultValue="true") boolean recursive) throws IOException {
        Pattern regExp = pattern.startsWith("^") ? Pattern.compile(pattern) : Pattern.compile(pattern.replaceAll("\\*", ".*").replaceAll("\\?", "."));
        Object root = ResourceTools.resolve((Object)rootFolder, (Object)this.getScriptEngine().getExecutedFile());
        if (root == null || rootFolder == null) {
            root = ResourcesModule.getWorkspace();
        }
        if (root instanceof IContainer) {
            return WorkspaceTools.findFiles(regExp, (IContainer)root, recursive);
        }
        if (root instanceof File) {
            return FilesystemTools.findFiles(regExp, (File)root, recursive);
        }
        throw new IOException(String.format("Cannot resolve root folder: '%s'", rootFolder));
    }

    @WrapToScript
    public IProject linkProject(Object location) throws IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (resolvedLocation instanceof File) {
            return WorkspaceTools.linkProject((File)resolvedLocation);
        }
        if (resolvedLocation instanceof IResource) {
            throw new IOException(String.format("'%s' is already part of the workspace", location));
        }
        throw new IOException(String.format("Could not resolve location '%s'", location));
    }

    @WrapToScript
    public IProject importProject(Object location) throws IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (resolvedLocation instanceof File) {
            return WorkspaceTools.importProject((File)resolvedLocation);
        }
        if (resolvedLocation instanceof IResource) {
            throw new IOException(String.format("'%s' is already part of the workspace", location));
        }
        throw new IOException("Could not resolve file location \"" + location + "\"");
    }

    @WrapToScript
    public void refreshResource(Object resource) throws IOException {
        Object resolvedResource = ResourceTools.resolve((Object)resource);
        if (resolvedResource instanceof IResource) {
            try {
                ((IResource)resolvedResource).refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new IOException(e);
            }
        }
    }

    @WrapToScript
    public String readStream(InputStream input) throws IOException {
        return ResourceTools.toString((InputStream)input);
    }

    @WrapToScript
    public void createProblemMarker(String severity, Object location, int lineNumber, String message, @ScriptParameter(defaultValue="org.eclipse.core.resources.problemmarker") String type, @ScriptParameter(defaultValue="true") boolean permanent) throws IOException {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (!(file instanceof IFile)) {
            throw new IOException(String.format("'%s' is not a workspace file", location));
        }
        WorkspaceTools.createProblemMarker((IFile)file, type, lineNumber, this.convertMarkerSeverity(severity), message, permanent);
    }

    private int convertMarkerSeverity(String severity) {
        switch (severity) {
            case "error": {
                return 2;
            }
            case "warning": {
                return 1;
            }
        }
        return 0;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        if (status == 2) {
            for (IFileHandle handle : this.fOpenHandles) {
                handle.close();
            }
            this.fOpenHandles.clear();
        }
    }

    @WrapToScript
    public Object zip(Object sourceLocation, Object zipLocation) throws IOException {
        Path sourceFilePath = this.resolveFilePath(sourceLocation);
        Path zipFilePath = this.resolveFilePath(zipLocation);
        FilesystemTools.zip(sourceFilePath, zipFilePath);
        Object zipFile = ResourceTools.resolve((Object)zipLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (zipFile instanceof IFile) {
            this.refreshResource(((IFile)zipFile).getParent());
        }
        return zipFile;
    }

    private Path resolveFilePath(Object location) throws IOException {
        Object file = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        if (file instanceof IResource) {
            file = ((IResource)file).getLocation().toFile();
        }
        if (!(file instanceof File)) {
            throw new IOException(String.format("Cannot resolve location: %s", location));
        }
        return ((File)file).toPath();
    }

    @WrapToScript
    public Object unzip(Object zipLocation, Object targetLocation) throws IOException {
        Path zipFilePath = this.resolveFilePath(zipLocation);
        Path targetDirectoryPath = this.resolveFilePath(targetLocation);
        if (!targetDirectoryPath.toFile().exists()) {
            this.createFolder(targetDirectoryPath.toFile());
        }
        FilesystemTools.unzip(zipFilePath, targetDirectoryPath);
        Object targetDirectory = ResourceTools.resolve((Object)targetLocation, (Object)this.getScriptEngine().getExecutedFile());
        if (targetDirectory instanceof IContainer) {
            this.refreshResource(((IContainer)targetDirectory).getParent());
        }
        return targetDirectory;
    }

    @WrapToScript
    public String getChecksum(Object location) throws IOException {
        Object resolvedLocation = ResourceTools.resolve((Object)location, (Object)this.getScriptEngine().getExecutedFile());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream input = ResourceTools.getInputStream((Object)resolvedLocation);){
            if (input != null) {
                return this.byteArrayToHexString(FilesystemTools.getChecksum(input));
            }
            throw new IOException("Location \"" + location + "\" cannot be accessed.");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            String token = Integer.toHexString(b);
            if (token.length() == 1) {
                builder.append('0');
            }
            builder.append(token.substring(Math.max(token.length() - 2, 0)));
            ++n2;
        }
        return builder.toString();
    }
}

