/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.keyword.contentassist;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class KeywordUtilities {
    private static KeywordUtilities instance;
    private final Set<String> keywords = new HashSet<String>(27);

    private KeywordUtilities() {
        this.keywords.add("break");
        this.keywords.add("case");
        this.keywords.add("catch");
        this.keywords.add("class");
        this.keywords.add("const");
        this.keywords.add("continue");
        this.keywords.add("debugger");
        this.keywords.add("default");
        this.keywords.add("delete");
        this.keywords.add("do");
        this.keywords.add("else");
        this.keywords.add("elseif");
        this.keywords.add("export");
        this.keywords.add("extends");
        this.keywords.add("finally");
        this.keywords.add("for");
        this.keywords.add("function");
        this.keywords.add("if");
        this.keywords.add("import");
        this.keywords.add("in");
        this.keywords.add("instanceof");
        this.keywords.add("let");
        this.keywords.add("new");
        this.keywords.add("return");
        this.keywords.add("super");
        this.keywords.add("static");
        this.keywords.add("switch");
        this.keywords.add("this");
        this.keywords.add("throw");
        this.keywords.add("try");
        this.keywords.add("typeof");
        this.keywords.add("var");
        this.keywords.add("void");
        this.keywords.add("while");
        this.keywords.add("with");
        this.keywords.add("yield");
    }

    public static KeywordUtilities getInstance() {
        if (instance == null) {
            instance = new KeywordUtilities();
        }
        return instance;
    }

    public boolean isKeyword(String string) {
        return this.keywords.contains(string.toLowerCase());
    }

    public List<String> getMatchingKeywords(String string) {
        return this.keywords.stream().filter(k -> k.startsWith(string.toLowerCase())).collect(Collectors.toList());
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }
}

