/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ReporterHelper;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public final class ValidationResult {
    private final List<ValidatorMessage> _messages = new LinkedList<ValidatorMessage>();
    private static final ValidatorMessage[] _noMessages = new ValidatorMessage[0];
    private boolean _canceled;
    private IResource[] _dependsOn;
    private IResource[] _validated;
    private int _severityError;
    private int _severityWarning;
    private int _severityInfo;
    private IProject _suspendValidation;
    private int _numberOfValidatedResources = 1;
    private ReporterHelper _reporter;
    private ValidationException _validationException;

    public void add(ValidatorMessage message) {
        this._messages.add(message);
    }

    public IReporter getReporter(IProgressMonitor monitor) {
        if (this._reporter == null) {
            this._reporter = new ReporterHelper(monitor);
        }
        return this._reporter;
    }

    ReporterHelper getReporterHelper() {
        return this._reporter;
    }

    public void mergeResults(ValidationResult result) {
        ValidatorMessage[] msgs;
        if (result == null) {
            return;
        }
        ValidatorMessage[] validatorMessageArray = msgs = result.getMessages();
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMessage m = validatorMessageArray[n2];
            this.add(m);
            int severity = m.getAttribute("severity", 0);
            switch (severity) {
                case 2: {
                    this.incrementError(1);
                    break;
                }
                case 1: {
                    this.incrementWarning(1);
                    break;
                }
                case 0: {
                    this.incrementInfo(1);
                }
            }
            ++n2;
        }
        this.incrementError(result.getSeverityError());
        this.incrementWarning(result.getSeverityWarning());
        this.incrementInfo(result.getSeverityInfo());
        this._numberOfValidatedResources += result.getNumberOfValidatedResources();
    }

    public IResource[] getDependsOn() {
        return this._dependsOn;
    }

    public ValidatorMessage[] getMessages() {
        if (this._messages == null) {
            return _noMessages;
        }
        ValidatorMessage[] msgs = new ValidatorMessage[this._messages.size()];
        this._messages.toArray(msgs);
        return msgs;
    }

    public synchronized ValidatorMessage[] getMessagesAsCopy() {
        if (this._messages == null) {
            return _noMessages;
        }
        ValidatorMessage[] msgs = new ValidatorMessage[this._messages.size()];
        int i = 0;
        for (ValidatorMessage msg : this._messages) {
            msgs[i++] = msg.asCopy();
        }
        return msgs;
    }

    public void setDependsOn(IResource[] dependsOn) {
        this._dependsOn = dependsOn;
    }

    public IResource[] getValidated() {
        return this._validated;
    }

    public void setValidated(IResource[] validated) {
        this._validated = validated;
    }

    public int getSeverityError() {
        return this._severityError;
    }

    public void setSeverityError(int severityError) {
        this._severityError = severityError;
    }

    public int incrementError(int errors) {
        this._severityError += errors;
        return this._severityError;
    }

    public int getSeverityWarning() {
        return this._severityWarning;
    }

    public void setSeverityWarning(int severityWarning) {
        this._severityWarning = severityWarning;
    }

    public int incrementWarning(int warnings) {
        this._severityWarning += warnings;
        return this._severityWarning;
    }

    public int getSeverityInfo() {
        return this._severityInfo;
    }

    public void setSeverityInfo(int severityInfo) {
        this._severityInfo = severityInfo;
    }

    public int incrementInfo(int info) {
        this._severityInfo += info;
        return this._severityInfo;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setCanceled(boolean canceled) {
        this._canceled = canceled;
    }

    public int getNumberOfValidatedResources() {
        if (this._validated == null) {
            return this._numberOfValidatedResources;
        }
        return this._numberOfValidatedResources + this._validated.length;
    }

    public ValidationException getValidationException() {
        return this._validationException;
    }

    public void setValidationException(ValidationException validationException) {
        this._validationException = validationException;
    }

    public IProject getSuspendValidation() {
        return this._suspendValidation;
    }

    public void setSuspendValidation(IProject project) {
        this._suspendValidation = project;
    }
}

