/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.IValidatorGroupListener;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public class ValidatorGroupExtensionReader {
    private static final String DOT = ".";
    private static ValidatorGroupExtensionReader _instance;
    private Map<String, List<IConfigurationElement>> _map;
    private Map<String, IValidatorGroupListener[]> _resolved;

    public static ValidatorGroupExtensionReader getDefault() {
        if (_instance == null) {
            _instance = new ValidatorGroupExtensionReader();
        }
        return _instance;
    }

    private ValidatorGroupExtensionReader() {
        this.init();
    }

    IValidatorGroupListener[] createListeners(String groupID) throws CoreException {
        IValidatorGroupListener[] result = this._resolved.get(groupID);
        if (result != null) {
            return result;
        }
        List<IConfigurationElement> elements = this._map.get(groupID);
        if (elements == null) {
            this._resolved.put(groupID, new IValidatorGroupListener[0]);
            String msg = NLS.bind((String)"Configuration error, there is no validation listener group with id: {0}", (Object)groupID);
            Status status = new Status(4, "org.eclipse.wst.validation", msg);
            throw new CoreException((IStatus)status);
        }
        ArrayList<IValidatorGroupListener> listeners = new ArrayList<IValidatorGroupListener>(elements.size());
        for (IConfigurationElement element : elements) {
            try {
                IValidatorGroupListener listener = (IValidatorGroupListener)element.createExecutableExtension("class");
                listeners.add(listener);
            }
            catch (Exception e) {
                ValidationPlugin.getPlugin().handleException(e);
                listeners = new ArrayList();
            }
        }
        result = listeners.toArray(new IValidatorGroupListener[listeners.size()]);
        this._resolved.put(groupID, result);
        return result;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        return registry.getExtensionPoint("org.eclipse.wst.validation", "validatorGroup");
    }

    private void init() {
        this._map = new HashMap<String, List<IConfigurationElement>>(4);
        this._resolved = new HashMap<String, IValidatorGroupListener[]>(4);
        IExtensionPoint extensionPoint = this.getExtensionPoint();
        if (extensionPoint != null) {
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement group = iConfigurationElementArray[n4];
                    this.processGroupElement(group);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void processGroupElement(IConfigurationElement element) {
        IConfigurationElement[] newElements;
        if (!"group".equals(element.getName())) {
            return;
        }
        Object id = element.getAttribute("id");
        if (id == null) {
            throw new IllegalStateException("Configuration error, the id is required");
        }
        if (((String)id).indexOf(DOT) < 0) {
            id = element.getContributor().getName() + DOT + (String)id;
        }
        if ((newElements = element.getChildren("listener")).length > 0) {
            List<IConfigurationElement> elements = this._map.get(id);
            if (elements == null) {
                elements = new ArrayList<IConfigurationElement>();
                this._map.put((String)id, elements);
            }
            elements.addAll(Arrays.asList(newElements));
        }
    }
}

