/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.wizards.NewTypeWizardPage;

public class NewClassWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewClassWizardPage";
    private static final String SETTINGS_CREATEMAIN = "create_main";
    private static final String SETTINGS_CREATECONSTR = "create_constructor";
    private static final String SETTINGS_CREATEUNIMPLEMENTED = "create_unimplemented";
    private SelectionButtonDialogFieldGroup fMethodStubsButtons;

    public NewClassWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(NewWizardMessages.NewClassWizardPage_title);
        this.setDescription(NewWizardMessages.NewClassWizardPage_description);
        String[] buttonNames3 = new String[]{NewWizardMessages.NewClassWizardPage_methods_main, NewWizardMessages.NewClassWizardPage_methods_constructors, NewWizardMessages.NewClassWizardPage_methods_inherited};
        this.fMethodStubsButtons = new SelectionButtonDialogFieldGroup(32, buttonNames3, 1);
        this.fMethodStubsButtons.setLabelText(NewWizardMessages.NewClassWizardPage_methods_label);
    }

    public void init(IStructuredSelection selection) {
        IDialogSettings section;
        IJavaScriptElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        boolean createMain = false;
        boolean createConstructors = false;
        boolean createUnimplemented = true;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection(PAGE_NAME)) != null) {
            createMain = section.getBoolean(SETTINGS_CREATEMAIN);
            createConstructors = section.getBoolean(SETTINGS_CREATECONSTR);
            createUnimplemented = section.getBoolean(SETTINGS_CREATEUNIMPLEMENTED);
        }
        this.setMethodStubSelection(createMain, createConstructors, createUnimplemented, true);
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus, this.fSuperClassStatus, this.fSuperInterfacesStatus};
        this.updateStatus(status);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.new_class_wizard_page_context");
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        } else {
            IDialogSettings dialogSettings = this.getDialogSettings();
            if (dialogSettings != null) {
                IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
                if (section == null) {
                    section = dialogSettings.addNewSection(PAGE_NAME);
                }
                section.put(SETTINGS_CREATEMAIN, this.isCreateMain());
                section.put(SETTINGS_CREATECONSTR, this.isCreateConstructors());
                section.put(SETTINGS_CREATEUNIMPLEMENTED, this.isCreateInherited());
            }
        }
    }

    private void createMethodStubSelectionControls(Composite composite, int nColumns) {
        Label labelControl = this.fMethodStubsButtons.getLabelControl(composite);
        LayoutUtil.setHorizontalSpan((Control)labelControl, nColumns);
        DialogField.createEmptySpace(composite);
        Composite buttonGroup = this.fMethodStubsButtons.getSelectionButtonsGroup(composite);
        LayoutUtil.setHorizontalSpan((Control)buttonGroup, nColumns - 1);
    }

    public boolean isCreateMain() {
        return this.fMethodStubsButtons.isSelected(0);
    }

    public boolean isCreateConstructors() {
        return this.fMethodStubsButtons.isSelected(1);
    }

    public boolean isCreateInherited() {
        return this.fMethodStubsButtons.isSelected(2);
    }

    public void setMethodStubSelection(boolean createMain, boolean createConstructors, boolean createInherited, boolean canBeModified) {
        this.fMethodStubsButtons.setSelection(0, createMain);
        this.fMethodStubsButtons.setSelection(1, createConstructors);
        this.fMethodStubsButtons.setSelection(2, createInherited);
        this.fMethodStubsButtons.setEnabled(canBeModified);
    }

    @Override
    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        boolean doMain = this.isCreateMain();
        boolean doConstr = this.isCreateConstructors();
        boolean doInherited = this.isCreateInherited();
        this.createInheritedMethods(type, doConstr, doInherited, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (doMain) {
            StringBuffer buf = new StringBuffer();
            String comment = CodeGeneration.getMethodComment(type.getJavaScriptUnit(), type.getTypeQualifiedName('.'), "main", new String[]{"args"}, new String[0], Signature.createTypeSignature((String)"void", (boolean)true), null, "\n");
            if (comment != null) {
                buf.append(comment);
                buf.append("\n");
            }
            buf.append("public static void main(");
            buf.append(imports.addImport("java.lang.String"));
            buf.append("[] args) {");
            buf.append("\n");
            String content = CodeGeneration.getMethodBodyContent(type.getJavaScriptUnit(), type.getTypeQualifiedName('.'), "main", false, "", "\n");
            if (content != null && content.length() != 0) {
                buf.append(content);
            }
            buf.append("\n");
            buf.append("}");
            type.createMethod(buf.toString(), null, false, null);
        }
        if (monitor != null) {
            monitor.done();
        }
    }
}

