/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.core.index.EntryResult;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public class SuperTypeReferencePattern
extends JavaSearchPattern {
    public char[] superTypeName;
    public char[] typeName;
    protected static char[][] CATEGORIES = new char[][]{SUPER_REF};

    public static char[] createIndexKey(char[] typeName, char[] superTypeName) {
        if (superTypeName == null) {
            superTypeName = OBJECT;
        }
        int superLength = superTypeName == null ? 0 : superTypeName.length;
        int typeLength = typeName == null ? 0 : typeName.length;
        char[] result = new char[superLength + typeLength + 1];
        int pos = 0;
        if (superLength > 0) {
            System.arraycopy(superTypeName, 0, result, pos, superLength);
            pos += superLength;
        }
        result[pos++] = 47;
        if (typeLength > 0) {
            System.arraycopy(typeName, 0, result, pos, typeLength);
            pos += typeLength;
        }
        return result;
    }

    public SuperTypeReferencePattern(char[] superTypeName, int matchRule) {
        this(matchRule);
        this.superTypeName = this.isCaseSensitive() ? superTypeName : CharOperation.toLowerCase(superTypeName);
    }

    SuperTypeReferencePattern(int matchRule) {
        super(16, matchRule);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key, 0);
        this.superTypeName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        this.typeName = CharOperation.subarray(key, start, slash);
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new SuperTypeReferencePattern(8);
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        SuperTypeReferencePattern pattern = (SuperTypeReferencePattern)decodedPattern;
        if (pattern.superTypeName != null && !this.matchesName(this.superTypeName, pattern.superTypeName)) {
            return false;
        }
        return this.matchesName(this.typeName, pattern.typeName);
    }

    @Override
    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.superTypeName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                if (this.superTypeName == null) break;
                key = CharOperation.append(this.superTypeName, '/');
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        output.append("SuperClassReferencePattern: <");
        if (this.superTypeName != null) {
            output.append(this.superTypeName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

