/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.LinkedList;
import org.eclipse.help.ui.internal.views.HistoryEntry;

public class ReusableHelpPartHistory {
    private static final int CAPACITY = 50;
    private final LinkedList<HistoryEntry> queue = new LinkedList();
    private int cursor = -1;
    private boolean blocked;

    public void addEntry(HistoryEntry entry) {
        int extra;
        if (this.cursor != -1 && (extra = this.queue.size() - 1 - this.cursor) > 0) {
            int i = extra;
            while (i > 0) {
                this.queue.removeLast();
                --i;
            }
        }
        this.queue.add(entry);
        if (this.queue.size() > 50) {
            this.queue.removeFirst();
        }
        this.cursor = this.queue.size() - 1;
    }

    public boolean hasNext() {
        return this.cursor != -1 && this.cursor < this.queue.size() - 1;
    }

    public boolean hasPrev() {
        return this.cursor != -1 && this.cursor > 0;
    }

    public HistoryEntry getNext() {
        return this.hasNext() ? this.queue.get(this.cursor + 1) : null;
    }

    public HistoryEntry getPrev() {
        return this.hasPrev() ? this.queue.get(this.cursor - 1) : null;
    }

    public HistoryEntry next() {
        if (this.hasNext()) {
            return this.queue.get(++this.cursor);
        }
        return null;
    }

    public HistoryEntry prev() {
        if (this.hasPrev()) {
            return this.queue.get(--this.cursor);
        }
        return null;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }
}

