/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.io.File;
import java.io.PrintStream;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.debugging.ScriptStackTrace;

public class ScriptExecutionException
extends ExecutionException {
    private static final long serialVersionUID = 1887518058581732543L;
    private final String fLineSource;
    private final int fColumnNumber;
    private final ScriptStackTrace fScriptStackTrace;
    private final String fErrorName;

    protected ScriptExecutionException() {
        this.fLineSource = null;
        this.fColumnNumber = 0;
        this.fScriptStackTrace = null;
        this.fErrorName = null;
    }

    public ScriptExecutionException(String message) {
        super(message);
        this.fLineSource = null;
        this.fColumnNumber = 0;
        this.fScriptStackTrace = null;
        this.fErrorName = null;
    }

    public ScriptExecutionException(Throwable exception) {
        super(exception);
        this.fLineSource = null;
        this.fColumnNumber = 0;
        this.fScriptStackTrace = null;
        this.fErrorName = null;
    }

    public ScriptExecutionException(String message, int columnNumber, String lineSource, String errorName, ScriptStackTrace scriptStackTrace, Throwable cause) {
        super(message, cause);
        this.fLineSource = lineSource;
        this.fColumnNumber = columnNumber;
        this.fScriptStackTrace = scriptStackTrace;
        this.fErrorName = errorName;
    }

    @Override
    public final String getMessage() {
        StringBuilder buffer = new StringBuilder();
        if (this.fErrorName != null) {
            buffer.append(this.fErrorName);
            buffer.append(": ");
        }
        if (super.getMessage() != null) {
            buffer.append(super.getMessage());
        } else if (this.getCause() != null) {
            buffer.append(this.getCause().getClass().getName());
        }
        if (this.fLineSource != null) {
            buffer.append('\n').append(this.fLineSource);
            if (this.fColumnNumber != 0) {
                buffer.append('\n');
                int i = 1;
                while (i < this.fColumnNumber) {
                    buffer.append(" ");
                    ++i;
                }
                buffer.append('^');
            }
        }
        return buffer.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        Throwable cause;
        s.println(this);
        if (this.fScriptStackTrace != null) {
            for (IScriptDebugFrame traceElement : this.fScriptStackTrace) {
                if (traceElement.getScript() == null) continue;
                String fileName = "<unknown source>";
                Object file = traceElement.getScript().getFile();
                if (file instanceof IFile) {
                    fileName = ((IFile)file).getName();
                } else if (file instanceof File) {
                    fileName = ((File)file).getName();
                }
                String name = traceElement.getName() != null && !traceElement.getName().isEmpty() ? "," + traceElement.getName() : "";
                String lineInfo = traceElement.getLineNumber() > 0 ? ":" + traceElement.getLineNumber() : "";
                s.println("\tat " + fileName + name + lineInfo);
            }
        }
        if ((cause = this.getCause()) != null) {
            s.println("\nJava Stacktrace:");
            cause.printStackTrace(s);
        }
    }
}

