/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderCapabilities;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.DataProviderCapabilities;

public class DataProviderDescriptorSerializer
extends StdSerializer<IDataProviderDescriptor> {
    private static final long serialVersionUID = 9170252203750031947L;

    public DataProviderDescriptorSerializer() {
        super(IDataProviderDescriptor.class);
    }

    public void serialize(IDataProviderDescriptor value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        IDataProviderCapabilities cap;
        gen.writeStartObject();
        String parentId = value.getParentId();
        if (parentId != null) {
            gen.writeStringField("parentId", value.getParentId());
        }
        gen.writeStringField("id", value.getId());
        gen.writeStringField("name", value.getName());
        gen.writeStringField("description", value.getDescription());
        gen.writeStringField("type", value.getType().name());
        ITmfConfiguration config = value.getConfiguration();
        if (config != null) {
            gen.writeObjectField("configuration", (Object)config);
        }
        if ((cap = value.getCapabilities()) != DataProviderCapabilities.NULL_INSTANCE) {
            gen.writeObjectFieldStart("capabilities");
            gen.writeBooleanField("canCreate", cap.canCreate());
            gen.writeBooleanField("canDelete", cap.canDelete());
            gen.writeEndObject();
        }
        gen.writeEndObject();
    }
}

