/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.core.model.StructureDeclaration;

public class Structure
extends StructureDeclaration
implements IStructure {
    Map<String, ASTAccessVisibility> superClassesNames = new TreeMap<String, ASTAccessVisibility>();

    public Structure(ICElement parent, int kind, String name) {
        super(parent, name, kind);
    }

    @Override
    public IField[] getFields() throws CModelException {
        ArrayList<ICElement> fields = new ArrayList<ICElement>();
        fields.addAll(this.getChildrenOfType(72));
        return fields.toArray(new IField[fields.size()]);
    }

    @Override
    public IField getField(String name) {
        try {
            IField[] fields;
            IField[] iFieldArray = fields = this.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                IField field = iFieldArray[n2];
                if (field.getElementName().equals(name)) {
                    return field;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IMethodDeclaration[] getMethods() throws CModelException {
        ArrayList<ICElement> methods = new ArrayList<ICElement>();
        methods.addAll(this.getChildrenOfType(71));
        methods.addAll(this.getChildrenOfType(70));
        return methods.toArray(new IMethodDeclaration[methods.size()]);
    }

    @Override
    public IMethodDeclaration getMethod(String name) {
        try {
            IMethodDeclaration[] methods;
            IMethodDeclaration[] iMethodDeclarationArray = methods = this.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodDeclaration method = iMethodDeclarationArray[n2];
                if (method.getElementName().equals(name)) {
                    return method;
                }
                ++n2;
            }
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isAbstract() throws CModelException {
        IMethodDeclaration[] methods;
        IMethodDeclaration[] iMethodDeclarationArray = methods = this.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodDeclaration method = iMethodDeclarationArray[n2];
            if (method.isPureVirtual()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String[] getSuperClassesNames() {
        return this.superClassesNames.keySet().toArray(new String[this.superClassesNames.keySet().size()]);
    }

    @Override
    public ASTAccessVisibility getSuperClassAccess(String name) {
        return this.superClassesNames.get(name);
    }

    public void addSuperClass(String name) {
        this.superClassesNames.put(name, ASTAccessVisibility.PUBLIC);
    }

    public void addSuperClass(String name, ASTAccessVisibility access) {
        this.superClassesNames.put(name, access);
    }
}

