/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.HostProcessPointer;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.messages.Ros2Instance;
import org.eclipse.tracecompass.incubator.internal.ros2.core.model.objects.Ros2ObjectHandle;

public class Ros2TakeInstance
extends Ros2Instance<Ros2ObjectHandle> {
    public static final byte CUSTOM_TYPE_ID = 66;
    public static final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull CustomStateValue.CustomStateValueFactory ROS2_TAKE_INSTANCE_VALUE_FACTORY = Ros2TakeInstance::read;
    private final long fTid;
    private final @NonNull HostProcessPointer fMessage;
    private final long fSourceTimestamp;
    private final long fStartTime;
    private final long fEndTime;

    public Ros2TakeInstance(@NonNull Ros2ObjectHandle subscriptionHandle, long tid, @NonNull HostProcessPointer message, long sourceTimestamp, long startTime, long endTime) {
        super(subscriptionHandle);
        this.fTid = tid;
        this.fMessage = message;
        this.fSourceTimestamp = sourceTimestamp;
        this.fStartTime = startTime;
        this.fEndTime = endTime;
    }

    public @NonNull Ros2ObjectHandle getSubscriptionHandle() {
        return (Ros2ObjectHandle)((Object)this.getOriginHandle());
    }

    public long getTid() {
        return this.fTid;
    }

    public @NonNull HostProcessPointer getMessage() {
        return this.fMessage;
    }

    public long getSourceTimestamp() {
        return this.fSourceTimestamp;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    public long getEndTime() {
        return this.fEndTime;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.fTid, this.fMessage, this.fSourceTimestamp, this.fStartTime, this.fEndTime, super.hashCode()});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Ros2TakeInstance o = (Ros2TakeInstance)((Object)obj);
        return this.fTid == o.fTid && this.fMessage.equals((Object)o.fMessage) && this.fSourceTimestamp == o.fSourceTimestamp && this.fStartTime == o.fStartTime && this.fEndTime == o.fEndTime;
    }

    @Override
    public String toString() {
        return String.format("Ros2TakeInstance: subscriptionHandle=%s, tid=%d, message=[%s], sourceTimestamp=%d, startTime=%d, endTime=%d", super.toString(), this.fTid, this.fMessage.toString(), this.fSourceTimestamp, this.fStartTime, this.fEndTime);
    }

    protected @NonNull Byte getCustomTypeId() {
        return (byte)66;
    }

    @Override
    protected void serializeValue(ISafeByteBufferWriter buffer) {
        super.serializeValue(buffer);
        buffer.putLong(this.fTid);
        this.fMessage.serializeValue(buffer);
        buffer.putLong(this.fSourceTimestamp);
        buffer.putLong(this.fStartTime);
        buffer.putLong(this.fEndTime);
    }

    public void serializeObject(@NonNull ISafeByteBufferWriter buffer) {
        this.serializeValue(buffer);
    }

    @Override
    protected int getSerializedValueSize() {
        int size = 0;
        size += super.getSerializedValueSize();
        size += 8;
        size += this.fMessage.getSerializedValueSize();
        size += 8;
        size += 8;
        return size += 8;
    }

    public static @NonNull Ros2TakeInstance read(ISafeByteBufferReader buffer) {
        Ros2ObjectHandle subscriptionHandle = Ros2ObjectHandle.read(buffer);
        long tid = buffer.getLong();
        HostProcessPointer message = HostProcessPointer.read(buffer);
        long sourceTimestamp = buffer.getLong();
        long startTime = buffer.getLong();
        long endTime = buffer.getLong();
        return new Ros2TakeInstance(subscriptionHandle, tid, message, sourceTimestamp, startTime, endTime);
    }
}

