/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMembersProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.wst.jsdt.internal.ui.refactoring.DelegateUIHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.ControlContentAssistHelper;
import org.eclipse.wst.jsdt.internal.ui.refactoring.contentassist.JavaTypeCompletionProcessor;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class MoveMembersWizard
extends RefactoringWizard {
    public MoveMembersWizard(MoveRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.MoveMembersWizard_page_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new MoveMembersInputPage());
    }

    private static class MoveMembersInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "MoveMembersInputPage";
        private static final long LABEL_FLAGS = 0x20000AL;
        private Combo fDestinationField;
        private Button fLeaveDelegateCheckBox;
        private Button fDeprecateDelegateCheckBox;
        private static final int MRU_COUNT = 10;
        private static List fgMruDestinations = new ArrayList(10);

        public MoveMembersInputPage() {
            super(PAGE_NAME);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                String message = Messages.format(RefactoringMessages.MoveMembersInputPage_descriptionKey, new String[]{Integer.valueOf(this.getMoveProcessor().getMembersToMove().length).toString(), JavaModelUtil.getFullyQualifiedName(this.getMoveProcessor().getDeclaringType())});
                this.setDescription(message);
            }
            super.setVisible(visible);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            this.addLabel(composite);
            this.addDestinationControls(composite);
            this.fLeaveDelegateCheckBox = DelegateUIHelper.generateLeaveDelegateCheckbox(composite, this.getRefactoring(), this.getMoveProcessor().getMembersToMove().length > 1);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            if (this.fLeaveDelegateCheckBox != null) {
                this.fLeaveDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox = new Button(composite, 32);
                data = new GridData();
                data.horizontalAlignment = 4;
                data.horizontalIndent = layout.marginWidth + this.fDeprecateDelegateCheckBox.computeSize((int)-1, (int)-1).x;
                data.horizontalSpan = 2;
                this.fDeprecateDelegateCheckBox.setLayoutData((Object)data);
                this.fDeprecateDelegateCheckBox.setText(DelegateUIHelper.getDeprecateDelegateCheckBoxTitle());
                this.fDeprecateDelegateCheckBox.setSelection(DelegateUIHelper.loadDeprecateDelegateSetting(this.getMoveProcessor()));
                this.getMoveProcessor().setDeprecateDelegates(this.fDeprecateDelegateCheckBox.getSelection());
                this.fDeprecateDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getMoveProcessor().setDeprecateDelegates(fDeprecateDelegateCheckBox.getSelection());
                    }
                });
                this.fDeprecateDelegateCheckBox.setEnabled(this.fLeaveDelegateCheckBox.getSelection());
                this.fLeaveDelegateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        fDeprecateDelegateCheckBox.setEnabled(fLeaveDelegateCheckBox.getSelection());
                    }
                });
            }
            this.setControl((Control)composite);
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.jsdt.ui.move_members_wizard_page_context");
        }

        public void dispose() {
            DelegateUIHelper.saveLeaveDelegateSetting(this.fLeaveDelegateCheckBox);
            DelegateUIHelper.saveDeprecateDelegateSetting(this.fDeprecateDelegateCheckBox);
            super.dispose();
        }

        private void addLabel(Composite parent) {
            Label label = new Label(parent, 0);
            IMember[] members = this.getMoveProcessor().getMembersToMove();
            if (members.length == 1) {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_single, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)members[0], 0x20000AL)));
            } else {
                label.setText(Messages.format(RefactoringMessages.MoveMembersInputPage_destination_multi, String.valueOf(members.length)));
            }
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }

        private void addDestinationControls(Composite composite) {
            this.fDestinationField = new Combo(composite, 2052);
            this.fDestinationField.setFocus();
            this.fDestinationField.setLayoutData((Object)new GridData(768));
            this.fDestinationField.setItems(fgMruDestinations.toArray(new String[fgMruDestinations.size()]));
            this.fDestinationField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    this.handleDestinationChanged();
                }

                private void handleDestinationChanged() {
                    IStatus status = JavaScriptConventions.validateJavaScriptTypeName((String)fDestinationField.getText());
                    if (status.getSeverity() == 4) {
                        this.error(status.getMessage());
                    } else {
                        try {
                            IStatus validationStatus;
                            IType declaring = this.getMoveProcessor().getDeclaringType();
                            IType resolvedType = declaring.getJavaScriptProject().findType(fDestinationField.getText());
                            if (resolvedType == null) {
                                resolvedType = declaring.getJavaScriptProject().findType(declaring.getPackageFragment().getElementName(), fDestinationField.getText());
                            }
                            if ((validationStatus = MoveMembersInputPage.validateDestinationType(resolvedType, fDestinationField.getText())).isOK()) {
                                this.setErrorMessage(null);
                                this.setPageComplete(true);
                            } else {
                                this.error(validationStatus.getMessage());
                            }
                        }
                        catch (JavaScriptModelException ex) {
                            JavaScriptPlugin.log(ex);
                            this.error(RefactoringMessages.MoveMembersInputPage_invalid_name);
                        }
                    }
                }

                private void error(String message) {
                    this.setErrorMessage(message);
                    this.setPageComplete(false);
                }
            });
            if (fgMruDestinations.size() > 0) {
                this.fDestinationField.select(0);
            } else {
                this.setPageComplete(false);
            }
            JavaTypeCompletionProcessor processor = new JavaTypeCompletionProcessor(false, false, true);
            IPackageFragment context = (IPackageFragment)this.getMoveProcessor().getDeclaringType().getAncestor(4);
            processor.setPackageFragment(context);
            ControlContentAssistHelper.createComboContentAssistant(this.fDestinationField, processor);
            TextFieldNavigationHandler.install(this.fDestinationField);
            Button button = new Button(composite, 8);
            button.setText(RefactoringMessages.MoveMembersInputPage_browse);
            button.setLayoutData((Object)new GridData());
            SWTUtil.setButtonDimensionHint(button);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    this.openTypeSelectionDialog();
                }
            });
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private void initializeRefactoring() {
            try {
                String destination = this.fDestinationField.getText();
                if (!fgMruDestinations.remove(destination) && fgMruDestinations.size() >= 10) {
                    fgMruDestinations.remove(fgMruDestinations.size() - 1);
                }
                fgMruDestinations.add(0, destination);
                this.getMoveProcessor().setDestinationTypeFullyQualifiedName(destination);
            }
            catch (JavaScriptModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), RefactoringMessages.MoveMembersInputPage_move_Member, RefactoringMessages.MoveMembersInputPage_exception);
            }
        }

        private IJavaScriptSearchScope createWorkspaceSourceScope() {
            IJavaScriptElement[] project = new IJavaScriptElement[]{this.getMoveProcessor().getDeclaringType().getJavaScriptProject()};
            return SearchEngine.createJavaSearchScope((IJavaScriptElement[])project, (int)9);
        }

        private void openTypeSelectionDialog() {
            int elementKinds = 0;
            IJavaScriptSearchScope scope = this.createWorkspaceSourceScope();
            FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)this.getWizard().getContainer(), scope, elementKinds);
            dialog.setTitle(RefactoringMessages.MoveMembersInputPage_choose_Type);
            dialog.setMessage(RefactoringMessages.MoveMembersInputPage_dialogMessage);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    Assert.isTrue((selection.length <= 1 ? 1 : 0) != 0);
                    if (selection.length == 0) {
                        return new Status(4, JavaScriptPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    Object element = selection[0];
                    if (!(element instanceof IType)) {
                        return new Status(4, JavaScriptPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_Invalid_selection, null);
                    }
                    IType type = (IType)element;
                    return MoveMembersInputPage.validateDestinationType(type, type.getElementName());
                }
            });
            dialog.setInitialPattern(this.createInitialFilter());
            if (dialog.open() == 1) {
                return;
            }
            IType firstResult = (IType)dialog.getFirstResult();
            this.fDestinationField.setText(JavaModelUtil.getFullyQualifiedName(firstResult));
        }

        private String createInitialFilter() {
            if (!this.fDestinationField.getText().trim().equals("")) {
                return this.fDestinationField.getText();
            }
            return this.getMoveProcessor().getDeclaringType().getElementName();
        }

        private static IStatus validateDestinationType(IType type, String typeName) {
            if (type == null || !type.exists()) {
                return new Status(4, JavaScriptPlugin.getPluginId(), 0, Messages.format(RefactoringMessages.MoveMembersInputPage_not_found, typeName), null);
            }
            if (type.isBinary()) {
                return new Status(4, JavaScriptPlugin.getPluginId(), 0, RefactoringMessages.MoveMembersInputPage_no_binary, null);
            }
            return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        }

        private MoveStaticMembersProcessor getMoveProcessor() {
            return (MoveStaticMembersProcessor)this.getRefactoring().getAdapter(MoveStaticMembersProcessor.class);
        }
    }
}

